/*
 * CSVResourceReport.h - TaskJuggler
 *
 * Copyright (c) 2001, 2002, 2003, 2004 by Chris Schlaeger <cs@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * $Id: CSVResourceReport.h 1214 2005-11-17 20:05:36Z cs $
 */

#ifndef _CSVResourceReport_h_
#define _CSVResourceReport_h_

#include "CSVReport.h"

class Project;
class CSVResourceReportElement;

/**
 * @short Stores all information about an CSV resource report.
 * @author Chris Schlaeger <cs@kde.org>
 */
class CSVResourceReport : public CSVReport
{
public:
    CSVResourceReport(Project* p, const QString& f, const QString& df, int dl);
    virtual ~CSVResourceReport() { }

    virtual const char* getType() const { return "CSVResourceReport"; }

    bool generate();
    CSVResourceReportElement* getTable() { return tab; }

private:
    CSVResourceReport() { }

    CSVResourceReportElement* tab;
} ;

#endif
