//
//      tardy - a tar post-processor
//      Copyright (C) 1998, 1999, 2004, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_TAR_OUTPUT_TAR_BASE_H
#define COMMON_TAR_OUTPUT_TAR_BASE_H

#include <libtardy/file/output.h>
#include <libtardy/tar/header.h>
#include <libtardy/tar/output.h>

/**
  * The tar_output_tar_base class repereents a generic tar formatted
  * archive outpout, and the current state of the output.
  */
class tar_output_tar_base:
    public tar_output
{
public:
    /**
      * The destructor.
      */
    virtual ~tar_output_tar_base();

    /**
      * The constructor.
      */
    tar_output_tar_base(file_output *);

    // See base class for documentation.
    virtual void write_data(const void *, int);

    // See base class for documentation.
    virtual void write_data_padding();

    // See base class for documentation.
    virtual const char *filename() const;

    // See base class for documentation.
    virtual void write_archive_end();

    // See base class for documentation.
    virtual void set_block_size(long nbytes);

private:
    /**
      * The fp instance variable is used to remember where to send the
      * output, usually the file to write the output to.
      */
    file_output *fp;

    /**
      * The pos instance variable is used to remember the output file
      * position.
      */
    long pos;

    /**
      * The block_size instance variable is used to remember the size in
      * bytes of the output block size.  This is used for output padding
      * at the end of the archive.
      */
    long block_size;

    /**
      * The default constructor.  Do not use.
      */
    tar_output_tar_base();

    /**
      * The copy constructor.  Do not use.
      */
    tar_output_tar_base(const tar_output_tar_base &);

    /**
      * The assignment operator.  Do not use.
      */
    tar_output_tar_base &operator = (const tar_output_tar_base &);
};

#endif // COMMON_TAR_OUTPUT_TAR_BASE_H
