//
// tardy - a tar post-processor
// Copyright (C) 1991-1993, 1995, 1998, 1999, 2008, 2009 Peter Miller
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program. If not, see <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_ARGLEX_H
#define COMMON_ARGLEX_H

#include <libtardy/main.h>

enum arglex_token_ty
{
    arglex_token_eoln = -20,
    arglex_token_help,
    arglex_token_number,
    arglex_token_option,
    arglex_token_stdio,
    arglex_token_string,
    arglex_token_trace,
    arglex_token_version
};
typedef enum arglex_token_ty arglex_token_ty;

typedef struct arglex_table_ty arglex_table_ty;
struct arglex_table_ty
{
    const char      *t_name;
    arglex_token_ty t_token;
};

typedef struct arglex_value_ty arglex_value_ty;
struct arglex_value_ty
{
    const char      *alv_string;
    long            alv_number;
};

extern arglex_token_ty arglex_token;
extern arglex_value_ty arglex_value;

void arglex_init(int, char **, arglex_table_ty *);
arglex_token_ty arglex(void);
int arglex_compare(const char *formal, const char *actual);

#endif // COMMON_ARGLEX_H
