/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/tar/output/tar.cc
 */

#ifndef COMMON_TAR_OUTPUT_TAR_BASE_H
#define COMMON_TAR_OUTPUT_TAR_BASE_H

#include <file/output.h>
#include <tar/header.h>
#include <tar/output.h>

class tar_output_tar_base: public tar_output
{
	 private:
	 file_output *fp;
	 long pos;

	 public:
	 virtual ~tar_output_tar_base();
	 tar_output_tar_base(file_output *);
	 virtual void write_data(const void *, int);
	 virtual void write_data_padding();
	 virtual const char *filename() const;
	 virtual void write_archive_end();

	 protected:
	 tar_output_tar_base();
	 tar_output_tar_base(const tar_output_tar_base &);
	 tar_output_tar_base &operator = (const tar_output_tar_base &);
};

#endif /* COMMON_TAR_OUTPUT_TAR_BASE_H */
