/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/tar/output.cc
 */

#ifndef COMMON_TAR_OUTPUT_H
#define COMMON_TAR_OUTPUT_H

#include <tar/header.h>

class tar_output
{
	public:
	virtual ~tar_output();
	tar_output();
	void fatal(char *, ...) const;
	void nfatal(char *, ...) const;
	virtual void write_data(const void *, int) = 0;
	virtual void write_data_padding();
	virtual void write_header(const tar_header &) = 0;
	virtual void write_header_padding();
	virtual const char *filename() const = 0;

	virtual void write_archive_begin();
	virtual void write_archive_end();

	private:
	tar_output(const tar_output &);
	tar_output &operator = (const tar_output &);
};

#endif /* COMMON_TAR_OUTPUT_H */
