/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/file/input.cc
 */

#ifndef COMMON_FILE_INPUT_H
#define COMMON_FILE_INPUT_H

class file_input
{
	public:
	virtual ~file_input();
	void fatal(char *, ...) const;
	void nfatal(char *, ...) const;
	virtual int read(void *, int) const = 0;
	virtual const char *filename() const = 0;

	protected:
	file_input();

	private:
	file_input(const file_input &);
	file_input &operator = (const file_input &);
};

#endif /* COMMON_FILE_INPUT_H */
