/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_CONNECTION_MANAGER_H
#define QTTAPIOCA_CONNECTION_MANAGER_H

#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QVariant>
#include <QtDBus/QDBusObjectPath>
#include <QtTapioca/DBusProxyObject>

namespace QtTapioca {

class ConnectionManagerPrivate;
class Connection;

class ConnectionManager: public DBusProxyObject {
    Q_OBJECT
    Q_PROPERTY(QString name READ name)
    Q_DECLARE_PRIVATE(ConnectionManager)

public:
    class Parameter {
    public:
        enum Flags {
            None       = 0x00,
            Required   = 0x01,
            Register   = 0x02,
            HasDefault = 0x04,
            All        = 0xFF
        };

        Parameter();
        Parameter(const QString &name, const QVariant value = QVariant());
        ~Parameter();
        QString name() const { return m_name; };
        QVariant value() const { return m_value; };
        Flags flags() const { return (Flags) m_flags; };

        bool operator==(const Parameter &param) const;
        bool operator==(const QString &name) const;

    private:
        friend class ConnectionManager;
        Parameter(const QString &name, const QVariant value, Flags flags);
        QString m_name;
        QVariant m_value;
        uint m_flags;
    };

    ~ConnectionManager();

    QString name() const;

    bool isRunning() const;

    QList<Connection *> connections() const;
    Connection *requestConnection(const QString &protocol, const QList<Parameter> &paramsList);

    bool supports(const QString &protocol) const;
    const QStringList supportedProtocols() const;
    const QList<Parameter> &protocolParameters(const QString &protocol);

Q_SIGNALS:
    void newConnection(QtTapioca::Connection *connection);

private Q_SLOTS:
    void onNewConnection(const QString &serviceName, const QDBusObjectPath &objPath, const QString &proto);
    void onConnectionDestroyed(QObject *obj);

private:
    friend class ConnectionManagerFactory;

    ConnectionManager(const QString configFile, const QString &name, QObject *parent = 0);
    void readConfig();
    void loadConnections();
    Connection *addConnection(const QString &serviceName, const QDBusObjectPath &objPath);
    QVariant charToVariant(const QChar type);

    ConnectionManagerPrivate *d;
};

} // namespace

#endif

