/*
 * Serializer for tagcolledit
 *
 * Copyright (C) 2005  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "Serializer.h"
#include "Tag.h"
#include "TagSet.h"

using namespace std;

namespace Tagcoll
{

std::string TCEConverter::operator()(const Tag& item) const
{
	return item.fullname();
}

OpSet<std::string> TCEConverter::operator()(const OpSet<Tag>& items) const
{
	OpSet<std::string> res;
	for (OpSet<Tag>::const_iterator i = items.begin();
			i != items.end(); i++)
		if (*i)
			res += (*this)(*i);
	return res;
}

Tag TCEConverter::operator()(const std::string& item) const
{
	return _voc.obtainTag(item);
}

OpSet<Tag> TCEConverter::operator()(const OpSet<std::string>& items) const
{
	OpSet<Tag> res;
	for (OpSet<std::string>::const_iterator i = items.begin();
			i != items.end(); i++)
	{
		Tag p = (*this)(*i);
		if (p)
			res += p;
	}
	return res;
}

}

// vim:set ts=4 sw=4:
