#ifndef TAGCOLL_DOCUMENT_H
#define TAGCOLL_DOCUMENT_H

/*
 * Tagged Collection document for a Document-View editing architecture
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <sigc++/sigc++.h>

//#include <tagcoll/TagCollection.h>
#include <tagcoll/InputMerger.h>
#include <tagcoll/ParserBase.h>
#include <tagcoll/TagcollConsumer.h>
#include <tagcoll/Patches.h>
#include "Tag.h"
#include "TagSet.h"

#include <vector>

template<class ITEM>
class TagcollDocument
{
public:
	typedef SigC::Signal0<void> type_signal_changed;
	typedef SigC::Signal0<void> type_signal_filename_changed;

protected:
	//Tagcoll::TagCollection<ITEM, Tagcoll::Tag> _collection;
	Tagcoll::InputMerger<ITEM, Tag> _collection;
	FacetSet _facets;

	std::vector< Tagcoll::PatchList<ITEM, Tag> > _undoBuffer;
	unsigned int _undoTail;
	std::string _fileName;

	type_signal_changed _signal_changed;
	type_signal_filename_changed _signal_filename_changed;

public:
	TagcollDocument() throw () : _undoTail(0) {}
	virtual ~TagcollDocument() {}
	
	Tagcoll::TaggedCollection<ITEM, Tag>& collection() throw () { return _collection; }
	const Tagcoll::TaggedCollection<ITEM, Tag>& collection() const throw () { return _collection; }

	FacetSet& vocabulary() throw () { return _facets; }
	const FacetSet& vocabulary() const throw () { return _facets; }

	// Apply a change, appending the reverse change in the undo buffer
	void applyChange(const Tagcoll::PatchList<ITEM, Tag>& change);

	bool canUndo() const;
	bool canRedo() const;

	void undo();
	void redo();

	void load(const std::string& file) throw (FileException, ParserException);
	void loadDebtags() throw (FileException, ParserException);
	void save(const std::string& file) throw (FileException);

	void output(Tagcoll::TagcollConsumer<ITEM, Tag>& consumer) throw ();

	const std::string& fileName() const throw () { return _fileName; }

	type_signal_changed signal_changed() throw () { return _signal_changed; }
	type_signal_filename_changed signal_filename_changed() throw () { return _signal_filename_changed; }

	virtual void do_changed();
	virtual void do_filename_changed();
};

// vim:set ts=4 sw=4:
#endif
