/*
 * tagged collection - Experimental programs to test and study tagged collections
 *
 * Copyright (C) 2003,2004,2005,2006  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>
#include "TagcollOptions.h"
#include "TaggrepOptions.h"
#include "TagidxOptions.h"
#include <iostream>

using namespace std;
using namespace Tagcoll;

int main(int argc, const char* argv[])
{
	try {
		if (argc == 1)
			throw commandline::BadOption("no arguments provided");

		string cmd(argv[1]);
		string hooks(argc > 2 ? argv[2] : "");

		if (cmd == "tagcoll")
		{
			commandline::TagcollOptions opts;
			commandline::Manpage help("tagcoll", VERSION);
			if (!hooks.empty())
				help.readHooks(hooks);
			help.output(cout, opts, 1);
		}
		else if (cmd == "taggrep")
		{
			commandline::TaggrepOptions opts;
			commandline::Manpage help("taggrep", VERSION);
			if (!hooks.empty())
				help.readHooks(hooks);
			help.output(cout, opts, 1);
		}
		else if (cmd == "tagidx")
		{
			commandline::TagidxOptions opts;
			commandline::Manpage help("tagidx", VERSION);
			if (!hooks.empty())
				help.readHooks(hooks);
			help.output(cout, opts, 1);
		}
		else
			throw commandline::BadOption("unknown command " + cmd);

		return 0;
	} catch (commandline::BadOption& e) {
		cerr << e.desc() << endl << endl;
		cerr << "Usage: manpage <command>" << endl << endl;
		cerr << "Supported commands are: tagcoll" << endl;
		return 1;
	} catch (Exception& e) {
		fprintf(stderr, "%s: %.*s\n", e.type(), PFSTR(e.desc()));
		return 1;
	}
}

// vim:set ts=4 sw=4:
