%{
/*
 * Parser for tag expressions
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

/* Program prefix */

#define YYSTYPE Tagcoll::Expression

#include "TagexprParser.h"
#include "Tagexpr_parser_y.h"

%}

%option noyywrap

space	[ \t]+
tag		[^ \t\n&|!()]+

%%

{tag}	{ yylval = Tagcoll::Expression::matchTag(yytext); return TAG; }

&&		{ return AND; }

\|\|		{ return OR; }

\(		{ return LPAREN; }

\)		{ return RPAREN; }

!		{ return NOT; }

{space}	{ /* space */ }

%%

/* vim:set syntax=lex ts=4 sw=4: */
