#ifndef STRINGF_H
#define STRINGF_H

/** \file
 * Generic std::string helpers
 */

/*
 * Copyright (C) 2003,2004,2005  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <string>

#ifndef ATTR_PRINTF
 #ifdef GCC
  #define ATTR_PRINTF(string, first) __attribute__((format (printf, string, first)))
 #else
  #define ATTR_PRINTF(string, first)
 #endif
#endif

namespace stringf
{
	/// Format the printf-style arguments and add the result to `str'
	int addf(std::string& str, const char* fmt, ...) throw() ATTR_PRINTF(2, 3);

	/// Format the printf-style arguments and return the result as a string 
	std::string fmt(const char* fmt, ...) throw() ATTR_PRINTF(1, 2);

	std::string fmt(int val) throw ();
	std::string fmt(unsigned int val) throw ();
	std::string fmt(long int val) throw ();
	std::string fmt(long unsigned int val) throw ();
	// Useful only in templates
	inline std::string fmt(const std::string& str) throw () { return str; }
};

/// Pass a string to a printf-like function for a %.*s argument
#define PFSTR(str) (int)(str).size(), (str).data()

// vim:set ts=4 sw=4:
#endif
