/*
 * Group items having the same tagset
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/ItemGrouper.h>

#ifndef INSTANTIATING_TEMPLATES
#include <string>

namespace Tagcoll {
template class ItemGrouper<std::string, std::string>;
}
#endif

#ifdef COMPILE_TESTSUITE

#include <tests/test-utils.h>

namespace tut {
using namespace tut_tagcoll;

struct tagcoll_itemgrouper_shar {
};
TESTGRP(tagcoll_itemgrouper);

template<> template<>
void to::test<1>()
{
	ItemGrouper<string, string> coll;

	output_test_collection(coll);
	test_readonly_collection(coll);
}

template<> template<>
void to::test<2>()
{
	ItemGrouper<string, string> coll;

	test_collection(coll);
}

}

#endif


// vim:set ts=4 sw=4:
