#ifndef _MODSUP_H
#define _MODSUP_H

#include "data.h"

#define MAXGMODULES	20

#define HANDLERTYPES	5

#define CLASS_HND	0 /* Handler for <class> restrictions */
#define ROOM_HND	1 /* Handler for <room> restrictions */
#define SUBJECT_HND	2 /* Handler for <subject> restrictions */
#define TUPLE_HND	3 /* Handler for <subject> restrictions within <timetable> */
#define OPTION_HND	4 /* Handler for <option> */

/* Handler for <teacher> restrictions */
/* This is not used, would require a major change in xmlsup */
/* NOTE: restrictions for teachers can be implemented using SUBJECT_HND */

/* #define TEACHERHANDLER 5 */

typedef int (*gfunc)(chromo *t, int *cpnt, int *tpnt, int **start, int **lead);

/* char *type : type of capability
 * char *cont : content 		*/
typedef int (*parhandler)(char *type, char *cont, int id);

typedef int (*ifunc)();

struct _parop {
	char *type;
	parhandler parfunc;
};

typedef struct _parop parop;

struct _gmodule {
	void *handle;	
	char name[64];

	int sum;	/* How many tuples have failed this restriction */
	int mnd;	/* Is this a hard restriction */
	int weight;	 

	gfunc gradefunc;
	ifunc initfunc;
	ifunc precalcfunc;

	parop *handlers[HANDLERTYPES]; 
};

typedef struct _gmodule gmodule;

extern gmodule **glist;
extern int gnum;

extern char moderror[256];

int load_module(char *name, int weight, int mnd); 
int find_module(char *name);
int call_onehandler(char *type, char *name, int id, int htype, int mod);
int call_handler(char *type, char *name, int id, int htype);

#endif
