/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: modsup.c,v 1.15 2005/01/13 18:28:05 avian Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "main.h"
#include "modsup.h"
#include "error.h"
#include "gettext.h"

gmodule **glist;

int gnum=0;

char moderror[256];

/* Returned values: 
 * 	0: Handler called, OK
 * 	1: Handler called, returned error
 * 	2: Handler not found in this module
 */
int call_onehandler(char *type, char *name, int id, int htype, int mod)
{
	int n,m;
	int called;

	if(glist[mod]->handlers[htype]==NULL) return(2);

	n=0;
	called=0;
	while(glist[mod]->handlers[htype][n].type!=0) {
		if(!strcmp(glist[mod]->handlers[htype][n].type,type)) {
			m=(*glist[mod]->handlers[htype][n].parfunc)(type,name,id);
			if(m) return(1);
			called=1;
		}

		n++;
	}
	if(!called) {
		return(2);
	} else {
		return(0);
	}
}

/* Returned values: 
 * 	0: Handler called, OK
 * 	1: Handler called, returned error
 * 	2: Handler not found in any module
 */
int call_handler(char *type, char *name, int id, int htype)
{
	int mod,m;
	int called;

	called=0;
	for(mod=0;mod<gnum;mod++) {
		m=call_onehandler(type, name, id, htype, mod);
		if(m==1) return(1);
		if(m==0) called=1;
	}
	if(!called) {
		return(2);
	} else {
		return(0);
	}
}

int find_module(char *name)
{
        int c;

        for(c=0;c<gnum;c++) {
                if (!strcmp(glist[c]->name, name)) return(c);
        }

        return(-1);
}

int load_module(char *name, int weight, int mnd) {
	void *handle;
	char pathname[1024];
	int c;

	snprintf(pathname, 1024, "%s/%s", HAVE_MODULE_PATH, name);
	handle=dlopen(pathname, RTLD_NOW);

	if(!handle) tell("modsup", MSG_FATAL, dlerror());

	if (gnum%MAXGMODULES==0) {
		c=sizeof(*glist)*(gnum+MAXGMODULES);
        	if (gnum==0) {
			glist=malloc(c);
		} else {
			glist=realloc(glist, c);
		}
		if(glist==NULL) fatal(_("Can't allocate memory"));
	}

	glist[gnum]=malloc(sizeof(**glist));
	strncpy(glist[gnum]->name, name, 64);

	glist[gnum]->handle=handle;
	glist[gnum]->gradefunc=dlsym(handle,"grade_function");

	if(!glist[gnum]->gradefunc) tell("modsup", MSG_FATAL, dlerror());

	glist[gnum]->handlers[SUBJECT_HND]=dlsym(handle,"subject_restrictions");
	glist[gnum]->handlers[CLASS_HND]=dlsym(handle,"class_restrictions");
	glist[gnum]->handlers[ROOM_HND]=dlsym(handle,"room_restrictions");
	glist[gnum]->handlers[OPTION_HND]=dlsym(handle, "options");
	glist[gnum]->handlers[TUPLE_HND]=dlsym(handle, "tuple_restrictions");

	glist[gnum]->weight=weight;
	glist[gnum]->mnd=mnd;

	glist[gnum]->initfunc=dlsym(handle,"init_mod");
	glist[gnum]->precalcfunc=dlsym(handle,"precalc_mod");

	return(gnum++);
}
