/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: modinfo.c,v 1.3 2004/08/10 19:12:52 avian Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <dlfcn.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#undef HAVE_LIBPVM3

#include "error.h"
#include "modsup.h"

#include "gettext.h"

char *cmd;

void print_banner()
{
        printf(_("TABLIX version %s, PGA highschool timetable generator\n"), VERSION);
        printf("Copyright (C) 2002-2004 Tomaz Solc\n");
}

void print_copyright()
{
	print_banner();
        printf("\n");
        printf(_("\
This program is free software; you can redistribute it and/or modify\n\
it under the terms of the GNU General Public License as published by\n\
the Free Software Foundation; either version 2 of the License, or\n\
(at your option) any later version.\n"));
        printf("\n");
        printf(_("\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n"));
        printf("\n");
        printf(_("\
You should have received a copy of the GNU General Public License\n\
along with this program; if not, write to the Free Software\n\
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA\n"));
        printf("\n");

        printf("$Id: modinfo.c,v 1.3 2004/08/10 19:12:52 avian Exp $\n");
}

void print_syntax()
{
	print_banner();
        printf(_("Usage: %s [OPTION]... [MODULE]\n"), cmd);
        printf("\n");
        printf(_("\
  -h                    display this help\n\
  -v                    display version and copyright information\n\
  -d LEVEL              verbosity level (default 2)\n"));

        printf("\n");
        printf(_("Please report bugs to <tomaz.solc@siol.net>.\n"));
        exit(0);
}

void print_restrictions(int htype, int mod)
{
	int n;

	if(glist[mod]->handlers[htype]!=NULL) {
		n=0;
		while(glist[mod]->handlers[htype][n].type!=0) {
			printf("%s ", glist[mod]->handlers[htype][n].type);
			n++;
		}
	}
	printf("\n");
}

int main(int argc, char *argv[])
{
        int c,m;

        char module[256];

	#if ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
	#endif

        cmd=argv[0];
	curmodule="tablix_modinfo";
	verbosity=102;
	
        /* *** Parse command line options               *** */

        while ((c=getopt(argc, argv, "ho:vs:d:"))!=-1) {
                switch (c) {
                        case 'v': print_copyright();
        			  exit(0);
                        case 'h':
                        case '?': print_syntax();
                                  exit(0);
			case 'd': sscanf(optarg, "%d", &verbosity);
				  verbosity+=100;
				  break;
                }
        }

        if (!(optind<argc)) {
                fatal(_("Missing module name. Try '%s -h' for more information."), cmd);
        }

        strncpy(module, argv[optind], 256);

	m=load_module(module,0,0);

	printf("Module name          : %s\n\n", module);

	printf("Subject restrictions : ");
	print_restrictions(SUBJECT_HND, m);
	printf("Class restrictions   : ");
	print_restrictions(CLASS_HND, m);
	printf("Room restrictions    : ");
	print_restrictions(ROOM_HND, m);
	printf("Tuple restrictions   : ");
	print_restrictions(TUPLE_HND, m);

	printf("\n");
	printf("Module options       : ");
	print_restrictions(OPTION_HND, m);

	if(verbosity>102) {
		printf("\n");
		printf("Init function        : ");
		if(glist[m]->initfunc!=NULL) {
			printf("Defined\n");
		} else {
			printf("Not defined\n");
		}

		printf("Pre-calc function    : ");
		if(glist[m]->precalcfunc!=NULL) {
			printf("Defined\n");
		} else {
			printf("Not defined\n");
		}
	}
        return(0);
}
