/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002-2004 Tomaz Solc                                      */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: main.c,v 1.62 2004/10/17 09:37:06 avian Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/time.h>
#include <errno.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_LIBPVM3
  #include <pvm3.h>
#else
  #include <signal.h>
#endif

#include "data.h"
#include "main.h"
#include "xmlsup.h"
#include "error.h"
#include "transfer.h"

#include "modsup.h"
#include "gettext.h"

static chromo *parentpop;

static int *buffer;     /* Time lookup table needed by grade_chromo()   */
static int **lead;      /* with pointers */
static int **start;

#ifndef HAVE_LIBPVM3
static int ctrlc;
#endif

#define RANDOM(a)	((int) (((double) a)*rand()/RAND_MAX))

static void grade_chromo(chromo *t)
{
        int d,c;
        int *pnt,*cpnt;
	int time;

        /* There is an array for each c in TIMES.  */
        /* Begins with start[c], ends with lead[c] */

        for(c=0;c<TIMES;c++) {
                lead[c]=start[c];
        }

        /* We put tuplenums in these arrays and then scan them for */
        /* conflicting tuples                                      */

        for(c=0;c<tuplenum;c++) {
		time=t->inf[c].time;
                *lead[time]=c;
                lead[time]++;
        }

        extend_chromo(t);
        cpnt=cextbuff;

        textend_chromo(t);
        pnt=textbuff;

	t->possible=0;
        t->grade=0;

	for(c=0;c<gnum;c++) {
		d=(*glist[c]->gradefunc)(t, cpnt, pnt, start, lead);

	        t->subtotals[c]=d;
		t->grade+=d*glist[c]->weight;
		if(glist[c]->mnd) t->possible+=d;
	}

        if (t->possible) t->grade+=posweight;
}

/* Following code taken from SDL */
static __inline__ void SDL_memcpyMMX8(void* to,void* from,int len)
{
	int i;

	for(i=0; i<len; i++) {
		__asm__ __volatile__ (
		"	movq (%0), %%mm0\n"
		"	movq %%mm0, (%1)\n"
		: : "r" (from), "r" (to) : "memory");
		from+=8;
		to+=8;
	}
}
/* End of SDL code */

static void mate_chromo(chromo *t1, chromo *t2, chromo *b1, chromo *b2)
{
        int a,b,c;

        a=rand()%tuplemut;
        b=rand()%tuplemut;
/*
	if(a<b) {
		memcpy(&b1->inf[0],&t2->inf[0],a*8);
		memcpy(&b2->inf[0],&t1->inf[0],a*8);

		memcpy(&b1->inf[b],&t1->inf[b],(tuplemut-b)*8);
		memcpy(&b2->inf[b],&t2->inf[b],(tuplemut-b)*8); 
		
		SDL_memcpyMMX8(&b1->inf[0],&t2->inf[0],a);
		SDL_memcpyMMX8(&b2->inf[0],&t1->inf[0],a);

		SDL_memcpyMMX8(&b1->inf[b],&t1->inf[b],(tuplemut-b));
		SDL_memcpyMMX8(&b2->inf[b],&t2->inf[b],(tuplemut-b)); 

		for(c=a;c<b;c++) {
			b2->inf[c].time=t2->inf[c].time;
			b1->inf[c].room=t2->inf[c].room;

			b1->inf[c].time=t1->inf[c].time;
			b2->inf[c].room=t1->inf[c].room;
		} 
	} else {
		memcpy(&b1->inf[0],&t2->inf[0],b*8);
		memcpy(&b2->inf[0],&t1->inf[0],b*8);

		memcpy(&b1->inf[a],&t1->inf[a],(tuplemut-a)*8);
		memcpy(&b2->inf[a],&t2->inf[a],(tuplemut-a)*8); 
		
		SDL_memcpyMMX8(&b1->inf[0],&t2->inf[0],b);
		SDL_memcpyMMX8(&b2->inf[0],&t1->inf[0],b);

		SDL_memcpyMMX8(&b1->inf[a],&t1->inf[a],(tuplemut-a));
		SDL_memcpyMMX8(&b2->inf[a],&t2->inf[a],(tuplemut-a)); 

		for(c=b;c<a;c++) {
			b1->inf[c].time=t2->inf[c].time;
			b2->inf[c].room=t2->inf[c].room;

			b2->inf[c].time=t1->inf[c].time;
			b1->inf[c].room=t1->inf[c].room;
		} 
	}*/
/*
        for(c=0;c<tuplemut;c++) {
                if (c<a) {
                        if(b2->inf[c].time!=t1->inf[c].time) {
				error("bad1!");
			}
                        if(b1->inf[c].time!=t2->inf[c].time) {
				error("bad2!");
			}
                } else {
                        if(b2->inf[c].time!=t2->inf[c].time) {
				error("bad3!");
			}
                        if(b1->inf[c].time!=t1->inf[c].time) {
				error("bad4!");
			}
                }
                if (c<b) {
                        if(b2->inf[c].room!=t1->inf[c].room) {
				error("bad5!");
			}
                        if(b1->inf[c].room!=t2->inf[c].room) {
				error("bad6!");
			}
                } else {
                        if(b2->inf[c].room!=t2->inf[c].room) {
				error("bad7!");
			}
                        if(b1->inf[c].room!=t1->inf[c].room) {
				error("bad8!");
			}
                }
        } 
*/
        for(c=0;c<tuplemut;c++) {
                if (c<a) {
                        b1->inf[c].time=t2->inf[c].time;
                        b2->inf[c].time=t1->inf[c].time;
                } else {
                        b2->inf[c].time=t2->inf[c].time;
                        b1->inf[c].time=t1->inf[c].time;
                }
                if (c<b) {
                        b1->inf[c].room=t2->inf[c].room;
                        b2->inf[c].room=t1->inf[c].room;
                } else {
                        b2->inf[c].room=t2->inf[c].room;
                        b1->inf[c].room=t1->inf[c].room;
                }
        }  

        b1->grade=-1;
        b2->grade=-1;
}

static void mutate_chromo(chromo *t1)
{
        int a,b;
        int temp;

        a=rand()%tuplemut;
        b=rand()%tuplemut;

        temp=t1->inf[a].time;
        t1->inf[a].time=t1->inf[b].time;
        t1->inf[b].time=temp;

        a=rand()%tuplemut;
        b=rand()%tuplemut;

        temp=t1->inf[a].room;
        t1->inf[a].room=t1->inf[b].room;
        t1->inf[b].room=temp;
        t1->grade=-1;
}

static void rand_chromo(chromo *t1)
{
        int a,b;

        a=rand()%tuplemut;
        b=rand()%tuplemut;

        t1->inf[a].time=rand()%TIMES;
        t1->inf[b].room=rand()%rmapnum;
        t1->grade=-1;
}

static int compare_chromo(const void *t1, const void *t2)
{
        return(((chromo *)t1)->grade-((chromo *)t2)->grade);
}

#ifndef HAVE_LIBPVM3
static void sighandler(int num)
{
        if (ctrlc<1) {
                ctrlc++;
        } else {
                exit(1);
        }
}
#endif

static void lsearch_chromo(chromo *t)
{
	int bestc=0, besttime=0, bestroom=0;
	int bestgr,oldbestgr;

	int c,time,room,b;

	bestgr=t->grade;

	b=0;

	do {
		oldbestgr=bestgr;

		for(c=0;c<tuplemut;c++) {
			time=t->inf[c].time;
			room=t->inf[c].room;

			if(time<TIMES-1) {
				t->inf[c].time=time+1;
				grade_chromo(t);

				if(t->grade<=bestgr) {
					besttime=time+1;
					bestroom=room;
					bestc=c;
					bestgr=t->grade;
				}
			}

			if(time>0) {
				t->inf[c].time=time-1;
				grade_chromo(t);

				if(t->grade<=bestgr) {
					besttime=time-1;
					bestroom=room;
					bestc=c;
					bestgr=t->grade;
				}
			}

			t->inf[c].time=time;

			if(room<rmapnum-1) {
				t->inf[c].room=room+1;
				grade_chromo(t);

				if(t->grade<=bestgr) {
					besttime=time;
					bestroom=room+1;
					bestc=c;
					bestgr=t->grade;
				}
			}

			if(room>0) {
				t->inf[c].room=room-1;
				grade_chromo(t);

				if(t->grade<=bestgr) {
					besttime=time;
					bestroom=room-1;
					bestc=c;
					bestgr=t->grade;
				}
			}

			t->inf[c].room=room;
		}

		t->inf[bestc].room=bestroom;
		t->inf[bestc].time=besttime;

		#ifndef HAVE_LIBPVM3
		printf("%d\n", bestgr);
		#endif
		b++;

	} while(bestgr<oldbestgr&&b!=-1);

	#ifndef HAVE_LIBPVM3
	printf("-\n");
	#endif
}

static int main_init()
{
	int c;

        parentpop=malloc(sizeof(*parentpop)*POPSIZE);
	if(parentpop==NULL) return 1;

        for(c=0;c<POPSIZE;c++) {
                parentpop[c].inf=malloc(sizeof(*parentpop[c].inf)*tuplenum);
		if(parentpop[c].inf==NULL) return 1;

		parentpop[c].subtotals=malloc(sizeof(*parentpop[c].subtotals)*gnum);
		if(parentpop[c].subtotals==NULL) return 1;
        }

        /* Various buffers for grading algorithm */
        buffer=malloc(tuplenum*TIMES*sizeof(*buffer));
	if(buffer==NULL) return 1;
        lead=malloc(TIMES*sizeof(*lead));
	if(lead==NULL) return 1;
        start=malloc(TIMES*sizeof(*start));
	if(start==NULL) return 1;

        for(c=0;c<TIMES;c++) {
                start[c]=buffer+c*tuplenum;
                lead[c]=start[c];
        }

	return 0;
}

static void main_exit()
{
	int c;

	for(c=0;c<POPSIZE;c++) {
		free(parentpop[c].inf);
		free(parentpop[c].subtotals);
	}
	free(parentpop);
	free(buffer); free(lead); free(start);
}

int main(int argc, char *argv[])
{
        int a,b,c,d,u;
        int temp;
        int g1, g2;

        struct timeval t;

        char xmlsrc[256];

        int restore;

        FILE *tmpfile;

        #ifdef HAVE_LIBPVM3
          int parent, sibling;
          char *tmpbuff;
        #else
          char prefix[256];
          FILE *saved;
	  int timeout;
          #ifdef HAVE_CONV
            FILE *convfile;
            char dname[256];
          #endif
        #endif

	#if ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
	#endif

	curmodule="kernel";

        restore=-1;

        /* *** Get new random seed                      *** */
        gettimeofday(&t, NULL);

        srand(t.tv_usec);              /* <-- should this be fixed? */

        /* *** Parse command line options               *** */
        #ifdef HAVE_LIBPVM3
        #else
        strcpy(prefix, "./");
	verbosity=102;
	timeout=0;

        while ((c=getopt(argc, argv, "o:rd:t:p:"))!=-1) {
                switch (c) {
                        case 'o': strncpy(prefix, optarg, 256);
                                  break;
                        case 'r': restore=1;
				  break;
			case 'd': sscanf(optarg, "%d", &verbosity);
				  verbosity+=100;
				  break;
			case 't': sscanf(optarg, "%d", &timeout);
				  break;
			#ifdef TUNABLE_PARAMS
			case 'p': if(!get_params(optarg)) {
					fatal(_("Parameter syntax error"));
				  }
			#else
			case 'p': info(_("Tunable parameters not enabled"));
				  break;
			#endif
                }
        }
        if (!(optind<argc)) fatal(_("Wrong arguments"));

	#ifdef TUNABLE_PARAMS
	print_params();
	#endif
        #endif

	/* *** Get proper locale from parent *** */
        #ifdef HAVE_LIBPVM3
        parent=pvm_parent();

	tmpbuff=malloc(LINEBUFFSIZE);
        pvm_recv(parent, MSG_PARAMS);
	#if ENABLE_NLS
        pvm_upkstr(tmpbuff);

	setlocale(LC_ALL, tmpbuff);
	setenv("LC_ALL", tmpbuff, 1);
	{
		extern int _nl_msg_cat_cntr;
		_nl_msg_cat_cntr++;
	}
	#endif

	#ifdef TUNABLE_PARAMS
	pvm_upkstr(tmpbuff);

	if(!get_params(tmpbuff)) {
		fatal(_("Parameter syntax error"));
	}
	#endif

	free(tmpbuff);

	pvm_upkint(&verbosity, 1, 1);

        /* *** Get XML input (via pvm3 or local file)   *** */

        tmpnam(xmlsrc);

	if (file_recv(xmlsrc, parent, MSG_XMLDATA)) {
		error(strerror(errno));
        	fatal(_("Can't open temporary file"));
	}

        #else
        strncpy(xmlsrc, argv[optind], 256);
        #endif

        xmlsup_main(xmlsrc);

	if(tuplemut<1) {
		fatal(_("All tuples immutable"));
	}

        #ifdef HAVE_LIBPVM3
        unlink(xmlsrc);
        #endif

        /* *** Open file for convergence info           *** */
        #if (!HAVE_LIBPVM3 && HAVE_CONV)
        snprintf(dname, 256, "%sconv.txt", prefix);
        convfile=fopen(dname, restore>0?"a":"w");
        #endif

        /* *** First population (restore if necessary)  *** */

	c=main_init();

	if(c) {
		fatal(_("Can't allocate memory"));
	}
	/* Report back to master how many modules have we loaded */

	#ifdef HAVE_LIBPVM3
        pvm_initsend(0);
        pvm_pkint(&gnum, 1, 1);
        pvm_send(parent, MSG_MODINFO);
	#else
	printf(_("Loaded %d modules\n"), gnum);	
	#endif

        #ifdef HAVE_LIBPVM3
        pvm_recv(parent, MSG_RESTOREPOP);
        pvm_upkint(&restore, 1, 1);
        #else
        if (restore>0) {
                snprintf(xmlsrc, 256, "%ssave.txt", prefix);
                saved=fopen(xmlsrc, "r");
                if (saved==NULL) {
                        perror("tablix");
                        exit(1);
                }
                fscanf(saved, "%d", &restore);
        }
        #endif

        if (restore>0&&restore!=tuplenum) fatal(_("XML input and saved population mismatch"));

        if (restore<=0) {
                u=1;
                for(c=0;c<POPSIZE;c++) {
                        for(b=0;b<tuplemut;b++) {
                                parentpop[c].inf[b].time=rand()%TIMES;
                                parentpop[c].inf[b].room=rand()%rmapnum;
                        }
                        for(b=tuplemut;b<tuplenum;b++) {
                                parentpop[c].inf[b].time=tuplemap[b].imut_time;
                                parentpop[c].inf[b].room=tuplemap[b].imut_room;
                        }
                        parentpop[c].grade=-1;
                }
        } else
        #ifdef HAVE_LIBPVM3
        {
                pvm_upkint(&u, 1, 1);
                for(c=0;c<POPSIZE;c++) {
                        pvm_upkint((int *) parentpop[c].inf, tuplenum*2, 1);
                        parentpop[c].grade=-1;
                }
        }
        #else
        {
                fscanf(saved, "%d", &u);
                for(c=0;c<POPSIZE;c++) {
                        for(b=0;b<tuplenum;b++) {
                                fscanf(saved, "%d %d", &parentpop[c].inf[b].time, &parentpop[c].inf[b].room);
                        }
                        fscanf(saved, "%s", xmlsrc);
                        if (strcmp(xmlsrc, "+")) fatal(_("XML input and saved population mismatch"));
                        parentpop[c].grade=-1;
                }

                fclose(saved);
        }
        #endif

        /* *** Get initial sibling tid (pvm3 only)      *** */
        #ifdef HAVE_LIBPVM3
        pvm_recv(parent, MSG_SIBLING);
        pvm_upkint(&sibling, 1, 1);
        pvm_notify(PvmTaskExit, MSG_MASTERKILL, 1, &parent);
        #endif

	/* TODO: more information here. how many restrictions for example */
	if(restore>0) {
        	info(_("I have restored %d tuples (%d immutable)"), tuplenum, tuplenum-tuplemut);
	} else {
        	info(_("I have %d tuples (%d immutable)"), tuplenum, tuplenum-tuplemut);
	}

        /* *** Install signal handler (non-pvm3 only)   *** */
        #ifndef HAVE_LIBPVM3
        ctrlc=0;
        signal(SIGINT, sighandler);
        signal(SIGALRM, sighandler);
	alarm(timeout*60);
        #endif

        data_init();

        g1=GRADEMAX;
        g2=0;

        /* ***                                          *** */
        /* *** MAIN LOOP (Magic starts here)            *** */
        /* ***                                          *** */
	/* *** (needs cleaning - move everything 	*** */
	/* *** related to GA to genetic.c)		*** */
        /* ***                                          *** */

        while (1) {

        for(c=0;c<POPSIZE;c++)
        if (parentpop[c].grade==-1) grade_chromo(&parentpop[c]);

        qsort(parentpop, POPSIZE, sizeof(*parentpop), compare_chromo);

        /* Migration and population saving at SIGINT */
        #ifdef HAVE_LIBPVM3
        if (u%MIGRTIME==0) {
		debug(_("Sending migration to %x"), sibling);
                pvm_initsend(0);
                for(c=0;c<POPSIZE/MIGRPART;c++) {
                        pvm_pkint((int *) parentpop[c].inf, tuplenum*2, 1);
                }
                pvm_send(sibling, MSG_MIGRATION);
        }

        if (pvm_nrecv(parent, MSG_SENDPOP)>0) {
                pvm_initsend(0);
                pvm_pkint(&tuplenum, 1, 1);
                pvm_pkint(&u, 1, 1);
                for(c=0;c<POPSIZE;c++) {
                        pvm_pkint((int *) parentpop[c].inf, tuplenum*2, 1);
                }
                pvm_send(parent, MSG_POPDATA);

                pvm_exit();
                xmlsup_exit();
		main_exit();
                data_exit();

                exit(0);
        }
        #else
        if (ctrlc==1) {
                snprintf(xmlsrc, 256, "%ssave.txt", prefix);
                saved=fopen(xmlsrc, "w");

                if (saved==NULL) perror("tablix");

                fprintf(saved, "%d\n", tuplenum);
                fprintf(saved, "%d\n", u);

                for(c=0;c<POPSIZE;c++) {
                        for(b=0;b<tuplenum;b++) {
                                fprintf(saved, "%d %d\n", parentpop[c].inf[b].time, parentpop[c].inf[b].room);
                        }
                        fprintf(saved, "+\n");
                }
                fclose(saved);

                xmlsup_exit();
		main_exit();
                data_exit();

                exit(0);
        }
        #endif
        a=parentpop[0].grade;
        b=1;
        for(c=1;c<POPSIZE;c++) {
                if (parentpop[c].grade==a) {
                        b++;
                } else {
                        a=parentpop[c].grade;
                        b=1;
                }

                if (b>MAXEQUAL) {
/*
                        for(d=0;d<tuplemut;d++) {
                                parentpop[c].inf[d].time=rand()%TIMES;
                                parentpop[c].inf[d].room=rand()%ROOMS;
                        }
*/
                        parentpop[c].grade=GRADEMAX;
                }
        }

        #ifdef HAVE_LIBPVM3
        pvm_initsend(0);
        pvm_pkint(&parentpop[0].grade, 1, 1);
        pvm_pkint(&u, 1, 1);
        pvm_pkint(&parentpop[0].possible, 1, 1);
        pvm_pkint(parentpop[0].subtotals, gnum, 1);
        pvm_send(parent, MSG_REPORT);
        #else
        printf("-------%d\n", u);
        for(c=0;c<5;c++) {
                printf("%d (%d)", parentpop[c].grade, parentpop[c].possible);
		for(b=0;b<gnum;b++) {
			printf("\t%d", parentpop[c].subtotals[b]);
		}
		printf("\n");

        }
        #endif

        if (parentpop[0].grade<g1) {
                g1=parentpop[0].grade;
                g2=0;
        } else g2++;

        #ifdef HAVE_LIBPVM3
        /* in an unlikely event of a disaster... */
        if (pvm_nrecv(-1, MSG_MASTERKILL)>0) {
                xmlsup_exit();
		main_exit();
                data_exit();
                pvm_exit();
                exit(1);
        }
        #endif


	/* Local search */
	if (g2==LOCALTRESH) {
		c=1;
		#ifdef HAVE_LIBPVM3
	        pvm_initsend(0);
		pvm_pkint(&c, 1, 1);
		pvm_send(parent, MSG_LOCALSYN);

		pvm_recv(parent, MSG_LOCALACK);
		pvm_upkint(&c, 1, 1);
		#endif

		if (c) {
			lsearch_chromo(&parentpop[0]);
			#ifdef HAVE_LIBPVM3
			c=0;
		        pvm_initsend(0);
			pvm_pkint(&c, 1, 1);
			pvm_send(parent, MSG_LOCALSYN);
			#endif
		}
	}

        if ((g2>FINISH)&&(!parentpop[0].possible)) {
                debug(_("I have solution"));

                #ifdef HAVE_LIBPVM3
                tmpnam(xmlsrc);
                #else
                snprintf(xmlsrc, 256, "%sresult.xml", prefix);
                #endif

                xmlsup_addchromo(parentpop);

                tmpfile=fopen(xmlsrc, "w");
                xmlsup_dump(tmpfile);
                fclose(tmpfile);
                /*  print_chromo_html(parentpop, xmlsrc); */

                #ifdef HAVE_LIBPVM3
		pvm_initsend(0);
		pvm_send(parent, MSG_RESULTDATA);

		if (file_send(xmlsrc, parent, MSG_RESULTDATA)) {
			error(strerror(errno));
	        	fatal(_("Can't open temporary file"));
		}

                unlink(xmlsrc);

                pvm_exit();
                #else
                #ifdef HAVE_CONV
                fclose(convfile);
                #endif
                #endif

                xmlsup_exit();
		main_exit();
                data_exit();

                exit(0);
        }

        #if (!HAVE_LIBPVM3 && HAVE_CONV)
        fprintf(convfile, "%d\t%d\t%d", u, parentpop[0].grade, parentpop[0].possible);
	for(c=0;c<gnum;c++) {
		fprintf(convfile, "\t%d", parentpop[0].subtotals[c]);
	}
	fprintf(convfile, "\n");
        fflush(convfile);
        #endif

        for(c=POPSIZE/2;c<POPSIZE-1;c+=2) {
                a=rand()%(POPSIZE/2);
                b=rand()%(POPSIZE/2);

                if (parentpop[a].grade>parentpop[b].grade) {
                        d=a;
                        a=b;
                        b=d;
                }

                for(d=2;d<TOURSIZE;d++) {
                        temp=rand()%(POPSIZE/2);

                        if (parentpop[temp].grade<parentpop[a].grade) a=temp; else
                        if (parentpop[temp].grade<parentpop[b].grade) b=temp;
                }

                mate_chromo(&parentpop[a], &parentpop[b], &parentpop[c], &parentpop[c+1]);
        }

        for(c=0;c<(POPSIZE/2/MUTATEPART);c++) {
                a=rand()%(POPSIZE/2);
                mutate_chromo(&parentpop[a]);
        }
 
        for(c=0;c<(POPSIZE/2/RANDPART);c++) {
                a=rand()%(POPSIZE/2);
                rand_chromo(&parentpop[a]);
        }

        #ifdef HAVE_LIBPVM3
        if (pvm_nrecv(-1, MSG_MIGRATION)>0) {
		debug(_("I have migration"));
                for(c=0;c<POPSIZE/MIGRPART;c++) {
                        pvm_upkint((int *) parentpop[POPSIZE-c-1].inf, tuplenum*2, 1);
			parentpop[POPSIZE-c-1].grade=-1;
                }
        }

        if (pvm_nrecv(parent, MSG_SIBLING)>0) {
                pvm_upkint(&sibling, 1, 1);
		debug(_("New sibling %x"), sibling);
        }
        #endif

        u++;
        }

        /* Should be never reached */

        return(0);
}
