/* Written by:                                                             */

/* Richard Taylor                                                          */
/* Okanagan University College                                             */
/* Salmon Arm BC, Canada                                                   */

/* Author gives permission for redistribution as long as his name is       */
/* mentioned in the source file.                                           */

/* $Id: teacher_dayoff.c,v 1.1 2004/11/26 18:09:52 avian Exp $ */

/* 
 * AUTHOR:
 *  
 *  Richard Taylor <rtaylor@ouc.bc.ca>
 *
 * DESCRIPTION:
 *
 *  Adds a weight for each teacher who is scheduled to teach on both the
 *  first and last days of the week.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "data.h"

/* NOTES:
 * - 'tpnt' indexes a 2-D array (of total length tmapnum) of tuple ids (ie,
 *   subject-class pairs) arranged by teacher and time. 
 * - 'tmapnum' is the number of teachers
 */

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int sum;
	int tid,p;
        int mondaysubjects,fridaysubjects;
 
	sum=0;

        for(tid=0;tid<tmapnum;tid++) {  // loop through all teachers

	  // check if teacher has anything scheduled on Mondays
	  mondaysubjects=0;
          p=0;
          while ((p<PERIODS) && (!mondaysubjects)) {
	    if (tpnt[tid*TIMES + p] != -1) mondaysubjects=1;
	    p++;
	  }

	  // check if teacher has anything scheduled on Fridays
          fridaysubjects=0;
	  p=0;
          while ((p<PERIODS) && (!fridaysubjects)) {
	    if (tpnt[tid*TIMES + (DAYS-1)*PERIODS + p] != -1) fridaysubjects=1;
	    p++;
	  }

	  // check if teacher has both Monday and Friday classes
	  if (mondaysubjects && fridaysubjects) sum++;
	}

	return(sum);
};
