/* Written by:                                                             */

/* Richard Taylor                                                          */
/* Okanagan University College                                             */
/* Salmon Arm BC, Canada                                                   */

/* Author gives permission for redistribution as long as his name is       */
/* mentioned in the source file.                                           */

/* $Id: subject_sameperiod.c,v 1.1 2004/11/30 21:41:21 avian Exp $ */

/* 
 * AUTHOR:
 *  
 *  Richard Taylor <rtaylor@ouc.bc.ca>
 *
 * DESCRIPTION:
 *
 *  Adds a weight for each tuple of a subject that is scheduled at 
 *  a different period. If for example a certain subject is scheduled 
 *  at three different periods on three different days, this module 
 *  adds two weights. The goal is to make the schedule more symmetrical, 
 *  by having students for a certain subject meet at the same time each 
 *  day, if possible.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>

#include "data.h"

int *su;
int *tm;
int *multitime;

int init_mod() {

  su = (int *) malloc(sizeof(*su)*smapnum);
  tm = (int *) malloc(sizeof(*tm)*smapnum);
  multitime = (int *) malloc(sizeof(*multitime)*smapnum);

  return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int a,c;
	int flag,sid,per;
	int sum;
	int nsu;

	nsu=0;                     // initialize number of subjects found

        for(c=0;c<tuplenum;c++) {  // loop through all subject-class pairs
	  per = t->inf[c].time % PERIODS;   // get scheduled period
	  sid = tuplemap[c].sid;   // get subject id
	  flag=1;                  // flag for addition to list of subjects encountered

	  for (a=0;a<nsu;a++) {
	    if (sid==su[a]) {      // if we've encountered this subject already...
	      flag=0;              // unflag for addition to list of subjects encountered
	      if (per != tm[a]) multitime[a]++;  // check if room is same as before
	      break;
	    }
	  }

	  if(flag) {              // if we haven't encountered this subject before...
	    su[nsu]=sid;          // add to list of subjects for this class
	    tm[nsu]=per;          // store period for this subject
	    multitime[nsu]=0;     // initialize multitime flag for this subject
	    nsu++;                // increment number of subjects encountered
	  }

	} // loop over subject-class pairs

	// count number of multitime subjects
	sum=0;
	for (a=0;a<nsu;a++) {
	  sum+=multitime[a];
	}

	return(sum);
};
