# $Id: Linker.py,v 1.56 2003/02/01 23:57:08 chalky Exp $
#
# This file is a part of Synopsis.
# Copyright (C) 2000, 2001 Stefan Seefeld
# Copyright (C) 2000, 2001 Stephen Davies
#
# Synopsis is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
#
# $Log: Linker.py,v $
# Revision 1.56  2003/02/01 23:57:08  chalky
# Remove obsolete option that was blocking the real -p
#
# Revision 1.55  2003/02/01 05:40:48  chalky
# Remove the old config_obj handlers since they're no longer used, but added
# backward compat for old 'mappers' option (it's now called mapper_list).
#
# Revision 1.54  2003/01/20 07:00:43  chalky
# Use summary comment_processor by default
#
# Revision 1.53  2002/10/29 06:56:52  chalky
# Fixes to work on cygwin
#
# Revision 1.52  2002/10/28 16:30:05  chalky
# Trying to fix some bugs in the unduplication/stripping stages. Needs more work
#
# Revision 1.51  2002/10/11 05:57:17  chalky
# Support suspect comments
#
# Revision 1.50  2002/08/23 04:37:26  chalky
# Huge refactoring of Linker to make it modular, and use a config system similar
# to the HTML package
#
# Revision 1.49  2002/07/11 09:29:32  chalky
# Huge speed improvement O(n^2) -> O(n) in unduplicator, eg: 230sec -> 9sec
#
# Revision 1.48  2002/01/09 11:43:41  chalky
# Inheritance pics
#
# Revision 1.47  2001/07/26 08:21:58  chalky
# Fixes bug caused by bad template support
#
# Revision 1.46  2001/07/19 08:11:38  chalky
# Typo
#
# Revision 1.45  2001/07/19 07:57:52  chalky
# Bug fixes
#
# Revision 1.44  2001/07/19 03:59:56  chalky
# New .syn file format. Added EmptyNS to remove empty namespaces
#
# Revision 1.43  2001/06/15 18:27:08  stefan
# some cleanup; debugged and refactored the various stages such as prefix stripping, unduplicating, prefixing; some renaming (we ought to put some naming conventions into place...
#
# Revision 1.42  2001/06/13 13:13:16  chalky
# Realnames dont need mapping anymore since they are built from name()
# dynamically
#
# Revision 1.41  2001/06/05 10:01:28  chalky
# Can set (string)type of mapped decl names (eg: Package)
#
# Revision 1.40  2001/05/25 13:45:49  stefan
# fix problem with getopt error reporting
#
# Revision 1.39  2001/04/17 15:47:26  chalky
# Added declaration name mapper, and changed refmanual to use it instead of the
# old language mapping
#
# Revision 1.38  2001/04/06 02:35:39  chalky
# Parse config object
#
# Revision 1.37  2001/04/05 16:21:44  chalky
# Check for type with no name, ie: dummy enumerator
#
# Revision 1.36  2001/03/28 12:53:32  chalky
# Made module comments carry through into meta-module comments
#
# Revision 1.35  2001/02/13 06:55:23  chalky
# Made synopsis -l work again
#
# Revision 1.34  2001/02/13 06:36:46  chalky
# Added -a flag to strip decls with greater access
#
# Revision 1.33  2001/02/12 04:08:09  chalky
# Added config options to HTML and Linker. Config demo has doxy and synopsis styles.
#
# Revision 1.32  2001/02/11 05:39:33  stefan
# first try at a more powerful config framework for synopsis
#
# Revision 1.31  2001/02/06 17:37:20  chalky
# Reorder languagize to before unduplicator to prevent module conflicts
#
# Revision 1.30  2001/02/06 06:54:27  chalky
# Added comment processing to Linker..
#

# THIS-IS-A-LINKER

import sys, getopt, os, os.path, string, types
from Synopsis.Core import Util, Type, AST

from Synopsis.Core.Util import import_object

pyTypes = types
del types
strip = []
mapperList = []
verbose = 0
max_access = None

def usage():
    print \
"""
  -s <scope>                           Select only the named scope.
  -m <mapper>                          Use a mapper plugin to map unresolved types new names
  -M <mapper>                          Use a std mapper (part of the Linker module) to map unresolved types new names.
                                       Currently the C++toIDL mapper is supported
  -a <access level>		       Removes all declarations with greater
				       access level than that given.
				       1==public only, 2==protected or public
				       """
class Config:
    """Central configuration repository for Linker."""
    def __init__(self):
	"""Constructor - initialise objects to None."""
	self.ast = None
	self.strip = []
	self.mapper_list = []
	self.types = None # Filled in first thing in resolve()
	self.max_access = None
	self.map_declaration_names = None
	self.map_declaration_type = 'Language'
	self.operations = [
	    'Unduplicator', 'Stripper', 'NameMapper',
	    'Comments', 'EmptyNS', 'AccessRestrictor'
	] # Off by default: 'LanguageMapper', 
	self.verbose = 0
	self.comment_processors = ['summary']
   
    def use_config(self, obj):
	"""Extracts useful attributes from 'obj' and stores them. The object
	itself is also stored as config.obj"""
	# obj.pages is a list of module names
	self.obj = obj
	options = ('verbose', 'strip', 'mappers', 'mapper_list', 'max_access',
	    'operations', 'map_declaration_names', 'map_declaration_type',
	    'comment_processors')
	for option in options:
	    if hasattr(obj, option):
		getattr(self, '_config_'+option)(getattr(obj, option))
	    elif self.verbose: print "Option",option,"not found in config."

    def _config_verbose(self, verbose):
	"Configures from the given verbose boolean"
	self.verbose = verbose
	
    def _config_strip(self, strip):
	"Configures from the given list of strip"
	if type(strip) != pyTypes.ListType:
	    raise TypeError, "Linker.strip must be a list of strings."
	if self.verbose: print "Using strip:", strip
	self.strip = strip


    def _config_mapper_list(self, mapper_list):
	"Configures from the given list of mapper_list"
	if type(mapper_list) != pyTypes.ListType:
	    raise TypeError, "Linker.mapper_list must be a list of strings."
	if self.verbose: print "Using mapper_list:", mapper_list
	for mapper in mapper_list:
	    if type(mapper) is pyTypes.StringType:
		self.mapper_list.append(mappers[mapper]())
	    else:
		self.mapper_list.append(getattr(Util._import(mapper[0]), mapper[1])())
    
    # mappers is the old config name
    _config_mappers = _config_mapper_list

    def _config_operations(self, operations):
	"Configures from the given list of operations"
	if type(operations) != pyTypes.ListType:
	    raise TypeError, "Linker.operations must be a list."
	if self.verbose: print "Using operations:", operations
	self.operations = operations

    def _config_max_access(self, access):
	if self.verbose: print "Using max_access:",access
	self.max_access = access

    def _config_map_declaration_names(self, names):
        if not names: return
	if self.verbose: print "Using map_declaration_names:", names
	self.map_declaration_names = tuple(string.split(names[0], '::'))
	self.map_declaration_type = names[1]

    def _config_map_declaration_type(self, typename):
	if self.verbose: print "Using map_declaration_type:", typename
	self.max_declaration_type = typename

    def _config_comment_processors(self, processors):
	if self.verbose: print "Using comment_processors:", processors
	self.comment_processors = processors

# Instantiate a global config object in this module
config = Config()

class Operation:
    """The base class for Linker operations. The linker executes a number of
    operations, depending on the config option 'operations'. Each operation
    may use other config options"""
    def execute(self):
	"""Executes this operation"""
	pass

class CXX2IDL:
    """this function maps a C++ external reference to an IDL interface if the name either
    starts with 'POA_' or ends in '_ptr'"""
    def __init__(self): pass
    def map(self, unknown):
        global verbose
        import __builtin__
        name = unknown.name()
        language = unknown.language()
        if language != "C++": return
        if name[0][0:4] == "POA_":
            interface = __builtin__.map(None, name)
            interface[0] = interface[0][4:]
            unknown.resolve("IDL", name, tuple(interface))
            if verbose: print "mapping", string.join(name, "::"), "to", string.join(interface, "::")
        elif name[-1][-4:] == "_ptr":
            interface = __builtin__.map(None, name)
            interface[-1] = interface[-1][:-4]
            unknown.resolve("IDL", name, tuple(interface))
            if verbose: print "mapping", string.join(name, "::"), "to", string.join(interface, "::")

mappers = {
    'C++toIDL' : CXX2IDL,
    }

def __parseArgs(args, config_obj):
    global strip, mapperList, verbose, languagize, processor_args, max_access
    global map_decl_names, map_decl_name_type
    languagize = 0
    processor_args = []
    map_decl_names = None
    map_decl_name_type = "scope"

    # Use config first
    config.use_config(config_obj)

    # Now parse args
    try:
        opts,remainder = getopt.getopt(args, "s:m:M:vlp:a:d:")
    except getopt.error, e:
        sys.stderr.write("Error in arguments: " + str(e) + "\n")
        sys.exit(1)

    for opt in opts:
        o,a = opt

        if o == "-s": config.strip.append(a)
        elif o == "-m":
	    config.mapper_list.append(Util._import(a))
        elif o == "-M":
	    if mappers.has_key(a): config.mapper_list.append(mappers[a]())
	    else:
		print "Error: Unknown mapper. Available mappers are:",string.join(mappers.keys(), ', ')
		sys.exit(1)
        elif o == "-v": config.verbose = 1
	elif o == '-l': languagize = 1
	elif o == '-a': max_access = int(a)
	elif o == '-d': 
	    map_decl_names, map_decl_name_type = string.split(a, '=')
	    map_decl_names = string.split(map_decl_names, '::')
	elif o == '-p':
	    if not hasattr(config, 'comment_processors'):
		config.comment_processors = []
	    config.comment_processors.append(a)

class Mapper(Type.Visitor):
    """allow user to supply a mapping functor that is applied to Unknown types.
    This is useful for linking to externally defined types, such as when cross-
    referencing modules written in different languages"""
    def __init__(self, mappers):
        self.__mappers = mappers
    def visitUnknown(self, unknown):
        for mapper in self.__mappers:
            mapper.map(unknown)


def mapTypes(m):
    if len(m):
        mapper = Mapper(m)
        for type in types.values():
            type.accept(mapper)

def resolve(args, ast, config_obj):
    global types, mapperList
    types = ast.types()
    declarations = ast.declarations()

    config.types = ast.types()

    __parseArgs(args, config_obj)

    def_attr = 'linkerOperation'
    base_path = 'Synopsis.Linker.'
    for op_spec in config.operations:
	oper_class = import_object(op_spec, def_attr, base_path)
	oper = oper_class()
	oper.execute(ast)

    # apply user supplied mapping of external types (Type.Unknown)
    mapTypes(config.mapper_list)

