#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
This module contains a class for representing quadrature rules.
"""

__author__ = "Martin Sandve Alnes"
__date__   = "November 29th 2007"
__copyright__ = "(C) 2007 Martin Sandve Alnes and Simula Resarch Laboratory"
__license__  = "GNU GPL Version 2, or (at your option) any later version"


class QuadRule:
    """This class represents a specific quadrature rule over a polygon."""
    def __init__(self, polygon, nsd, order, points, weights, comment):
        assert len(points) == len(weights)
        self.polygon    = polygon
        self.nsd        = nsd
        self.num_points = len(points)
        self.points     = points
        self.weights    = weights
        self.comment    = comment
        self.order      = order
    
    def __str__(self):
        s  = "Quadrature rule:\n"
        s += "  comment: %s\n" % self.comment
        s += "  polygon     = %s\n" % self.polygon
        s += "  nsd         = %d\n" % self.nsd
        s += "  num_points  = %d\n" % self.num_points
        s += "  points      = %s\n" % self.points
        s += "  weights     = %s\n" % self.weights
        s += "  order       = %d\n" % self.order
        return s


if __name__ == '__main__':
    print "No test here."

