# -*- coding: utf-8 -*-
"""
This module contains code generation tools for the ufc::cell_integral class.
"""

__author__ = "Martin Sandve Alnes"
__date__   = "2008-08-13 -- 2009-03-09"
__copyright__ = "(C) 2008-2009 Martin Sandve Alnes and Simula Resarch Laboratory"
__license__  = "GNU GPL Version 2, or (at your option) any later version"

from itertools import tee
import swiginac
from sfc.common.output import sfc_debug, sfc_error, sfc_assert, sfc_warning
from sfc.quadrature import gen_quadrature_rule_definition, gen_quadrature_rule_definitions
from sfc.codegeneration.codeformatting import indent, CodeFormatter, gen_const_token_definitions, gen_token_prints
from sfc.codegeneration.codeformatting import gen_symbol_declarations, gen_token_declarations, gen_token_assignments, gen_token_additions
from sfc.codegeneration.integralcg import IntegralCG

class CellIntegralCG(IntegralCG):
    def __init__(self, itgrep):
        IntegralCG.__init__(self, itgrep)
        # Generator trick:
        # Iterators over members are used in gen_members and
        # gen_constructor, avoid double iteration with tee:
        
        # FIXME: Update this for multiple integral data, and for precomputation without constructor code
        for integral in self.itgrep.quadrature_integrals:
            sfc_assert(len(self.itgrep.quadrature_integrals) <= 1, "Not implemented!")
            data = self.itgrep.integral_data[integral.measure()]
            
            a, b = tee(self.itgrep.iter_member_quad_tokens(data))
            self._iter_member_quad_tokens1 = a
            self._iter_member_quad_tokens2 = b
    
    def gen_members(self):
        sfc_debug("entering CellIntegral.gen_members")
        code = ""
        
        # FIXME: Update this for multiple integral data, and for precomputation without constructor code
        for integral in self.itgrep.quadrature_integrals:
            sfc_assert(len(self.itgrep.quadrature_integrals) <= 1, "Not implemented!")
            data = self.itgrep.integral_data[integral.measure()]

            member_quad_tokens = self._iter_member_quad_tokens1 #self.itgrep.iter_member_quad_tokens()
            member_quad_token_names = (str(s[0]).split(".")[-1] for s in member_quad_tokens)
            decl = gen_symbol_declarations(member_quad_token_names)
            if decl:
                code += "\n\n"
                code += "struct member_quad_tokens\n{\n"
                code += indent(decl)
                code += "\n};\n"
                code += "member_quad_tokens qt[%d];\n" % data.quad_rule.num_points
        
        sfc_debug("leaving CellIntegral.gen_members")
        return code
    
    def gen_constructor(self):
        sfc_debug("entering CellIntegral.gen_constructor")
        code = ""
        
        # FIXME: Update this for multiple integral data, and for precomputation without constructor code
        for integral in self.itgrep.quadrature_integrals:
            sfc_assert(len(self.itgrep.quadrature_integrals) <= 1, "Not implemented!")
            data = self.itgrep.integral_data[integral.measure()]
            
            member_quad_tokens = self._iter_member_quad_tokens2 # itgrep.iter_member_quad_tokens()
            member_quad_tokens_assignments = gen_token_assignments(member_quad_tokens)
            if member_quad_tokens_assignments:
                # Construct quadrature loop
                quad_loop_start_code = self.gen_quadrature_begin_block(data)
                
                # Stitch code pieces together
                code += quad_loop_start_code + "\n"
                code += indent(member_quad_tokens_assignments)
                code += "\n}\n"
        
        sfc_debug("leaving CellIntegral.gen_constructor")
        return code

    def gen_destructor(self):
        return ""



