/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "config.h"

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "frmmain.h"
#include "aplist.h"


static const char description[] =
        I18N_NOOP("Simple Wireless Scanner (SWScanner). A wireless network organizer, scanner and wardriving tool");

static const char version[] = VERSION;

static KCmdLineOptions options[] =
        {
                { "i", 0, 0 },
                { "iface <interface>", I18N_NOOP( "Selected interface by default" ), 0 },
                { "f", 0, 0 },
                { "fileopen <file>", I18N_NOOP( "File to open at start (.sws, .nss)" ), 0 },
		{ "+file" , I18N_NOOP( "File to open at start (.sws, .nss)" ), 0 },
		{ "on", I18N_NOOP( "Automatically starts scanning after start"), 0 },
                KCmdLineLastOption
        };

// List of AP's to be shared between the GUI thread and the seria IO thread
APList * plist;

int main(int argc, char **argv)
{
        KAboutData about("swscanner", I18N_NOOP("SWScanner"), VERSION, description,
                         KAboutData::License_GPL, "(C) 2004 Ivan Forcada Atienza", 0, "http://www.swscanner.org", "ivan@swscanner.org");
        about.addAuthor( "Ivan Forcada Atienza", 0, "ivan@swscanner.org" );
        KCmdLineArgs::init(argc, argv, &about);
        KCmdLineArgs::addCmdLineOptions( options );

        KApplication app;
        int ret;
	
#if DEBUG_STDOUT
        printf("SWScanner compiled in debug mode.\n");
#endif

	printf("Running SWScanner version: %s\n", VERSION);

        plist = new APList;	// Create the list of ap's before the main GUI form

        frmmain* mainWin = new frmmain();
        app.setMainWidget( mainWin );
        mainWin->show();

        // mainWin has WDestructiveClose flag by default, so it will delete itself.
        ret = app.exec();
        delete mainWin;
        delete plist;	// Free list memory and... bye bye ;-)
        printf("Return with: %d\n",ret);
        return ret;
}

