/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: View.java,v $
   Revision 1.3  2005/01/05 09:22:36  bobintetley
   Updated copyright year on source

   Revision 1.2  2004/10/30 20:11:58  bobintetley
   Code cleanup

   Revision 1.1  2004/05/04 09:31:43  bobintetley
   PlainDocument/View support and implementation. Build script supports java/javax
   packages - fix to build script to use nested args in bootclasspath (single path broke on my Ant 1.6.1/Linux)


*/

package swingwtx.swing.text;

import swingwtx.swing.*;

/**
 * View superclass that maps Document models between viewable
 * components. Basically assumes your component is a descendant
 * of JTextComponent (why it's vitally important for subclasses
 * to override functionality, even if they aren't that similar).
 *
 * @author Robin Rawson-Tetley
 */
public abstract class View implements SwingConstants {
    
    protected Document doc;
    
    public View(Document doc) { this.doc = doc; }

    public boolean isVisible() { return true; }
    public float getAlignment(int axis) { return (float) 0.5; }
    public int getViewCount() { return 0; }
    public View getView(int n) { return null; }

}
