/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: TableColumnModel.java,v $
   Revision 1.6  2005/01/05 09:22:36  bobintetley
   Updated copyright year on source

   Revision 1.5  2004/04/15 11:24:33  bobintetley
   (Dan Naab) ComponentUI, UIDefaults/UIManager and Accessibility support.
   (Antonio Weber) TableColumnModelListener implementation and support

   Revision 1.4  2003/12/17 10:57:35  bobintetley
   JTableHeader implementation plus Table event/model fixes

   Revision 1.3  2003/12/14 09:13:39  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing.table;

import java.util.*;

import swingwtx.swing.*;
import swingwtx.swing.event.*;

public interface TableColumnModel {
    public void addColumn(TableColumn aColumn);
    public void removeColumn(TableColumn column);
    public void moveColumn(int columnIndex, int newIndex);
    public void setColumnMargin(int newMargin);
    public int getColumnCount();
    public Enumeration getColumns();
    public int getColumnIndex(Object columnIdentifier);
    public TableColumn getColumn(int columnIndex);
    public int getColumnMargin();
    public int getColumnIndexAtX(int xPosition);
    public int getTotalColumnWidth();
    public void setColumnSelectionAllowed(boolean flag);
    public boolean getColumnSelectionAllowed();
    public int[] getSelectedColumns();
    public int getSelectedColumnCount();
    public void setSelectionModel(ListSelectionModel newModel); 
    public ListSelectionModel getSelectionModel(); 
    public void addColumnModelListener(TableColumnModelListener x);
    public void removeColumnModelListener(TableColumnModelListener x);
}
