/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: EventListenerList.java,v $
   Revision 1.9  2005/01/05 09:22:33  bobintetley
   Updated copyright year on source

   Revision 1.8  2004/10/30 20:11:57  bobintetley
   Code cleanup

   Revision 1.7  2004/05/05 12:43:22  bobintetley
   Patches/new files from Laurent Martell

   Revision 1.6  2004/04/16 10:19:07  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.5  2004/03/30 10:42:47  bobintetley
   Many minor bug fixes, event improvements by Dan Naab. Full swing.Icon support

   Revision 1.4  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing.event;

import java.util.*;
import java.lang.reflect.*;

public class EventListenerList {
    
    protected Vector listenerList = new Vector();

    public Object[] getListenerList() {
	return listenerList.toArray();
    }

    public synchronized void add(Class t, EventListener l) {
        listenerList.add(l);
    }

    public synchronized void remove(Class t, EventListener l) {

        listenerList.remove(l);
    }

    /*
    public synchronized void add(Class t, EventListener l) {
        Iterator iterator = listenerList.iterator();
        while (iterator.hasNext())
        {
            Class listenerClass = (Class) iterator.next();
            EventListener eventListener = (EventListener) iterator.next();
            if (listenerClass == t && eventListener == l)
            {
                iterator.remove();
                listenerList
            }

        }
        for (int i = 0; i < listeners.length; i +=2 ) {
            if ( listeners[i] == t &&
                 listeners[i+1] == l )
            {

            }
        }
        listenerList.add(t);
        listenerList.add(l);
    }

    public synchronized void remove(Class t, EventListener l) {
        int index = listenerList.indexOf(l);
        listenerList.remove(index);
        listenerList.remove(index);
    }
    */

    public EventListener[] getListeners(Class t) {
        int n = getListenerCount(t);
        EventListener[] listeners = (EventListener[])Array.newInstance(t, n);
        int listenersIndex = 0;
        for (int i = listenerList.size() -2; i>=0; i-=2) {
            if (listenerList.get(i) == t) {
                listeners[listenersIndex] = listeners[i+1];
            listenersIndex++;
            }
        }
        return listeners;
    }

    public int getListenerCount() {
	return listenerList.size();
    }

    public int getListenerCount(Class t) {
        int listenerCount = 0;
        Object[] listeners = getListenerList();
        for (int i = 0; i < listeners.length; i +=2 ) {
            if (t == listeners[i])
                listenerCount++;
        }
        return listenerCount;
    }

    public String toString() {
	Object[] list = listenerList.toArray();
	String s = "EventListenerList: ";
	s += list.length + " listeners: ";
	for (int i = 0 ; i < list.length ; i++) {
	    s += " type " + ((Class)list[i]).getName();
	    s += " listener " + list[i].toString();
	}
	return s;
    }
}
