/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: UIManager.java,v $
   Revision 1.11  2005/03/09 09:41:00  bobintetley
   (David Green) Various compatibility fixes

   Revision 1.10  2005/01/05 09:22:32  bobintetley
   Updated copyright year on source

   Revision 1.9  2004/11/02 11:07:31  bobintetley
   Fixed a number of small compatibility bugs

   Revision 1.8  2004/10/30 20:11:57  bobintetley
   Code cleanup

   Revision 1.7  2004/05/05 12:43:21  bobintetley
   Patches/new files from Laurent Martell

   Revision 1.6  2004/04/15 11:24:33  bobintetley
   (Dan Naab) ComponentUI, UIDefaults/UIManager and Accessibility support.
   (Antonio Weber) TableColumnModelListener implementation and support

   Revision 1.5  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet

   Revision 1.4  2004/01/16 15:53:32  bobintetley
   Many compatibility methods added to Container, Component, JInternalFrame,
      UIManager, SwingUtilities, JTabbedPane, JPasswordField, JCheckBox
      and JRadioButton.

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing;

import swingwt.awt.*;

/**
 * Dumb skeleton of UI manager that should be good enough to fool
 * any programs attempting to change the Swing L&F. Note that I have
 * no intention of implementation the plaf package as that is just
 * too damn far ;-)
 * @author  Robin Rawson-Tetley
 */
public class UIManager {
    
    public UIManager() {}

    public static class LookAndFeelInfo {
        private String name;
        private String className;
        public LookAndFeelInfo(String name, String className) { this.name = name; this.className = className; }
        public String getClassName() { return className; }
        public String getName() { return name; }
    }
    
    public static Object get(String key) { return null; }
    public static Object put(Object key, Object value) { return null;}
    public static Font getFont(Object key) { return null; }
    public static Color getColor(Object key) { return null; }

    public static LookAndFeelInfo[] getInstalledLookAndFeels() {
        return new LookAndFeelInfo[]{ new LookAndFeelInfo("SWTNative", "swingwtx.swing.UIManager") };
    }
    public static UIDefaults getLookAndFeelDefaults() { return new UIDefaults(); }
    public static UIDefaults getDefaults() { return getLookAndFeelDefaults(); }
    public static void setLookAndFeelDefaults(UIDefaults defaults) { }
    public static void setInstalledLookAndFeels(LookAndFeelInfo[] infos) throws SecurityException {}
    public static void installLookAndFeel(LookAndFeelInfo info) {}
    public static void installLookAndFeel(String name, String className) {}
    public static LookAndFeel getLookAndFeel() { return null; }
    public static void setLookAndFeel(LookAndFeel newLookAndFeel) throws UnsupportedLookAndFeelException {}
    public static void setLookAndFeel(String className) throws ClassNotFoundException, InstantiationException,  IllegalAccessException, UnsupportedLookAndFeelException {} 
    public static String getSystemLookAndFeelClassName() { return "swingwtx.swing.UIManager"; }
    public static String getCrossPlatformLookAndFeelClassName() { return "swingwtx.swing.UIManager"; }
    
}
