/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JOptionPane.java,v $
   Revision 1.35  2005/03/09 09:41:00  bobintetley
   (David Green) Various compatibility fixes

   Revision 1.34  2005/02/22 17:37:46  bobintetley
   JTabbedPane now supports add(index) methods. Few code errors fixed as a result
   of work on 15th.

   Revision 1.33  2005/02/16 08:34:36  bobintetley
   JFileChooser.showDialog support, JOptionPane instance support (no dialog creation at present), JSplitPane.getDividerLocation(), PixelGrabber.grabPixels(ms) throws InterruptedException, swingwtx.swing.MenuElement implemented, with JMenu* implementors, JPopupMenu.getSubElements(), JMenuBar.getSubElements(), JMenu.getSubElements()

   Revision 1.32  2005/01/05 09:22:31  bobintetley
   Updated copyright year on source

   Revision 1.31  2005/01/05 08:37:13  bobintetley
   Many compatibility fixes from David Barron

   Revision 1.30  2004/10/30 20:11:57  bobintetley
   Code cleanup

   Revision 1.29  2004/10/08 14:54:31  bobintetley
   Definitely nailled that resizing shell bug under GTK2 this time. Replaced
      peer resizing in repaintFix() with an SWT layout

   Revision 1.28  2004/10/07 14:04:13  bobintetley
   showInputDialog now shows initialSelectionValue correctly for text entry

   Revision 1.27  2004/06/08 09:24:23  dannaab
   Rename Component.getPeer() -> getSWTPeer().  added ComponentPeer and stubbed out support classes.

   Revision 1.26  2004/04/30 23:18:26  dannaab
   List selection support, misc bug fixes

   Revision 1.25  2004/04/29 12:49:28  bobintetley
   Additional JOptionePane constants, missing JTree methods and improved awt.Image support

   Revision 1.24  2004/04/23 09:36:28  bobintetley
   *** empty log message ***

   Revision 1.23  2004/04/21 11:41:11  bobintetley
   *** empty log message ***

   Revision 1.22  2004/04/19 15:43:25  bobintetley
   Missing (and incorrect) Dialog/JDialog constructors implemented

   Revision 1.21  2004/04/19 12:49:37  bobintetley
   JTaskTray implementation (and demo), along with Frame repaint fix

   Revision 1.20  2004/03/23 09:58:58  bobintetley
   SystemColor and FileDialog implementation, plus JOptionPane.showOptionDialog support

   Revision 1.19  2004/01/26 10:57:45  bobintetley
   HTML handling (throws it away - SWT can't do anything with it)

   Revision 1.18  2004/01/23 08:23:51  bobintetley
   Fix to Ok button in MessageBox for MacOSX users

   Revision 1.17  2004/01/20 15:52:56  bobintetley
   Code from an anonymous developer

   Revision 1.16  2003/12/17 13:38:02  bobintetley
   setSelectedValue(Obj, bool) support and JOptionPane.showInputDialog now uses JList

   Revision 1.15  2003/12/17 13:20:59  bobintetley
   Full showInputDialog support and JDialogs can now block correctly

   Revision 1.14  2003/12/16 18:57:56  bobintetley
   Thread safety

   Revision 1.13  2003/12/16 18:42:38  bobintetley
   More thread safety

   Revision 1.12  2003/12/15 18:14:52  bobintetley
   Additional showConfirmDialog signature

   Revision 1.11  2003/12/15 18:12:22  bobintetley
   Additional constants for YES_NO

   Revision 1.10  2003/12/15 16:40:04  bobintetley
   Core methods + skeleton JTableHeader/JScrollBar support

   Revision 1.9  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

import swingwt.awt.*;
import swingwt.awt.event.*;

// TODO: all showXXX methods should take swingwt.awt.Component instead of Container
public class JOptionPane extends JPanel {
    
    public final static int CANCEL_OPTION = SWT.CANCEL;
    public final static int YES_OPTION = SWT.YES;
    public final static int NO_OPTION = SWT.NO;
    public final static int OK_OPTION = SWT.OK;
    public final static int OK_CANCEL_OPTION = SWT.OK | SWT.CANCEL;
    public final static int CLOSED_OPTION = SWT.CLOSE;
    public final static int DEFAULT_OPTION = SWT.DEFAULT;
    public final static int YES_NO_OPTION = SWT.YES | SWT.NO;
    public final static int YES_NO_CANCEL_OPTION = SWT.YES | SWT.NO | SWT.CANCEL;
    public final static int WARNING_MESSAGE = SWT.ICON_WARNING;
    public final static int QUESTION_MESSAGE = SWT.ICON_QUESTION;
    public final static int PLAIN_MESSAGE = SWT.ICON_INFORMATION;
    public final static int INFORMATION_MESSAGE = SWT.ICON_INFORMATION;
    public final static int ERROR_MESSAGE = SWT.ICON_ERROR;
    
    protected static Object lastInputDialogReturnValue = null;
    protected static int lastInputDialogReturnIndex = -1;
    
    private static int confRetVal = 0;
    private static boolean jobFinished = false;
    private static JFrame rootFrame = null;
    
    
    // ---------------- Instance stuff
    private Object dMessage = null;
    private int dMessageType = INFORMATION_MESSAGE;
    private int dOptionType = 0;
    private Icon dIcon = null;
    private Object[] dOptions = null;
    private Object dInitialValue = null;
    private Object dValue = null;
    private Object dInputValue = null;
    
    public JOptionPane() {  }
    public JOptionPane(Object message, int messageType) { this(message, messageType, 0); }
    public JOptionPane(Object message, int messageType, int optionType) { this(message, messageType, optionType, null); }
    public JOptionPane(Object message, int messageType, int optionType, Icon icon) { this(message, messageType, optionType, icon, null); }
    public JOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options) { this(message, messageType, optionType, icon, options, null); }
    public JOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) { 
        dMessage = message;
        dMessageType = messageType;
        dOptionType = optionType;
        dIcon = icon;
        dOptions = options;
        dInitialValue = initialValue;
    }
    
    public Object getMessage() { return dMessage; }
    public int getMessageType() { return dMessageType; }
    public int getOptionType() { return dOptionType; }
    public Icon getIcon() { return dIcon; }
    public Object[] getOptions() { return dOptions; }
    public Object getInitialValue() { return dInitialValue; }
    public Object getValue() { return dValue; }
    public Object getInputValue() { return dInputValue; }
    public void setMessage(Object message) { dMessage = message; }
    public void setMessageType(int messageType) { dMessageType = messageType; }
    public void setOptionType(int optionType) { dOptionType = optionType; }
    public void setIcon(Icon icon) { dIcon = icon; }
    public void setOptions(Object[] options) { dOptions = options; }
    public void setInitialValue(Object initialValue) { dInitialValue = initialValue; }
    public void setValue(Object value) { dValue = value; }
    public void setInputValue(Object value) { dInputValue = value; }
    
    /** TODO: Not implemented. Needs to translate settings to a real dialog */
    public JDialog createDialog(Component parent, String title) {
        return null;
    }
    
    /** TODO: Not implemented. Needs to translate settings to a real internal frame */
    public JInternalFrame createInternalFrame(Component parent, String title) {
        return null;
    }
    
    // ------------------- Static stuff
    
    public static void setRootFrame(JFrame frame) {
        rootFrame = frame;
    }
    
    public static JFrame getRootFrame() {
        return rootFrame;
    }
    
    public static int showConfirmDialog(swingwt.awt.Container parent, Object message) {
        return showConfirmDialog(parent, message, QUESTION_MESSAGE);    
    }
    
    public static int showConfirmDialog(final swingwt.awt.Container parent, final Object message,
                                        final String title, final int buttons, final int messageType) {
        confRetVal = 0;
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                Shell container = getModalParent(parent);
                MessageBox m = new MessageBox(container, messageType | SWT.YES | SWT.NO);
                m.setMessage(getOptionPaneMessage(message));
                m.setText(title);
                confRetVal = m.open();
                switch (confRetVal) {
                    case SWT.YES: confRetVal = YES_OPTION; break;
                    case SWT.NO: confRetVal = NO_OPTION; break;
                }
            }
        });
        return confRetVal;
    }
    
    public static int showConfirmDialog(swingwt.awt.Container parent, Object message, String title, int messageType) {
        return showConfirmDialog(parent, message, title, 0, messageType);
    }
    
    public static int showConfirmDialog(final swingwt.awt.Container parent, final Object message, final int messageType) {
        return showConfirmDialog(parent, message, "", messageType);
    }
    
    public static void showMessageDialog(swingwt.awt.Container parent, Object message) {
        showMessageDialog(parent, message, "Information", SWT.ICON_INFORMATION);
    }

    // TODO: all showXXX methods should take swingwt.awt.Component instead of Container
    public static void showMessageDialog(final swingwt.awt.Component parent, final Object message, final String title, final int messageType) {
        showMessageDialog((Container) parent, message, title, messageType);
    }
    
    /** FIXME: Where the fuck is the title? */
    public static void showMessageDialog(final swingwt.awt.Container parent, final Object message, final String title, final int messageType) {
        SwingUtilities.invokeAsync(new Runnable() {
            public void run() {
                MessageBox m = new MessageBox(getModalParent(parent), messageType | SWT.OK);
                m.setMessage(getOptionPaneMessage(message));
                m.setText(title);
                m.open();
            }
        });
    }
    
    public static String showInputDialog(swingwt.awt.Container parent, Object message) { 
        SwingStyleInputDialog dlg = new SwingStyleInputDialog(parent, getOptionPaneMessage(message), "Input", 0, null, null, null);
        dlg.show();
        if (lastInputDialogReturnValue == null)
            return null;
        else
            return lastInputDialogReturnValue.toString();
    }
    public static String showInputDialog(swingwt.awt.Container parent, Object message, Object initialSelectionValue) { 
        SwingStyleInputDialog dlg = new SwingStyleInputDialog(parent, getOptionPaneMessage(message), "Input", 0, null, null, initialSelectionValue);
        dlg.show();
        if (lastInputDialogReturnValue == null)
            return null;
        else
            return lastInputDialogReturnValue.toString();
    }
    
    public static String showInputDialog(swingwt.awt.Component parent, Object message, String title, int messageType) { 
        SwingStyleInputDialog dlg = new SwingStyleInputDialog(parent, getOptionPaneMessage(message), title, messageType, null, null, null);
        dlg.show();
        if (lastInputDialogReturnValue == null)
            return null;
        else
            return lastInputDialogReturnValue.toString();
    }
    
    public static Object showInputDialog(final swingwt.awt.Component parent, final Object message, final String title, final int messageType, final Icon icon, final Object[] selectionValues, final Object initialSelectionValue) {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                SwingStyleInputDialog dlg = new SwingStyleInputDialog(parent, getOptionPaneMessage(message), title, messageType, icon, selectionValues, initialSelectionValue);
                dlg.show();
            }
        });
        return lastInputDialogReturnValue;
    }
    
    public static int showOptionDialog(final swingwt.awt.Container parent, final Object message, final String title, final int optionType, final int messageType,
                                       final Icon icon, final Object[] options, final Object initialValue) {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                SwingStyleInputDialog dlg = new SwingStyleInputDialog(parent, getOptionPaneMessage(message), title, messageType, icon, options, initialValue);
                dlg.show();
            }
        });
        return lastInputDialogReturnIndex;
    }
    
    /**
     * Handles Swing-style messages, strips HTML and converts
     * String arrays to a single string
     */
    protected static String getOptionPaneMessage(Object message) {
        String out = "";
        // If we have an array, concatenate
        if (message instanceof String[]) {
            String[] msgs = (String[]) message;
            for (int i = 0; i < msgs.length; i++) {
                out += msgs[i] + " ";
            }
        }
        else
            // Otherwise, just take the string content
            out = message.toString();
        
        // Strip HTML
        out = SwingWTUtils.removeHTML(out);
        
        return out;
    }
    
    /**
     * Ties up the current thread until a particular
     * task is done.
     */
    private static void waitToFinish() {
        while (!isJobFinished()) {
            try {
                Thread.sleep(50);    
            }
            catch(Exception e) {}
        }
    }
        
    protected static synchronized boolean isJobFinished() { return jobFinished; }
    protected static synchronized void setJobFinished(boolean b) { jobFinished = b; }
 
    /** Determines from the object passed whether it should be
     *  the parent for the dialog.
     *  If the container is null, the root pane set by the developer is used - 
     *      if that's null too, a shared frame is used (created if it doesn't exist)
     *  If the container is not a frame of some type, the containing window for it is used.
     *  THIS ROUTINE IS NOT THREAD SAFE - ONLY CALL FROM THE EVENT DISPATCH THREAD
     */
    private static Shell getModalParent(Container c) {
        if (c == null) {
            if (getRootFrame() == null)
                return getSharedFrame();
            else
                return ((Shell) getRootFrame().getSWTPeer());
        }
        if (!(c.composite instanceof Shell))
            return c.composite.getShell();
        else
            return (Shell) c.composite; 
    }
    private static Shell sharedFrame = null;
    /**
     * Invisible shell used as the parent for dialogs
     * with a null container.
     */
    public static Shell getSharedFrame() {
        if ( sharedFrame == null ) {
            sharedFrame = new Shell(SwingWTUtils.getDisplay(), SWT.NO_TRIM);    
        }
        return sharedFrame;
    }

    public static Object showInternalInputDialog(Container parent, String msg, String title, int type, Object tbd1, Object tbd2, String tbd3)
    {
        // TODO need internal version
        return showInputDialog(parent, msg, title, type);
    }

}

/** 
 * Behaves like the input dialog used by Swing
 */
class SwingStyleInputDialog extends JDialog {
    
    private boolean isTextEntry = false;
    private JTextArea text = null;
    private JList sel = null;
    
    public SwingStyleInputDialog(swingwt.awt.Component parent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        
        super((Frame) null, title, true);
        
        // Is it a text entry? Must be if no choices
        isTextEntry = (selectionValues == null);
        
        // Common items
        // --------------
        setTitle(title);
        
        JLabel mess = new JLabel(message.toString());
        getContentPane().add(mess, BorderLayout.NORTH);
        
        // Buttons
        JPanel pnlButtons = new JPanel();
        getContentPane().add(pnlButtons, BorderLayout.SOUTH);
        
        JButton btnOk = new JButton("Ok");
        btnOk.setMnemonic('O');
        btnOk.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnOk_clicked();    
            }
        });
        pnlButtons.add(btnOk);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setMnemonic('C');
        btnCancel.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnCancel_clicked();    
            }
        });
        pnlButtons.add(btnCancel);
        
        
        if (isTextEntry) {   
            // Present a new text entry area
            JScrollPane scr = new JScrollPane();
            text = new JTextArea();
            text.setWrapStyleWord(true);
            text.setLineWrap(true);
	    if (initialSelectionValue != null)
	        text.setText(initialSelectionValue.toString());
            scr.setViewportView(text);
            scr.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
            scr.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
            getContentPane().add(scr, BorderLayout.CENTER);
            // Set size and display pos of dialog
            setSize(400, 150);
        }
        else
        {
            // Make a JList with stuff in there
            sel = new JList(selectionValues);
            try {
                sel.setSelectedValue(initialSelectionValue, true);
            }
            catch (NullPointerException e) {}
            catch (Exception e) {}
            getContentPane().add(sel, BorderLayout.CENTER);
            // Set size and display pos of dialog
            setSize(400, 300);
        }
        
        // Center it
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = getSize();
        if (frameSize.height > screenSize.height) {
          frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
          frameSize.width = screenSize.width;
        }
        setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }
    
    protected void btnOk_clicked() {
        if (isTextEntry)
            JOptionPane.lastInputDialogReturnValue = text.getText();
        else {
            JOptionPane.lastInputDialogReturnValue = sel.getSelectedValue();
            JOptionPane.lastInputDialogReturnIndex = sel.getSelectedIndex();
        }
        JOptionPane.setJobFinished(true);
        dispose();
    }
    
    protected void btnCancel_clicked() {
        JOptionPane.lastInputDialogReturnValue = null;
        JOptionPane.lastInputDialogReturnIndex = -1;
        JOptionPane.setJobFinished(true);
        dispose();
    }
    
}
