/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley
 
   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.
 
   Contact me by electronic mail: bobintetley@users.sourceforge.net
 
   $Log: JMenu.java,v $
   Revision 1.20  2005/02/16 08:34:36  bobintetley
   JFileChooser.showDialog support, JOptionPane instance support (no dialog creation at present), JSplitPane.getDividerLocation(), PixelGrabber.grabPixels(ms) throws InterruptedException, swingwtx.swing.MenuElement implemented, with JMenu* implementors, JPopupMenu.getSubElements(), JMenuBar.getSubElements(), JMenu.getSubElements()

   Revision 1.19  2005/01/05 09:22:31  bobintetley
   Updated copyright year on source

   Revision 1.18  2005/01/05 08:37:13  bobintetley
   Many compatibility fixes from David Barron

   Revision 1.17  2004/06/10 07:57:59  dannaab
   Added AWTSwingWrapper to map AWT components to the corresponding Swing version.  Implemted using it: TextComponent, TextArea, TextField; used similar technique for Menu components
 
   Revision 1.16  2004/05/05 12:43:21  bobintetley
   Patches/new files from Laurent Martell
 
   Revision 1.15  2004/04/30 16:52:17  bobintetley
   MenuListener support, JViewport support, TreeSelectionModel stubs, additional JTree methods
 
   Revision 1.14  2004/01/26 08:11:00  bobintetley
   Many bugfixes and addition of SwingSet
 
   Revision 1.13  2004/01/23 08:05:07  bobintetley
   JComboBox fixes and better Action implementation
 
   Revision 1.12  2004/01/20 09:17:15  bobintetley
   Menu class overhaul for compatibility, Action support and thread safety
 
   Revision 1.11  2003/12/16 18:49:07  bobintetley
   removeAll() now works
 
   Revision 1.10  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications
 
   Revision 1.9  2003/12/15 16:40:04  bobintetley
   Core methods + skeleton JTableHeader/JScrollBar support
 
   Revision 1.8  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers
 
 */


package swingwtx.swing;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

import swingwt.awt.Component;

import java.util.*;

public class JMenu extends JSWTMenuComponent implements MenuElement {
    
    /** Menu container for this item if it has one */
    private Menu container = null;
    /** The shell this menu is living on, or null if
     *  it is a popup menu */
    private Shell shell = null;
    
    /** Stores children until we're ready */
    private Vector components = new Vector();
    
    private int iRetval;
    private Object retval;
    
    public JMenu() {}
    public JMenu(Action a) { setAction(a); }
    public JMenu(String text) { this(text, false); }
    public JMenu(String text, boolean isTearOff) { pText = text; }
    
    /** Adds a component to the container */
    public JSWTMenuComponent add(final JSWTMenuComponent c) {
        components.add(c);
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(peer)) {
                    try {
                        c.setSwingWTParent(container, shell);
                        c.setCachedProperties();
                        c.registerEvents();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return c;
    }
    
    public JSWTMenuComponent add(JSWTMenuComponent c, String name) {
        return add(c);
    }
    
    public JMenu add(JMenu c) {
        return (JMenu) add((JSWTMenuComponent) c);
    }
    
    public JMenu add(JMenu c, String name) {
        return (JMenu) add((JSWTMenuComponent) c, name);
    }
    
    public JMenuItem add(JMenuItem c) {
        return (JMenuItem) add((JSWTMenuComponent) c);
    }
    
    public JMenuItem add(JMenuItem c, String name) {
        return (JMenuItem) add((JSWTMenuComponent) c, name);
    }
    
    /** Adds an action to the container */
    public JMenuItem add(Action a) {
        JMenuItem jmenu = new JMenuItem(a);
        add(jmenu);
        return jmenu;
    }
    
    /** Adds a new menu item with the specified text */
    public JMenuItem add(String text) {
        JMenuItem jmenu = new JMenuItem(text);
        add(jmenu);
        return jmenu;
    }
    
    /** Adds a component to the menu.
     *  @throws IllegalArgumentException - SwingWT cannot support this.
     */
    public Component add(Component c) {
        throw new IllegalArgumentException("Sorry, SwingWT cannot support components in menus");
    }
    
    /** Adds a component to the menu at the index specified.
     *  @throws IllegalArgumentException - SwingWT cannot support this.
     */
    public Component add(Component c, int index) {
        throw new IllegalArgumentException("Sorry, SwingWT cannot support components in menus");
    }
    
    /** Removes a component from the menu
     *  @throws IllegalArgumentException - SwingWT cannot support this.
     */
    public void remove(Component c) {
        throw new IllegalArgumentException("Sorry, SwingWT cannot support components in menus");
    }
    
    public void remove(JSWTMenuComponent c) {
        c.dispose();
    }
    
    /** Removes the menu item with the specified index from the list */
    public void remove(int index) {
        JSWTMenuComponent c = (JSWTMenuComponent) components.get(index);
        components.remove(index);
        c.dispose();
    }
    
    public void removeAll() {
        Iterator i = components.iterator();
        while (i.hasNext()) {
            JSWTMenuComponent c = (JSWTMenuComponent) i.next();
            c.dispose();
        }
        
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (peer != null && container != null) {
                    // Kill the old container, destroying the children
                    container.dispose();
                    // Recreate it
                    container = new Menu(shell, SWT.DROP_DOWN);
                    peer.setMenu(container);
                }
            }
        });
    }
    
    public void addSeparator() {
        add(new JSeparator());
    }
    
    /** Generates a new JPopupMenu with references to the
     *  same child components as this JMenu. Should work just
     *  like Swing in practice (and doesn't waste objects - aside
     *  from the JPopupMenu itself, the existing objects are reused
     */
    public JPopupMenu getPopupMenu() {
        return new JPopupMenu(components);
    }
    
    public void setSwingWTParent(Menu parent, Shell shell) throws Exception {
        this.shell = shell;
        peer = new MenuItem(parent, SWT.CASCADE);
        container = new Menu(shell, SWT.DROP_DOWN);
        peer.setMenu(container);
        
        // If we have some children waiting to be added, do it now
        if (components.size() > 0) {
            Object[] o = components.toArray();
            for (int i = 0; i < o.length; i++)
                add((JSWTMenuComponent) o[i]);
        }
        
    }
    
    public boolean isSelected() {
        return false;
    }
    
    public void setSelected(boolean b) {
    }
    
    public JMenuItem getItem(final int index) {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(peer))
                    retval = container.getItem(index);
                else
                    retval = components.get(index);
            }
        });
        return (JMenuItem) retval;
    }
    
    public int getItemCount() {
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTMenuControlAvailable(peer))
                    iRetval = container.getItemCount();
                else
                    iRetval = components.size();
            }
        });
        return iRetval;
    }
    
    public boolean isTearOff() { return false; }
    
    public int getMenuComponentCount() {
        // TODO exclude separators from count
        return getItemCount();
    }
    
    public Component getComponent() {
        return (Component) this;
    }
    
    public MenuElement[] getSubElements() {
        MenuElement[] me = new MenuElement[components.size()];
        for (int i = 0; i < components.size(); i++) {
            me[i] = (MenuElement) components.get(i);
        }
        return me;
    }
    
    public void menuSelectionChanged(boolean isIncluded) {
    }
    
    public void processKeyEvent(swingwt.awt.event.KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }
    
    public void processMouseEvent(swingwt.awt.event.MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }
}
