/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: ImageIcon.java,v $
   Revision 1.13  2005/01/05 09:22:30  bobintetley
   Updated copyright year on source

   Revision 1.12  2004/10/30 20:11:57  bobintetley
   Code cleanup

   Revision 1.11  2004/05/14 21:03:56  dannaab
   Sorry for big checkin, includes some whitespace changes made by ant build script.
   also includes bug fix to ImageIcon() constructor

   Revision 1.10  2004/05/04 10:06:52  bobintetley
   Fixes to byte[] pixel data - added getModifiers() to ActionEvent

   Revision 1.9  2004/04/16 10:19:06  dannaab
   Misc bug fixes, InputMap implementation, preliminary undo support

   Revision 1.8  2004/03/01 15:58:47  bobintetley
   Various little bug fixes

   Revision 1.7  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import swingwt.awt.*;
import java.net.*;
import java.io.*;


public class ImageIcon implements Icon {
    
    private String description = null;
    private swingwt.awt.Image image = null;
    
    /** Creates an empty imageicon */
    public ImageIcon() {
        this.image = new swingwt.awt.Image();
    }
    
    public ImageIcon(swingwt.awt.Image image) {   
        this.image = image;
    }
    
    public ImageIcon(swingwt.awt.Image image, String description) {   
        this.image = image;
        setDescription(description);
    }
    
    public ImageIcon(String filename) {
        this(filename, "");
    }
    
    public ImageIcon(String filename, String description) {
        try {
            image = new swingwt.awt.Image();
            image.image = new org.eclipse.swt.graphics.Image(SwingWTUtils.getDisplay(), 
                new FileInputStream(new File(filename)));
            setDescription(description);    
        } catch (Exception e) { e.printStackTrace(); }
    }
    
    public ImageIcon(URL location) {
        try {
            image = new swingwt.awt.Image();
            image.image = new org.eclipse.swt.graphics.Image(SwingWTUtils.getDisplay(), location.openStream());
        } catch (Exception e) { e.printStackTrace(); }
    }
    
    public ImageIcon(URL location, String description) {
        this(location);
        setDescription(description);
    }

    public ImageIcon(byte[] data) {
	this(data, "");
    }
     
    public ImageIcon(byte[] data, String description) {
        try {
            image = new swingwt.awt.Image();
            image.image = new org.eclipse.swt.graphics.Image(SwingWTUtils.getDisplay(),
                new ByteArrayInputStream(data));
            setDescription(description);
        } 
	catch (Exception e) { 
	     e.printStackTrace(); 
	}
    }
				
    
    /** Getter for property description.
     * @return Value of property description.
     *
     */
    public java.lang.String getDescription() {
        return description;
    }    
    
    /** Setter for property description.
     * @param description New value of property description.
     *
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }    
    
    /** Getter for property image.
     * @return Value of property image.
     *
     */
    public swingwt.awt.Image getImage() {
        return image;
    }    
        
    /** Setter for property image.
     * @param image New value of property image.
     *
     */
    public void setImage(swingwt.awt.Image image) {
        this.image = image;
    }    

    public int getIconHeight() {
        if (image == null) return 0;
        if (image.image == null) return 0;
        return image.image.getBounds().height;
    }
    
    public int getIconWidth() {
        if (image == null) return 0;
        if (image.image == null) return 0;
        return image.image.getBounds().width;
    }
    
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (image != null)
            g.drawImage(image, x, y, null);
    }
    
}
