/*
   SwingWT
   Copyright(c)2003-2005, Tomer Bartletz
 
   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.
 
   Contact me by electronic mail: tomerb@users.sourceforge.net

   $Log: ButtonGroup.java,v $
   Revision 1.3  2005/01/05 09:22:30  bobintetley
   Updated copyright year on source

   Revision 1.2  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

 */
package swingwtx.swing;

import java.util.*;

/**
 * This class is used to create a multiple-exclusion scope for
 * a set of buttons. Creating a set of buttons with the
 * same <code>ButtonGroup</code> object means that
 * turning "on" one of those buttons
 * turns off all other buttons in the group.
 *
 * @author Tomer Barletz, tomerb@users.sourceforge.net
 * @version
 */
public class ButtonGroup {
    
    protected Vector buttons = new Vector();
    ButtonModel selection = null;
    
    public ButtonGroup() {}
    
    public void add(AbstractButton b) {
        buttons.add(b);
        if (b.isSelected()) {
            if (selection == null) {
                selection = b.getModel();
            } else {
                b.setSelected(false);
            }
        }
        b.getModel().setGroup(this);
    }
    
    public void remove(AbstractButton b) {
        if(b == null) {
            return;
        }
        buttons.remove(b);
        if(b.getModel() == selection) {
            selection = null;
        }
        b.getModel().setGroup(null);
    }
    
    public Enumeration getElements() {
        return buttons.elements();
    }
    
    public ButtonModel getSelection() {
        return selection;
    }
    
    public void setSelected(ButtonModel m, boolean b) {
        if (b && m != null && m != selection) {
            ButtonModel oldSelection = selection;
            selection = m;
            if (oldSelection != null) {
                oldSelection.setSelected(false);
            }
            m.setSelected(true);
        }
    }
    
    public boolean isSelected(ButtonModel m) {
        return (m == selection);
    }
    
    public int getButtonCount() {
        if (buttons == null) {
            return 0;
        } else {
            return buttons.size();
        }
    }
    
}
