/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley
 
   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.
 
   Contact me by electronic mail: bobintetley@users.sourceforge.net
 
   $Log: Dimension2D.java,v $
   Revision 1.5  2005/01/05 09:22:27  bobintetley
   Updated copyright year on source

   Revision 1.4  2004/04/30 23:18:26  dannaab
   List selection support, misc bug fixes

   Revision 1.3  2004/04/23 00:52:32  dannaab
   Handle borders in a Swing-like way. Implement EmptyBorder & TitledBorder

   Revision 1.2  2004/04/20 16:36:13  bobintetley
   Code cleanup

   Revision 1.1  2004/01/15 15:20:29  bobintetley
   Java2D work

 
 */

package swingwt.awt.geom;

public abstract class Dimension2D implements Cloneable {
    protected Dimension2D() {
    }
    public abstract double getWidth();
    public abstract double getHeight();
    public abstract void setSize(double width, double height);
    public void setSize(Dimension2D d) {
        setSize(d.getWidth(), d.getHeight());
    }
    public Object clone() {
	    try {
	        return super.clone();
	    } catch (CloneNotSupportedException e) { throw new InternalError(); }
    }
}
