/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: LineMetrics.java,v $
   Revision 1.2  2005/01/05 09:22:27  bobintetley
   Updated copyright year on source

   Revision 1.1  2004/01/15 15:20:29  bobintetley
   Java2D work


*/

package swingwt.awt.font;
    
public class LineMetrics {

    private int numChars = 0;
    private float ascent = 0;
    private float descent = 0;
    private float leading = 0;
    private float height = 0;
    private int baselineindex = 0;
    private float[] baselineoffsets = null;
    private float strikethroughoffset = 0;
    private float strikethroughthickness = 1;
    private float underlineoffset = 1;
    private float underlinethickness = 1;
    
    public LineMetrics(int numChars, int height) { this.numChars = numChars; this.height = height; strikethroughoffset = height / 2; }
    
    public int getNumChars() { return numChars; }
    public float getAscent() { return ascent; }
    public float getDescent() { return descent; }
    public float getLeading() { return leading; }
    public float getHeight() { return height; }
    public int getBaselineIndex() { return baselineindex; }
    public float[] getBaselineOffsets() { return baselineoffsets; }
    public float getStrikethroughOffset() { return strikethroughoffset; }
    public float getStrikethroughThickness() { return strikethroughthickness; }
    public float getUnderlineOffset() { return underlineoffset; }
    public float getUnderlineThickness() { return underlinethickness; }
}
