/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: FontRenderContext.java,v $
   Revision 1.4  2005/01/05 09:22:27  bobintetley
   Updated copyright year on source

   Revision 1.3  2004/10/30 20:11:55  bobintetley
   Code cleanup

   Revision 1.2  2004/04/21 10:44:06  bobintetley
   Code cleanup and native build script fix

   Revision 1.1  2004/01/15 15:20:29  bobintetley
   Java2D work


*/

package swingwt.awt.font;

import swingwt.awt.geom.*;

public class FontRenderContext {
    private AffineTransform tx;
    private boolean bIsAntiAliased;
    private boolean bUsesFractionalMetrics;
    
    protected FontRenderContext() {
    }
    
    public FontRenderContext(AffineTransform tx,
                            boolean isAntiAliased,
                            boolean usesFractionalMetrics) {
        if (tx != null && !tx.isIdentity()) {
            this.tx = new AffineTransform(tx);
        }
        this.bIsAntiAliased = isAntiAliased;
        this.bUsesFractionalMetrics = usesFractionalMetrics;
    }
    
    public AffineTransform getTransform() {
        return (tx == null) ? new AffineTransform() : new AffineTransform(tx);
    }
    
    public boolean isAntiAliased() {
        return this.bIsAntiAliased;
    }
    
    public boolean usesFractionalMetrics() {
        return this.bUsesFractionalMetrics;
    }
    
    public boolean equals(FontRenderContext rhs) {
	if (this == rhs) {
	    return true;
	}
	if (rhs != null &&
	    rhs.bIsAntiAliased == bIsAntiAliased &&
	    rhs.bUsesFractionalMetrics == bUsesFractionalMetrics) {
	    return tx == null ? rhs.tx == null : tx.equals(rhs.tx);
	}
	return false;
    }
}
