/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: ItemEvent.java,v $
   Revision 1.4  2005/03/09 09:41:00  bobintetley
   (David Green) Various compatibility fixes

   Revision 1.3  2005/01/05 09:22:27  bobintetley
   Updated copyright year on source

   Revision 1.2  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwt.awt.event;

import swingwt.awt.*;

public class ItemEvent extends AWTEvent {

    public static final int SELECTED = 0;
    public static final int DESELECTED = 1;
    
    public static final int ITEM_STATE_CHANGED = 701;

    protected Object item;
    protected int stateChange;
    
    public ItemEvent(Object source, int id, Object item, int stateChange) {
        super(source, id);
	this.item = item;
        this.stateChange = stateChange;
    }

    public Object getItemSelectable() {
        return source;
    }

    public Object getItem() {
        return item;
    }

    public int getStateChange() {
        return stateChange;
    }
    
}
