/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: MenuItem.java,v $
   Revision 1.10  2005/01/05 09:22:25  bobintetley
   Updated copyright year on source

   Revision 1.9  2004/10/30 20:11:54  bobintetley
   Code cleanup

   Revision 1.8  2004/06/11 09:17:30  bobintetley
   Various fixes and things

   Revision 1.7  2004/06/11 03:29:26  dannaab
   AWT improvements: implement Button over JButton; Menu fixes; add missing geom me
   thods; add some missing awt event methods/features

   Revision 1.6  2004/06/10 07:57:57  dannaab
   Added AWTSwingWrapper to map AWT components to the corresponding Swing version.  Implemted using it: TextComponent, TextArea, TextField; used similar technique for Menu components

   Revision 1.5  2004/04/20 15:11:25  bobintetley
   awt.MenuShortcut implementation

   Revision 1.4  2004/01/15 10:11:14  bobintetley
   Fixed AWT constructors/hierarchy

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwt.awt;

import java.util.Vector;

import swingwt.awt.event.ActionListener;
import swingwtx.accessibility.AccessibleContext;
import swingwtx.swing.JMenuItem;
import swingwtx.swing.KeyStroke;

public class MenuItem extends MenuComponent {
    
    protected MenuShortcut shortcut = null;
    
    private Vector actionListeners = new Vector();
    
    public MenuItem() { swingPeer = new JMenuItem(); }
    public MenuItem(String text) { swingPeer = new JMenuItem(text); }
    
    private JMenuItem getSwingPeer() { return (JMenuItem) swingPeer; }

    public MenuShortcut getShortcut() { return shortcut; }
    public void deleteShortcut() { getSwingPeer().setAccelerator(null); }
    public void setShortcut(MenuShortcut s) { 
        // Translate menu shortcut to swing Keystroke
        shortcut = s; 
        KeyStroke ks = KeyStroke.getKeyStroke( s.getKey(), 
            ( s.usesShiftModifier() ? swingwt.awt.event.KeyEvent.SHIFT_MASK : 0 ) |
            swingwt.awt.event.KeyEvent.CTRL_MASK
            );
        getSwingPeer().setAccelerator(ks);
    }
    
    public void addActionListener(ActionListener l) { getSwingPeer().addActionListener(l); }
    
    // TODO: Implement
    //protected void disableEvents(long eventsToDisable) {  }
    //protected void enableEvents(long eventsToEnable) {  }
	//protected void processActionEvent(ActionEvent e) { getSwingPeer().processActionEvent(e); }
	
	public void setEnabled(boolean b) { getSwingPeer().setEnabled(b); }
	public void enable() { setEnabled(true); }
	public void enable(boolean b) { setEnabled(b); }
    public void disable() { setEnabled(false); }
	
	public AccessibleContext getAccessibleContext() { return swingPeer.getAccessibleContext(); }
	public String getActionCommand() { return getSwingPeer().getActionCommand(); }
	public ActionListener[] getActionListeners() { return (ActionListener[])actionListeners.toArray(new ActionListener[0]); }
	/** @deprecated - replaced by getText() */
	public String getLabel() { return getSwingPeer().getText(); }
	public boolean isEnabled() { return getSwingPeer().isEnabled(); }
	public void removeActionListener(ActionListener l) { getSwingPeer().removeActionListener(l); }
	public void setActionCommand(String command) { getSwingPeer().setActionCommand(command); }
	/** @deprecated - replaced by setText() */
	public void setLabel(String label) { getSwingPeer().setText(label); }
}
