/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: Label.java,v $
   Revision 1.8  2005/01/05 09:22:25  bobintetley
   Updated copyright year on source

   Revision 1.7  2004/06/08 09:24:21  dannaab
   Rename Component.getPeer() -> getSWTPeer().  added ComponentPeer and stubbed out support classes.

   Revision 1.6  2004/06/04 22:02:45  dannaab
   Add set/get Alignment to swingwt.awt.Label

   Revision 1.5  2004/03/21 17:22:53  bobintetley
   Compatibility methods for awt Graphics, List and Label. Dummy Applet implementation

   Revision 1.4  2004/01/15 10:11:14  bobintetley
   Fixed AWT constructors/hierarchy

   Revision 1.3  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/

package swingwt.awt;

public class Label extends swingwtx.swing.JLabel {
    public final static int CENTER = swingwtx.swing.JLabel.CENTER;
    public final static int LEFT = swingwtx.swing.JLabel.LEFT;
    public final static int RIGHT = swingwtx.swing.JLabel.RIGHT;
    public Label() { super(); }
    public Label(String text) { super(text); }
    public Label(String text, int align) { super(text); super.setHorizontalAlignment(align); }
    public void setAlignment(int alignment) { super.setHorizontalAlignment(alignment); };
    public int getAlignment() { return super.getHorizontalAlignment(); };
}
