/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley
 
   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.
 
   Contact me by electronic mail: bobintetley@users.sourceforge.net
 
   $Log: GraphicsConfiguration.java,v $
   Revision 1.5  2005/01/05 09:22:25  bobintetley
   Updated copyright year on source

   Revision 1.4  2004/10/30 20:11:54  bobintetley
   Code cleanup

   Revision 1.3  2004/04/20 15:11:25  bobintetley
   awt.MenuShortcut implementation


 */
package swingwt.awt;

import swingwt.awt.geom.AffineTransform;
import swingwt.awt.image.*;

/**
 * Another great abstract class which
 * is implimented in SwingWT.
 * 
 * @see swingwt.awt.Graphics
 * @author Daniel Spiewak
 */
public class GraphicsConfiguration {

	private static BufferCapabilities defaultBufferCaps;
	private static ImageCapabilities defaultImageCaps;

	protected GraphicsConfiguration() {
		
	}

	public GraphicsDevice getDevice() {
		return null;
	}

	public BufferedImage createCompatibleImage(int width, int height) {
		return null;
	}

	public VolatileImage createCompatibleVolatileImage(int width, int height) {
		return null;
	}

	public VolatileImage createCompatibleVolatileImage(int width, int height, ImageCapabilities caps) throws AWTException {
		// REMIND : check caps
		return createCompatibleVolatileImage(width, height);
	}

	public BufferedImage createCompatibleImage(int width, int height, int transparency) {
		return null;
	}

	public ColorModel getColorModel() {
		return null;
	}

	public ColorModel getColorModel(int transparency) {
		return null;
	}

	public AffineTransform getDefaultTransform() {
		return null;
	}

	public AffineTransform getNormalizingTransform() {
		return null;
	}

	public Rectangle getBounds() {
		return new Rectangle( 0, 0, Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height );
	}

	private static class DefaultBufferCapabilities extends BufferCapabilities {
		public DefaultBufferCapabilities(ImageCapabilities imageCaps) {
			super(imageCaps, imageCaps, null);
		}
	}

	public BufferCapabilities getBufferCapabilities() {
		if (defaultBufferCaps == null) {
			defaultBufferCaps =
				new DefaultBufferCapabilities(getImageCapabilities());
		}
		return defaultBufferCaps;
	}

	public ImageCapabilities getImageCapabilities() {
		if (defaultImageCaps == null) {
			defaultImageCaps = new ImageCapabilities(false);
		}
		return defaultImageCaps;
	}
}

/*
 *****************************************************
 * Copyright 2003 Completely Random Solutions *
 *                                												*
 * DISCLAMER:                                 					*
 * We are not responsible for any damage      		*
 * directly or indirectly caused by the usage 			*
 * of this or any other class in assosiation  			*
 * with this class.  Use at your own risk.   			*
 * This or any other class by CRS is not   			*
 * certified for use in life support systems, 			*
 * the Space Shuttle, in use or developement  		*
 * of nuclear reactors, weapons of mass       		*
 * destruction, or in interplanitary conflict.				*
 * (Unless otherwise specified)               				*
 *****************************************************
 */