/*
   SwingWT
   Copyright(c)2003-2005, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: AWTEvent.java,v $
   Revision 1.7  2005/01/05 09:22:24  bobintetley
   Updated copyright year on source

   Revision 1.6  2003/12/15 15:54:25  bobintetley
   Additional core methods

   Revision 1.5  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwt.awt;

public class AWTEvent extends java.util.EventObject implements java.io.Serializable {
    
    protected int eventID = 0;
    protected boolean consumed = false;
    
    public AWTEvent(Object source) {
        super(source);
    }
    public AWTEvent(Object source, int id) {
        super(source);
        eventID = id;
    }
    
    public int getID() {
        return eventID;    
    }
    
    public void setSource(Object newSource) {
        this.source = newSource;    
    }
    
    public boolean isConsumed() {
        return consumed;
    }
    
    public void consume() {
        consumed = true;
    }
    
}
