/**********************************************************************
 * Copyright (c) 2003-2004 IBM Corp.
 * Portions Copyright (c) 1983-2002, Apple Computer, Inc.
 *
 * All rights reserved.  This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.swt.internal.carbon;

 
import org.eclipse.swt.internal.*;

public class OS extends Platform {
	static {
		Library.loadLibrary ("swt-pi");
	}
	
	/** Constants */
	public static final int RGBDirect = 16;
	public static final int alphaLock = 0x0400;
	public static final int bold = 1;
	public static final int cantGetFlavorErr = -1854;
	public static final int checkMark = 18;
	public static final int cmdKey = 1 << 8;
	public static final int controlKey = 1 << 12;
	public static final int diamondMark = 19;
	public static final int dragNotAcceptedErr = -1857;
	public static final int errControlIsNotEmbedder = -30590;
	public static final int errUnknownControl = -30584;
	public static final int eventLoopTimedOutErr = -9875;
	public static final int eventNotHandledErr = -9874;
	public static final int gestaltSystemVersion = ('s'<<24) + ('y'<<16) + ('s'<<8) + 'v';
	public static final int inContent = 3;
	public static final int inMenuBar = 1;
	public static final int inStructure = 15;
	public static final int inZoomIn = 7;
	public static final int inZoomOut = 8;
	public static final int italic = 2;
	public static final int k32ARGBPixelFormat = 0x00000020;
	public static final int kAEQuitApplication = ('q'<<24) + ('u'<<16) + ('i'<<8) + 't';
	public static final int kAlertCautionAlert = 2;
	public static final int kAlertCautionIcon = ('c'<<24) + ('a'<<16) + ('u'<<8) + 't';
	public static final int kAlertNoteAlert = 1;
	public static final int kAlertNoteIcon = ('n'<<24) + ('o'<<16) + ('t'<<8) + 'e';
	public static final int kAlertPlainAlert = 3;
	public static final int kAlertStopAlert = 0;
	public static final int kAlertStopIcon = ('s'<<24) + ('t'<<16) + ('o'<<8) + 'p';
	public static final int kAlertDefaultOKText           = -1;
	public static final int kAlertDefaultCancelText       = -1;
	public static final int kAlertStdAlertOKButton        = 1;
	public static final int kAlertStdAlertCancelButton    = 2;
	public static final int kAlertStdAlertOtherButton     = 3;
	public static final int kAtSpecifiedOrigin = 0;
	public static final int kATSDeletedGlyphcode = 0xFFFF;
	public static final int kATSUDirectDataBaselineDeltaFixedArray = 1;
	public static final int kATSUDirectDataLayoutRecordATSLayoutRecordVersion1 = 100;
	public static final int kATSUDirectDataLayoutRecordATSLayoutRecordCurrent = kATSUDirectDataLayoutRecordATSLayoutRecordVersion1;
	public static final int kATSULineAscentTag = 8;
	public static final int kATSULineDescentTag = 9;
	public static final int kATSULineDirectionTag = 3;
	public static final int kATSLineUseDeviceMetrics = 0x01000000;
	public static final int kATSUStartAlignment = 0x00000000;
	public static final int kATSUEndAlignment = 0x40000000;
	public static final int kATSUCenterAlignment = 0x20000000;
	public static final int kATSUByCharacter = 0;
	public static final int kATSUByTypographicCluster = 1;
	public static final int kATSUByWord = 2;
	public static final int kATSUByCharacterCluster = 3;
	public static final int kATSUColorTag = 263;
	public static final int kATSUCGContextTag = 32767;
	public static final int kATSUFontTag = 261;
	public static final int kATSULineFlushFactorTag = 5;
	public static final int kATSULineHighlightCGColorTag = 17;
	public static final int kATSULineLayoutOptionsTag = 7;
	public static final int kATSULineWidthTag = 1;
	public static final int kATSULeftToRightBaseDirection = 0;
	public static final int kATSURightToLeftBaseDirection = 1;
	public static final int kATSUQDBoldfaceTag = 256;
	public static final int kATSUQDItalicTag = 257;
	public static final int kATSUQDUnderlineTag = 258;
	public static final int kATSUStyleStrikeThroughTag = 292;
	public static final int kATSULeftTab = 0;
	public static final int kATSUseDeviceOrigins = 1;
	public static final int kATSUSizeTag = 262;
	public static final int kATSUToTextEnd = 0xFFFFFFFF;
	public static final int kCFAllocatorDefault = 0;
	public static final int kCFURLPOSIXPathStyle = 0;
	public static final int kCFStringEncodingASCII = 0x0600;
	public static final int kCGEncodingMacRoman = 1;
	public static final int kCGImageAlphaFirst = 4;
	public static final int kCGImageAlphaNoneSkipFirst = 6;
	public static final int kCGLineCapButt = 0;
	public static final int kCGLineCapRound = 1;
	public static final int kCGLineCapSquare = 2;
	public static final int kCGLineJoinMiter = 0;
	public static final int kCGLineJoinRound = 1;
	public static final int kCGLineJoinBevel = 2;
	public static final int kCGTextFill = 0;
	public static final int kCGTextInvisible = 3;
	public static final int kColorPickerDialogIsMoveable =  1;
	public static final int kColorPickerDialogIsModal = 2;
	public static final int kControlBehaviorPushbutton = 0;
	public static final int kControlBehaviorToggles = 0x0100;
	public static final int kControlBevelButtonAlignCenter = 0;
	public static final int kControlBevelButtonAlignLeft  = 1;
	public static final int kControlBevelButtonAlignRight = 2;
	public static final int kControlBevelButtonAlignTextCenter = 1;
	public static final int kControlBevelButtonAlignTextFlushRight = -1;
	public static final int kControlBevelButtonAlignTextFlushLeft = -2;
	public static final int kControlBevelButtonNormalBevelProc = 33;
	public static final int kControlBevelButtonSmallBevel = 0;
	public static final int kControlBevelButtonLargeBevel = 2;
	public static final int kControlBevelButtonMenuRefTag = ('m'<<24) + ('h'<<16) + ('n'<<8) + 'd';
	public static final int kControlBevelButtonNormalBevel = 1;
	public static final int kControlBevelButtonPlaceBelowGraphic = 3;
	public static final int kControlBevelButtonPlaceToRightOfGraphic = 1;
	public static final int kControlBevelButtonKindTag = ('b'<<24) + ('e'<<16) + ('b'<<8) + 'k';
	public static final int kControlBevelButtonTextAlignTag = ('t'<<24) + ('a'<<16) + ('l'<<8) + 'i';
	public static final int kControlBevelButtonTextPlaceTag = ('t'<<24) + ('p'<<16) + ('l'<<8) + 'c';
	public static final int kControlBevelButtonGraphicAlignTag = ('g'<<24) + ('a'<<16) + ('l'<<8) + 'i';
	public static final int kControlBoundsChangeSizeChanged = 1 << 2;
	public static final int kControlBoundsChangePositionChanged = 1 << 3;
	public static final int kControlCheckBoxAutoToggleProc = 371;
	public static final int kControlContentCIconHandle = 130;
	public static final int kControlContentIconRef = 132;
	public static final int kControlContentMetaPart = -2;
	public static final int kControlContentTextOnly = 0;
	public static final int kControlDataBrowserIncludesFrameAndFocusTag = ('b'<<24) + ('r'<<16) + ('d'<<8) + 'r';
	public static final int kControlDownButtonPart = 21;
	public static final int kControlEditTextCFStringTag = ('c'<<24) + ('f'<<16) + ('s'<<8) + 't';
	public static final int kControlEditTextLockedTag = ('l'<<24) + ('o'<<16) + ('c'<<8) + 'k';
	public static final int kControlEditTextSingleLineTag = ('s'<<24) + ('g'<<16) + ('l'<<8) + 'c';
	public static final int kControlEditTextSelectionTag = ('s'<<24) + ('e'<<16) + ('l'<<8) + 'e';
	public static final int kControlEditTextTextTag = ('t'<<24) + ('e'<<16) + ('x'<<8) + 't';
	public static final int kControlEntireControl = 0;
	public static final int kControlFocusNoPart = 0;
	public static final int kControlFontStyleTag = ('f'<<24) + ('o'<<16) + ('n'<<8) + 't';
	public static final int kControlGetsFocusOnClick = 1 << 8;
	public static final int kControlGroupBoxTextTitleProc = 160;
	public static final int kControlHandlesTracking = 1 << 5;
	public static final int kControlIconTransformTag = ('t'<<24) + ('r'<<16) + ('f'<<8) + 'm';
	public static final int kControlIndicatorPart = 129;
	public static final int kControlMsgApplyTextColor = 30;
	public static final int kControlMsgSetUpBackground = 23;
	public static final int kControlPageDownPart = 23;
	public static final int kControlPageUpPart = 22;
	public static final int kControlPopupArrowEastProc = 192;
	public static final int kControlPopupArrowOrientationEast = 0;
	public static final int kControlPopupArrowOrientationWest = 1;
	public static final int kControlPopupArrowOrientationNorth = 2;
	public static final int kControlPopupArrowOrientationSouth = 3;
	public static final int kControlPopupArrowSizeNormal  = 0;
	public static final int kControlPopupArrowSizeSmall   = 1;
	public static final int kControlPopupButtonProc = 400;
	public static final int kControlProgressBarIndeterminateTag = ('i'<<24) + ('n'<<16) + ('d'<<8) + 'e';
	public static final int kControlProgressBarProc = 80;
	public static final int kControlPushButtonProc = 368;
	public static final int kControlRadioButtonAutoToggleProc = 372;
	public static final int kControlScrollBarLiveProc = 386;
	public static final int kControlSeparatorLineProc = 144;
	public static final int kControlSliderLiveFeedback = (1 << 0);
	public static final int kControlSliderNonDirectional = (1 << 3);
	public static final int kControlSliderProc = 48;
	public static final int kControlStructureMetaPart = -1;
	public static final int kControlSupportsEmbedding = 1 << 1;
	public static final int kControlSupportsFocus = 1 << 2;
	public static final int kControlStaticTextCFStringTag = ('c'<<24) + ('f'<<16) + ('s'<<8) + 't';
	public static final int kControlTabContentRectTag = ('r'<<24) + ('e'<<16) + ('c'<<8) + 't';
	public static final int kControlTabDirectionNorth = 0;
	public static final int kControlTabDirectionSouth = 1;
	public static final int kControlTabImageContentTag = ('c'<<24) + ('o'<<16) + ('n'<<8) + 't';
	public static final int kControlTabInfoVersionOne = 1;
	public static final int kControlTabInfoTag = ('t'<<24) + ('a'<<16) + ('b'<<8) + 'i';
	public static final int kControlTabSizeLarge = 0;
	public static final int kControlTabSmallProc = 129;
	public static final int kControlUpButtonPart = 20;
	public static final int kControlUserPaneDrawProcTag = ('d'<<24) + ('r'<<16) + ('a'<<8) + 'w';
	public static final int kControlUserPaneHitTestProcTag = ('h'<<24) + ('i'<<16) + ('t'<<8) + 't';
	public static final int kControlUserPaneProc = 256;
	public static final int kControlUserPaneTrackingProcTag = ('t'<<24) + ('r'<<16) + ('a'<<8) + 'k';
	public static final int kControlUseBackColorMask = 16;
	public static final int kControlUseFontMask = 0x1;
	public static final int kControlUseForeColorMask = 8;
	public static final int kControlUseJustMask = 0x0040;
	public static final int kControlUseSizeMask = 0x4;
	public static final int kControlUseThemeFontIDMask = 0x80;
	public static final int kControlUseFaceMask = 0x2;
	public static final int kCurrentProcess = 2;
	public static final int kDataBrowserCheckboxType = ('c'<<24) + ('h'<<16) + ('b'<<8) + 'x';
	public static final int kDataBrowserCmdTogglesSelection = 1 << 3;
	public static final int kDataBrowserContainerClosed = 10;
	public static final int kDataBrowserContainerClosing = 9;
	public static final int kDataBrowserContainerIsClosableProperty = 6;
	public static final int kDataBrowserContainerIsOpen = 1 << 1;
	public static final int kDataBrowserContainerIsOpenableProperty = 5;
	public static final int kDataBrowserContainerIsSortableProperty = 7;
	public static final int kDataBrowserContainerOpened = 8;
	public static final int kDataBrowserCustomType = 0x3F3F3F3F;
	public static final int kDataBrowserDefaultPropertyFlags = 0;
	public static final int kDataBrowserDragSelect = 1 << 0;
	public static final int kDataBrowserIconAndTextType = ('t'<<24) + ('i'<<16) + ('c'<<8) + 'n';
	public static final int kDataBrowserItemAnyState = -1;
	public static final int kDataBrowserItemIsActiveProperty = 1;
	public static final int kDataBrowserItemIsContainerProperty = 4;
	public static final int kDataBrowserItemIsEditableProperty = 3;
	public static final int kDataBrowserItemIsSelectableProperty = 2;
	public static final int kDataBrowserItemIsSelected = 1 << 0;
	public static final int kDataBrowserItemNoProperty = 0;
	public static final int kDataBrowserItemParentContainerProperty = 11;
	public static final int kDataBrowserItemsAdd = 0;
	public static final int kDataBrowserItemsAssign = 1;
	public static final int kDataBrowserItemsRemove = 3;
	public static final int kDataBrowserItemRemoved = 2;
	public static final int kDataBrowserItemSelected = 5;
	public static final int kDataBrowserItemDeselected = 6;
	public static final int kDataBrowserItemDoubleClicked = 7;
	public static final int kDataBrowserLatestCallbacks = 0;
	public static final int kDataBrowserLatestCustomCallbacks = 0;
	public static final int kDataBrowserListView = ('l'<<24) + ('s'<<16) + ('t'<<8) + 'v';
	public static final int kDataBrowserListViewLatestHeaderDesc = 0;
	public static final int kDataBrowserListViewMovableColumn = 1 << OS.kDataBrowserViewSpecificFlagsOffset + 1;
	public static final int kDataBrowserListViewSelectionColumn = 1 << OS.kDataBrowserViewSpecificFlagsOffset;
	public static final int kDataBrowserListViewSortableColumn = 1 << 18;
	public static final int kDataBrowserNeverEmptySelectionSet = 1 << 6;
	public static final int kDataBrowserNoItem = 0;
	public static final int kDataBrowserOrderIncreasing = 1;
	public static final int kDataBrowserPropertyEnclosingPart = 0;
	public static final int kDataBrowserPropertyContentPart =  ('-'<<24) + ('-'<<16) + ('-'<<8) + '-';
	public static final int kDataBrowserPropertyDisclosurePart =  ('d'<<24) + ('i'<<16) + ('s'<<8) + 'c';
	public static final int kDataBrowserPropertyIsMutable = 1 << 0;
	public static final int kDataBrowserRevealOnly = 0;
	public static final int kDataBrowserRevealAndCenterInView = 1 << 0;
	public static final int kDataBrowserRevealWithoutSelecting = 1 << 1;
	public static final int kDataBrowserSelectOnlyOne = 1 << 1;
	public static final int kDataBrowserUserStateChanged = 13;
	public static final int kDataBrowserUserToggledContainer = 16;
	public static final int kDataBrowserTextType = ('t'<<24) + ('e'<<16) + ('x'<<8) + 't';
	public static final int kDataBrowserTableViewFillHilite = 1;
	public static final int kDataBrowserViewSpecificFlagsOffset = 16;
	public static final int kDocumentWindowClass = 6;
	public static final int kDragActionNothing = 0;
	public static final int kDragActionCopy = 1;
	public static final int kDragActionAlias = 1 << 1;
	public static final int kDragActionGeneric = 1 << 2;
	public static final int kDragActionPrivate = 1 << 3;
	public static final int kDragActionMove = 1 << 4;
	public static final int kDragActionDelete = 1 << 5;
	public static final int kDragActionAll = 0xFFFFFFFF;
	public static final int kDragTrackingEnterHandler = 1;
	public static final int kDragTrackingEnterWindow = 2;
	public static final int kDragTrackingInWindow = 3;
	public static final int kDragTrackingLeaveWindow = 4;
	public static final int kDragTrackingLeaveHandler = 5;
	public static final int kEventAppleEvent = 1;
	public static final int kEventAttributeUserEvent = 1 << 0;
	public static final int kEventClassAppleEvent = ('e'<<24) + ('p'<<16) + ('p'<<8) + 'c';
	public static final int kEventClassCommand = ('c'<<24) + ('m'<<16) + ('d'<<8) + 's';
	public static final int kEventClassControl = ('c'<<24) + ('n'<<16) + ('t'<<8) + 'l';
	public static final int kEventClassFont= ('f'<<24) + ('o'<<16) + ('n'<<8) + 't';
	public static final int kEventClassHIObject = ('h'<<24) + ('i'<<16) + ('o'<<8) + 'b';
	public static final int kEventClassKeyboard = ('k'<<24) + ('e'<<16) + ('y'<<8) + 'b';
	public static final int kEventClassMenu = ('m'<<24) + ('e'<<16) + ('n'<<8) + 'u';
	public static final int kEventClassMouse = ('m'<<24) + ('o'<<16) + ('u'<<8) + 's';
	public static final int kEventClassTextInput = ('t'<<24) + ('e'<<16) + ('x'<<8) + 't';
	public static final int kEventClassWindow = ('w'<<24) + ('i'<<16) + ('n'<<8) + 'd';
	public static final int kEventControlApplyBackground = 5;
	public static final int kEventControlActivate = 9;
  	public static final int kEventControlAddedSubControl = 152;
	public static final int kEventControlBoundsChanged = 154;
	public static final int kEventControlClick = 13;
	public static final int kEventControlContextualMenuClick = 12;
  	public static final int kEventControlDeactivate = 10;
	public static final int kEventControlDraw = 4;
	public static final int kControlFocusNextPart = -1;
	public static final int kEventControlHit = 1;
	public static final int kEventControlSetCursor = 11;
	public static final int kEventControlSetFocusPart = 7;
	public static final int kEventControlRemovingSubControl = 153;
	public static final int kEventControlTrack = 51;
	public static final int kEventPriorityStandard = 1;
	public static final double kEventDurationForever = -1.0;
	public static final double kEventDurationNoWait = 0.0;
	public static final int kEventFontSelection = 2;
	public static final int kEventFontPanelClosed = 1;
	public static final int kEventHIObjectConstruct = 1;
	public static final int kEventHIObjectDestruct = 3;
	public static final int kEventMenuClosed = 5;
	public static final int kEventMenuDrawItemContent = 103;
	public static final int kEventMenuMeasureItemWidth = 100;
	public static final int kEventMenuOpening = 4;
	public static final int kEventMenuPopulate = 9;
	public static final int kEventMenuTargetItem = 6;
	public static final int kEventMouseButtonPrimary = 1;
	public static final int kEventMouseButtonSecondary = 2;
	public static final int kEventMouseButtonTertiary = 3;
	public static final int kEventMouseDown = 1;
	public static final int kEventMouseDragged = 6;
	public static final int kEventMouseEntered = 8;
	public static final int kEventMouseExited = 9;
	public static final int kEventMouseMoved = 5;
	public static final int kEventMouseUp = 2;
	public static final int kEventMouseWheelAxisX = 0;
	public static final int kEventMouseWheelAxisY = 1;
	public static final int kEventMouseWheelMoved = 10;
	public static final int kEventParamAEEventClass = ('e'<<24) + ('v'<<16) + ('c'<<8) + 'l';
	public static final int kEventParamAEEventID = ('e'<<24) + ('v'<<16) + ('t'<<8) + 'i';
	public static final int kEventParamATSUFontID = ('a'<<24) + ('u'<<16) + ('i'<<8) + 'd';
	public static final int kEventParamAttributes = ('a'<<24) + ('t'<<16) + ('t'<<8) + 'r';
	public static final int kEventParamCGContextRef= ('c'<<24) + ('n'<<16) + ('t'<<8) + 'x';
	public static final int kEventParamClickCount = ('c'<<24) + ('c'<<16) + ('n'<<8) + 't';
	public static final int kEventParamControlPart= ('c'<<24) + ('p'<<16) + ('r'<<8) + 't';
	public static final int kEventParamControlRef = ('c'<<24) + ('t'<<16) + ('r'<<8) + 'l';
	public static final int kEventParamCurrentBounds = ('c'<<24) + ('r'<<16) + ('c'<<8) + 't';
	public static final int kEventParamDirectObject = ('-'<<24) + ('-'<<16) + ('-'<<8) + '-';
	public static final int kEventParamFMFontFamily = ('f'<<24) + ('m'<<16) + ('f'<<8) + 'm';
	public static final int kEventParamFMFontStyle = ('f'<<24) + ('m'<<16) + ('s'<<8) + 't';
	public static final int kEventParamFMFontSize = ('f'<<24) + ('m'<<16) + ('s'<<8) + 'z';
	public static final int kEventParamFontColor = ('f'<<24) + ('c'<<16) + ('l'<<8) + 'r';
	public static final int kEventParamKeyCode = ('k'<<24) + ('c'<<16) + ('o'<<8) + 'd';
	public static final int kEventParamKeyMacCharCodes = ('k'<<24) + ('c'<<16) + ('h'<<8) + 'r';
	public static final int kEventParamKeyModifiers = ('k'<<24) + ('m'<<16) + ('o'<<8) + 'd';
	public static final int kEventParamMenuCommand = ('m'<<24) + ('c'<<16) + ('m'<<8) + 'd';
	public static final int kEventParamMenuItemIndex = ('i'<<24) + ('t'<<16) + ('e'<<8) + 'm';
	public static final int kEventParamMenuItemBounds = ('m'<<24) + ('i'<<16) + ('t'<<8) + 'b';
	public static final int kEventParamMenuItemWidth = ('m'<<24) + ('i'<<16) + ('t'<<8) + 'w';
	public static final int kEventParamMouseButton = ('m'<<24) + ('b'<<16) + ('t'<<8) + 'n';
	public static final int kEventParamMouseChord = ('c'<<24) + ('h'<<16) + ('o'<<8) + 'r';
	public static final int kEventParamMouseLocation = ('m'<<24) + ('l'<<16) + ('o'<<8) + 'c';
	public static final int kEventParamMouseWheelAxis = ('m'<<24) + ('w'<<16) + ('a'<<8) + 'x';
	public static final int kEventParamMouseWheelDelta = ('m'<<24) + ('w'<<16) + ('d'<<8) + 'l';
	public static final int kEventParamPreviousBounds = ('p'<<24) + ('r'<<16) + ('c'<<8) + 't';
	public static final int kEventParamOriginalBounds = ('o'<<24) + ('r'<<16) + ('c'<<8) + 't';
	public static final int kEventParamRgnHandle =  ('r'<<24) + ('g'<<16) + ('n'<<8) + 'h';
	public static final int kEventParamTextInputSendText = ('t'<<24) + ('s'<<16) + ('t'<<8) + 'x';
	public static final int kEventParamTextInputSendKeyboardEvent = ('t'<<24) + ('s'<<16) + ('k'<<8) + 'e';
	public static final int kEventParamKeyUnicodes= ('k'<<24) + ('u'<<16) + ('n'<<8) + 'i';
	public static final int kEventParamWindowDefPart = ('w'<<24) + ('d'<<16) + ('p'<<8) + 'c';
	public static final int kEventParamWindowMouseLocation = ('w'<<24) + ('m'<<16) + ('o'<<8) + 'u';
	public static final int kEventParamWindowRef = ('w'<<24) + ('i'<<16) + ('n'<<8) + 'd';
	public static final int kEventParamWindowRegionCode   = ('w'<<24) + ('s'<<16) + ('h'<<8) + 'p';
	public static final int kEventProcessCommand = 1;
	public static final int kEventRawKeyDown = 1;
	public static final int kEventRawKeyRepeat = 2;
	public static final int kEventRawKeyUp = 3;
	public static final int kEventRawKeyModifiersChanged = 4;
	public static final int kEventTextInputUnicodeForKeyEvent = 2;
	public static final int kEventWindowActivated = 5;
	public static final int kEventWindowBoundsChanged = 27;
	public static final int kEventWindowClose = 72;
	public static final int kEventWindowCollapsed = 67;
	public static final int kEventWindowDeactivated = 6;
	public static final int kEventWindowDrawContent = 2;
	public static final int kEventWindowExpanded = 70;
	public static final int kEventWindowFocusAcquired = 200;
	public static final int kEventWindowFocusRelinquish = 201;
	public static final int kEventWindowGetRegion = 1002;
	public static final int kEventWindowHidden = 25;
	public static final int kEventWindowHitTest = 1003;
	public static final int kEventWindowShown = 24;
	public static final int kEventWindowUpdate = 1;
	public static final int kFMIterationCompleted = -980;
	public static final int kFloatingWindowClass = 5;
	public static final int kFontFamilyName = 1;
	public static final int kFontNoPlatformCode = -1;
	public static final int kFontNoScriptCode = -1;
	public static final int kFontNoLanguageCode = -1;
	public static final int kFontSelectionQDStyleVersionZero = 0;
	public static final int kFontSelectionQDType = ('q'<<24) + ('s'<<16) + ('t'<<8) + 'l';
	public static final int kHIComboBoxAutoCompletionAttribute = (1 << 0);	
	public static final int kHIComboBoxAutoSizeListAttribute = (1 << 3);
	public static final int kHIComboBoxEditTextPart = 5;
	public static final int kHIComboBoxNumVisibleItemsTag = ('c'<<24) + ('b'<<16) + ('n'<<8) + 'i';
	public static final int kHICommandFromMenu = 1 << 0;
	public static final int kHICommandQuit = ('q'<<24) + ('u'<<16) + ('i'<<8) + 't';
	public static final int kHIViewZOrderAbove = 1;
	public static final int kHIViewZOrderBelow = 2;
	public static final int kHMCFStringContent = ('c'<<24) + ('f'<<16) + ('s'<<8) + 't';
	public static final int kHMAbsoluteCenterAligned = 23;
	public static final int kHMContentProvided = 0;
	public static final int kHMContentNotProvided = -1;
	public static final int kHMContentNotProvidedDontPropagate = -2;
	public static final int kHMDefaultSide = 0;
	public static final int kHMDisposeContent = 1;
	public static final int kHMSupplyContent = 0;
	public static final int kHelpWindowClass = 10;
	public static final int kInvalidFontFamily = -1;
	public static final int kLarge32BitData = ('i'<<24) + ('l'<<16) + ('3'<<8) + '2';	
	public static final int kLarge8BitMask = ('l'<<24) + ('8'<<16) + ('m'<<8) + 'k';
	public static final int kLigaturesType = 1;
	public static final int kQDParseRegionFromTop = (1 << 0);
	public static final int kQDParseRegionFromBottom = (1 << 1);
	public static final int kQDParseRegionFromLeft = (1 << 2);
	public static final int kQDParseRegionFromRight = (1 << 3);
	public static final int kQDParseRegionFromTopLeft = kQDParseRegionFromTop | kQDParseRegionFromLeft;
	public static final int kQDRegionToRectsMsgInit = 1;
	public static final int kQDRegionToRectsMsgParse = 2;
	public static final int kQDRegionToRectsMsgTerminate = 3;
	public static final int kRequiredLigaturesOffSelector = 1;
	public static final int kCommonLigaturesOffSelector = 3;
	public static final int kRareLigaturesOffSelector = 5;
	public static final int kLogosOffSelector = 7;
	public static final int kRebusPicturesOffSelector = 9;
	public static final int kDiphthongLigaturesOffSelector = 11;
	public static final int kSquaredLigaturesOffSelector = 13;
	public static final int kAbbrevSquaredLigaturesOffSelector = 15;
	public static final int kMacHelpVersion = 3;
	public static final int kMenuBlankGlyph = 97;
	public static final int kMenuCapsLockGlyph = 99;
	public static final int kMenuCGImageRefType = 7;
	public static final int kMenuCheckmarkGlyph = 18;
	public static final int kMenuClearGlyph = 28;
	public static final int kMenuCommandGlyph = 17;
	public static final int kMenuContextualMenuGlyph = 109;
	public static final int kMenuControlGlyph = 6;
	public static final int kMenuControlISOGlyph = 138;
	public static final int kMenuControlModifier = 4;
	public static final int kMenuDeleteLeftGlyph = 23;
	public static final int kMenuDeleteRightGlyph = 10;
	public static final int kMenuDiamondGlyph = 19;
	public static final int kMenuDownArrowGlyph = 106;
	public static final int kMenuDownwardArrowDashedGlyph = 16;
	public static final int kMenuEnterGlyph = 4;
	public static final int kMenuEscapeGlyph = 27;
	public static final int kMenuF10Glyph = 120;
	public static final int kMenuF11Glyph = 121;
	public static final int kMenuF12Glyph = 122;
	public static final int kMenuF1Glyph = 111;
	public static final int kMenuF2Glyph = 112;
	public static final int kMenuF3Glyph = 113;
	public static final int kMenuF4Glyph = 114;
	public static final int kMenuF5Glyph = 115;
	public static final int kMenuF6Glyph = 116;
	public static final int kMenuF7Glyph = 117;
	public static final int kMenuF8Glyph = 118;
	public static final int kMenuF9Glyph = 119;
	public static final int kMenuHelpGlyph = 103;
	public static final int kMenuItemAttrCustomDraw = 1 << 11;
	public static final int kMenuItemAttrAutoRepeat = 1 << 9;
	public static final int kMenuItemAttrSeparator = 64;
	public static final int kMenuLeftArrowDashedGlyph = 24;
	public static final int kMenuLeftArrowGlyph = 100;
	public static final int kMenuNoCommandModifier = (1 << 3);
	public static final int kMenuNoIcon = 0;
	public static final int kMenuNoModifiers = 0;
	public static final int kMenuNonmarkingReturnGlyph = 13;
	public static final int kMenuNullGlyph = 0;
	public static final int kMenuOptionGlyph = 7;
	public static final int kMenuOptionModifier = (1 << 1);
	public static final int kMenuPageDownGlyph = 107;
	public static final int kMenuPageUpGlyph = 98;
	public static final int kMenuPencilGlyph = 15;
	public static final int kMenuPowerGlyph = 110;
	public static final int kMenuReturnGlyph = 11;
	public static final int kMenuReturnR2LGlyph = 12;
	public static final int kMenuRightArrowDashedGlyph = 26;
	public static final int kMenuRightArrowGlyph = 101;
	public static final int kMenuShiftGlyph = 5;
	public static final int kMenuShiftModifier = (1 << 0);
	public static final int kMenuTabRightGlyph = 2;
	public static final int kMenuUpArrowDashedGlyph = 25;
	public static final int kMenuUpArrowGlyph = 104;
	public static final int kMouseTrackingMouseDown= 1;
	public static final int kMouseTrackingMouseUp= 2;
	public static final int kMouseTrackingMouseExited  = 3;
	public static final int kMouseTrackingMouseEntered = 4;
	public static final int kMouseTrackingMouseDragged= 5;
	public static final int kMouseTrackingMouseKeyModifiersChanged= 6;
	public static final int kMouseTrackingUserCancelled= 7;
	public static final int kMouseTrackingTimedOut= 8;
	public static final int kMouseTrackingMouseMoved= 9;
	public static final int kModalWindowClass = 3;
	public static final int kMovableModalWindowClass = 4;
	public static final int kNavAllowInvisibleFiles = 0x00000100;
	public static final int kNavAllowMultipleFiles = 0x00000080;
	public static final int kNavAllowOpenPackages = 0x00002000;
	public static final int kNavCBNewLocation = 5;
	public static final int kNavGenericSignature = ('*'<<24) + ('*'<<16) + ('*'<<8) + '*';
	public static final int kNavSupportPackages = 0x00001000;
	public static final int kNavUserActionCancel = 1;
	public static final int kNavUserActionChoose = 4;
	public static final int kNavUserActionOpen = 2;
	public static final int kNavUserActionSaveAs = 3;
	public static final short kOnSystemDisk = -32768;
	public static final int kOverlayWindowClass = 14;
	public static final int kPMCancel = 0x0080;
	public static final int kPMDestinationFax = 3;
	public static final int kPMDestinationFile = 2;
	public static final int kPMDestinationPreview = 4;
	public static final int kPMDestinationPrinter = 1;
	public static final int kPMPrintAllPages = 2147483647;
	public static final int kQDUseCGTextMetrics = (1 << 2);
	public static final int kQDUseCGTextRendering = (1 << 1);
	public static final int kScrapFlavorTypeUnicode = ('u'<<24) + ('t'<<16) + ('x'<<8) + 't';
	public static final int kScrapFlavorTypeText = ('T'<<24) + ('E'<<16) + ('X'<<8) + 'T';
	public static final boolean kScrollBarsSyncAlwaysActive = true;
	public static final boolean kScrollBarsSyncWithFocus = false;
	public static final int kSelectorAlLAvailableData = 0xFFFFFFFF;
	public static final int kSetFrontProcessFrontWindowOnly = 1 << 0;
	public static final int kSheetWindowClass = 11;
	public static final int kStdCFStringAlertVersionOne = 1;
	public static final int kSystemIconsCreator = ('m'<<24) + ('a'<<16) + ('c'<<8) + 's';
	public static final int kSymbolLigaturesOffSelector = 17;
	public static final int kControlSliderDoesNotPoint = 2;
	public static final int kTXNAlwaysWrapAtViewEdgeMask = 1 << 11;
	public static final int kTXNBackgroundTypeRGB = 1;
	public static final int kTXNDefaultFontSize = 0x000C0000;
	public static final int kTXNDefaultFontStyle = 0;
	public static final int kTXNDefaultFontName = 0;
	public static final int kTXNDisableDragAndDropTag = ('d'<<24) + ('r'<<16) + ('a'<<8) + 'g';
	public static final int kTXNDoFontSubstitution = ('f'<<24) + ('s'<<16) + ('u'<<8) + 'b';
	public static final int kTXNDontDrawCaretWhenInactiveMask = 1 << 12;
	public static final int kTXNDrawCaretWhenInactiveTag = ('d'<<24)+('c'<<16)+('r'<<8)+'t';
	public static final int kTXNEndOffset = 2147483647;
	public static final int kTXNIOPrivilegesTag = ('i'<<24) + ('o'<<16) + ('p'<<8) + 'v';
	public static final int kTXNMarginsTag = ('m'<<24) + ('a'<<16) + ('r'<<8) + 'g';
	public static final int kTXNMonostyledTextMask = 1 << 17;
	public static final int kTXNQDFontFamilyIDAttribute = ('f'<<24) + ('o'<<16) + ('n'<<8) + 't';
	public static final int kTXNQDFontSizeAttribute = ('s'<<24) + ('i'<<16) + ('z'<<8) + 'e';
	public static final int kTXNQDFontStyleAttribute = ('f'<<24) + ('a'<<16) + ('c'<<8) + 'e';
	public static final int kTXNQDFontColorAttribute = ('k'<<24) + ('l'<<16) + ('o'<<8) + 'r';
	public static final int kTXNQDFontFamilyIDAttributeSize = 2;
	public static final int kTXNQDFontSizeAttributeSize = 2;
	public static final int kTXNQDFontStyleAttributeSize = 2;
	public static final int kTXNQDFontColorAttributeSize = 6;
	public static final int kTXNReadOnlyMask = 1 << 5;
	public static final int kTXNSingleLineOnlyMask = 1 << 14;
	public static final int kTXNStartOffset = 0;
	public static final int kTXNSystemDefaultEncoding = 0;
	public static final int kTXNTextEditStyleFrameType = 1;
	public static final int kTXNUnicodeTextData = ('u'<<24) + ('t'<<16) + ('x'<<8) + 't';
	public static final int kTXNUnicodeTextFile = ('u'<<24) + ('t'<<16) + ('x'<<8) + 't';
	public static final int kTXNUseCurrentSelection = -1;
	public static final int kTXNVisibilityTag = ('v'<<24) + ('i'<<16) + ('s'<<8) + 'b';
	public static final int kTXNWantHScrollBarMask = 1 << 2;
	public static final int kTXNWantVScrollBarMask = 1 << 3;
	public static final int kTextEncodingMacRoman = 0;
	public static final int kTextLanguageDontCare = -128;
	public static final int kTextRegionDontCare = -128;
	public static final int kThemeAdornmentDefault = 1 << 0;
	public static final int kThemeAliasArrowCursor = 2;
	public static final int kThemeArrowButton = 4;
	public static final int kThemeArrowCursor = 0;
	public static final int kThemeArrowDown = 1;
	public static final int kThemeArrow5pt = 1;
	public static final int kThemeBrushDialogBackgroundActive = 1;
	public static final int kThemeBrushDocumentWindowBackground = 15;
	public static final int kThemeBrushPrimaryHighlightColor = -3;
	public static final int kThemeBrushSecondaryHighlightColor = -4;
	public static final int kThemeBrushButtonFaceActive = 29;
	public static final int kThemeBrushFocusHighlight = 19;
	public static final int kThemeBrushListViewBackground = 10; 
	public static final int kThemeButtonOff = 0;
	public static final int kThemeButtonOn = 1;
	public static final int kThemeButtonMixed = 2;
	public static final int kThemeCheckBox = 1;
	public static final int kThemeCopyArrowCursor = 1;
	public static final int kThemeCrossCursor = 5;
	public static final int kThemeCurrentPortFont = 200;
	public static final int kThemeDisclosureButton = 6;
	public static final int kThemeDisclosureRight = 0;
	public static final int kThemeDisclosureDown = 1;
	public static final int kThemeDisclosureLeft = 2;
	public static final int kThemeEmphasizedSystemFont = 4;
	public static final int kThemeIBeamCursor = 4;
	public static final int kThemeMenuItemCmdKeyFont = 103;
	public static final int kThemeMenuItemFont = 101;
	public static final int kThemeMenuItemHierarchical = 1;
	public static final int kThemeMetricDisclosureButtonWidth = 22;
	public static final int kThemeMetricDisclosureTriangleHeight = 25;
	public static final int kThemeMetricCheckBoxWidth = 50;
	public static final int kThemeMetricComboBoxLargeDisclosureWidth = 74;
	public static final int kThemeMetricRadioButtonWidth = 52;
	public static final int kThemeMetricEditTextFrameOutset = 5;
	public static final int kThemeMetricEditTextWhitespace = 4;
	public static final int kThemeMetricFocusRectOutset = 7;
	public static final int kThemeMetricHSliderHeight = 41;
	public static final int kThemeMetricLittleArrowsHeight = 27;
	public static final int kThemeMetricLittleArrowsWidth = 28;
	public static final int kThemeMetricMenuTextTrailingEdgeMargin = 67;
	public static final int kThemeMetricMenuIconTrailingEdgeMargin = 69;
	public static final int kThemeMetricNormalProgressBarThickness = 58;
	public static final int kThemeMetricPushButtonHeight = 19;
	public static final int kThemeMetricScrollBarWidth = 0;
	public static final int kThemeMetricVSliderWidth = 45;
	public static final int kThemeNotAllowedCursor = 18;
	public static final int kThemePointingHandCursor = 10;
	public static final int kThemePushButton = 0;
	public static final int kThemePushButtonFont = 105;
	public static final int kThemeRadioButton = 2;
	public static final int kThemeResizeLeftRightCursor = 17;
	public static final int kThemeResizeLeftCursor = 15;
	public static final int kThemeResizeRightCursor = 16;
	public static final int kThemeRoundedBevelButton = 15;
	public static final int kThemeSmallBevelButton = 8;
	public static final int kThemeSmallEmphasizedSystemFont = 2;
	public static final int kThemeSmallSystemFont = 1;
	public static final int kThemeSpinningCursor = 14;
	public static final int kThemeStateActive = 1;
	public static final int kThemeStateInactive = 0;
	public static final int kThemeStatePressed = 2;
	public static final int kThemeSystemFont = 0;
	public static final int kThemeTextColorDialogActive = 1;
	public static final int kThemeTextColorDocumentWindowTitleActive = 23;
	public static final int kThemeTextColorDocumentWindowTitleInactive = 24;
	public static final int kThemeTextColorListView = 22;
	public static final int kThemeTextColorPushButtonActive = 12;
	public static final int kThemeToolbarFont = 108;
	public static final int kThemeViewsFont = 3;
	public static final int kThemeWatchCursor = 7;
	public static final int kTrackMouseLocationOptionDontConsumeMouseUp = 1;
	public static final int kTransformSelected = 0x4000;
	public static final int kUtilityWindowClass = 8;
    public static final int kWindowActivationScopeNone = 0;
    public static final int kWindowActivationScopeIndependent = 1;
    public static final int kWindowActivationScopeAll = 2;
	public static final int kWindowAlertPositionParentWindowScreen = 0x700A;
    public static final int kWindowBoundsChangeOriginChanged = 1<<3;
    public static final int kWindowBoundsChangeSizeChanged = 1<<2;
    public static final int kWindowCascadeOnMainScreen = 4;
	public static final int kWindowCloseBoxAttribute = (1 << 0);
	public static final int kWindowCollapseBoxAttribute = (1 << 3);
	public static final int kWindowCompositingAttribute = (1 << 19);
	public static final int kWindowContentRgn = 33;
	public static final int kWindowGroupAttrHideOnCollapse = 16;
	public static final int kWindowHorizontalZoomAttribute = 1 << 1;
	public static final int kWindowVerticalZoomAttribute  = 1 << 2;
	public static final int kWindowFullZoomAttribute = (OS.kWindowVerticalZoomAttribute | OS.kWindowHorizontalZoomAttribute);
	public static final int kWindowLiveResizeAttribute = (1 << 28);
	public static final int kWindowModalityAppModal = 2;
	public static final int kWindowModalityNone = 0;
	public static final int kWindowModalitySystemModal = 1;
	public static final int kWindowModalityWindowModal = 3;
	public static final int kWindowNoShadowAttribute = (1 << 21);
	public static final int kWindowResizableAttribute = (1 << 4);
	public static final int kWindowStandardHandlerAttribute = (1 << 25);
	public static final int kWindowStructureRgn = 32;
	public static final int kWindowUpdateRgn= 34;
	public static final int mouseDown = 1;
	public static final int noErr = 0;
	public static final int normal = 0;
	public static final int optionKey = 1 << 11;
	public static final int osEvt = 15;
	public static final int paramErr = -50;
	public static final int shiftKey = 1 << 9;
	public static final int smKCHRCache = 38;	
	public static final int smKeyScript = 22;
	public static final int smRegionCode = 40;
	public static final int smSystemScript = -1;
	public static final int srcCopy = 0;
	public static final int srcOr = 1;
	public static final int srcXor = 2;
	public static final int notSrcXor = 6;
	public static final int teFlushDefault = 0;
	public static final int teCenter = 1;
	public static final int teFlushRight = -1;
	public static final int teFlushLeft = -2;
	public static final int typeCGContextRef= ('c'<<24) + ('n'<<16) + ('t'<<8) + 'x';
	public static final int typeChar = ('T'<<24) + ('E'<<16) + ('X'<<8) + 'T';
	public static final int typeControlPartCode = ('c'<<24) + ('p'<<16) + ('r'<<8) + 't';
	public static final int typeControlRef = ('c'<<24) + ('t'<<16) + ('r'<<8) + 'l';
	public static final int typeEventRef = ('e'<<24) + ('v'<<16) + ('r'<<8) + 'f';
	public static final int typeFileURL= ('f'<<24) + ('u'<<16) + ('r'<<8) + 'l';	
	public static final int typeFSRef = ('f'<<24) + ('s'<<16) + ('r'<<8) + 'f';
	public static final int typeHICommand = ('h'<<24) + ('c'<<16) + ('m'<<8) + 'd';
	public static final int typeHIPoint = ('h'<<24) + ('i'<<16) + ('p'<<8) + 't';
	public static final int typeMenuCommand = ('m'<<24) + ('c'<<16) + ('m'<<8) + 'd';
	public static final int typeMenuItemIndex = ('m'<<24) + ('i'<<16) + ('d'<<8) + 'x';        
	public static final int typeMenuRef = ('m'<<24) + ('e'<<16) + ('n'<<8) + 'u';
	public static final int typeMouseButton = ('m'<<24) + ('b'<<16) + ('t'<<8) + 'n';
	public static final int typeMouseWheelAxis = ('m'<<24) + ('w'<<16) + ('a'<<8) + 'x';
	public static final int typeQDPoint = ('Q'<<24) + ('D'<<16) + ('p'<<8) + 't';
	public static final int typeQDRectangle = ('q'<<24) + ('d'<<16) + ('r'<<8) + 't';
	public static final int typeQDRgnHandle = ('r'<<24) + ('g'<<16) + ('n'<<8) + 'h';
	public static final int typeRGBColor = ('c'<<24) + ('R'<<16) + ('G'<<8) + 'B';
	public static final int typeSInt16 = ('s'<<24) + ('h'<<16) + ('o'<<8) + 'r';
	public static final int typeSInt32 = ('l'<<24) + ('o'<<16) + ('n'<<8) + 'g';
	public static final int typeType = ('t'<<24) + ('y'<<16) + ('p'<<8) + 'e';
	public static final int typeUInt32 = ('m'<<24) + ('a'<<16) + ('g'<<8) + 'n';
	public static final int typeUnicodeText = ('u'<<24) + ('t'<<16) + ('x'<<8) + 't';
	public static final int typeWindowDefPartCode = ('w'<<24) + ('d'<<16) + ('p'<<8) + 't';
	public static final int typeWindowRef = ('w'<<24) + ('i'<<16) + ('n'<<8) + 'd';
	public static final int typeWindowRegionCode = ('w'<<24) + ('s'<<16) + ('h'<<8) + 'p';
	public static final int updateEvt = 6;
	public static final int updateMask = 1 << updateEvt;
	public static final int userCanceledErr = -128;
	public static final short wInContent = 1;
	public static final short wNoHit = 0;

/** Natives */
public static final native int kHIViewWindowContentID();
public static final native int kPMDocumentFormatPDF();
public static final native int kPMGraphicsContextCoreGraphics();
public static final native int ActiveNonFloatingWindow();
public static final native int AECountItems(AEDesc theAEDescList, int[] theCount);
public static final native int AEGetNthPtr(AEDesc theAEDescList, int index, int desiredType, int[] theAEKeyword, int[] typeCode, int dataPtr, int maximumSize, int[] actualSize);
public static final native int AEProcessAppleEvent(EventRecord theEventRecord);
public static final native int ATSFontGetPostScriptName(int iFont, int iOptions, int[] oName); 
public static final native int ATSUBatchBreakLines(int iTextLayout, int iRangeStart, int iRangeLength, int iLineWidth, int[] oBreakCount);
public static final native int ATSUCreateStyle(int[] oStyle);
public static final native int ATSUCreateTextLayout(int[] oTextLayout);
public static final native int ATSUCreateTextLayoutWithTextPtr(int iText, int iTextOffset, int iTextLength, int iTextTotalLength, int iNumberOfRuns, int[] iRunLengths, int[] iStyles, int[] oTextLayout);
public static final native int ATSUDirectGetLayoutDataArrayPtrFromTextLayout(int iTextLayout, int iLineOffset, int iDataSelector, int[] oLayoutDataArrayPtr, int[] oLayoutDataCount);
public static final native int ATSUDirectReleaseLayoutDataArrayPtr(int iLineRef, int iDataSelector, int iLayoutDataArrayPtr);
public static final native int ATSUDisposeStyle(int iStyle);
public static final native int ATSUDisposeTextLayout(int iTextLayout);
public static final native int ATSUDrawText(int iTextLayout, int iLineOffset, int iLineLength, int iLocationX, int iLocationY);
public static final native int ATSUFindFontFromName(byte[] iName, int iNameLength, int iFontNameCode, int iFontNamePlatform, int iFontNameScript, int iFontNameLanguage, int[] oFontID);
public static final native int ATSUFindFontName(int iFontID, int iFontNameCode, int iFontNamePlatform, int iFontNameScript, int iFontNameLanguage, int iMaximumNameLength, byte[] oName, int[] oActualNameLength, int[] oFontNameIndex);
public static final native int ATSUGetFontIDs(int[] oFontIDs, int iArraySize, int[] oFontCount);
public static final native int ATSUGetGlyphBounds(int iTextLayout, int iTextBasePointX, int iTextBasePointY, int iBoundsCharStart, int iBoundsCharLength, short iTypeOfBounds, int iMaxNumberOfBounds, int oGlyphBounds, int[] oActualNumberOfBounds);
public static final native int ATSUGetGlyphBounds(int iTextLayout, int iTextBasePointX, int iTextBasePointY, int iBoundsCharStart, int iBoundsCharLength, short iTypeOfBounds, int iMaxNumberOfBounds, ATSTrapezoid oGlyphBounds, int[] oActualNumberOfBounds);
public static final native int ATSUGetLayoutControl(int iTextLayout, int iTag, int iExpectedValueSize, int[] oValue, int[] oActualValueSize);
public static final native int ATSUGetLineControl(int iTextLayout, int iLineStart, int iTag, int iExpectedValueSize, int[] oValue, int[] oActualValueSize);
public static final native int ATSUGlyphGetQuadraticPaths(int iATSUStyle, short iGlyphID, int iNewPathProc, int iLineProc, int iCurveProc, int iClosePathProc, int iCallbackDataPtr, int[] oCallbackResult);
public static final native int ATSUGetSoftLineBreaks(int iTextLayout, int iRangeStart, int iRangeLength, int iMaximumBreaks, int[] oBreaks, int[] oBreakCount);
public static final native int ATSUGetTextHighlight (int iTextLayout, int iTextBasePointX, int iTextBasePointY, int iHighlightStart, int iHighlightLength, int oHighlightRegion);
public static final native int ATSUGetUnjustifiedBounds(int iTextLayout, int iLineStart, int iLineLength,  int[] oTextBefore, int[] oTextAfter, int[] oAscent, int[] oDescent);
public static final native int ATSUHighlightText(int iTextLayout, int iTextBasePointX, int iTextBasePointY, int iHighlightStart, int iHighlightLength);
public static final native int ATSUNextCursorPosition(int iTextLayout, int iOldOffset, int iMovementType, int[] oNewOffset);
public static final native int ATSUOffsetToPosition(int iTextLayout, int iOffset, boolean iIsLeading, ATSUCaret oMainCaret, ATSUCaret oSecondCaret, boolean[] oCaretIsSplit);
public static final native int ATSUPositionToOffset(int iTextLayout, int iLocationX, int iLocationY, int[] ioPrimaryOffset,  boolean[] oIsLeading,  int[] oSecondaryOffset);
public static final native int ATSUPreviousCursorPosition(int iTextLayout, int iOldOffset, int iMovementType,  int[] oNewOffset);
public static final native int ATSUSetAttributes(int iStyle, int iAttributeCount, int[] iTag, int[] iValueSize, int[] iValue); 
public static final native int ATSUSetFontFeatures(int iStyle, int iFeatureCount,  short[] iType, short[] iSelector);
public static final native int ATSUSetHighlightingMethod(int iTextLayout, int iMethod, ATSUUnhighlightData iUnhighlightData);
public static final native int ATSUSetLayoutControls(int iTextLayout, int iAttributeCount, int[] iTag, int[] iValueSize, int[] iValue);
public static final native int ATSUSetLineControls(int iTextLayout, int iLineStart, int iAttributeCount, int[] iTag, int[] iValueSize, int[] iValue);
public static final native int ATSUSetRunStyle(int iTextLayout, int iStyle, int iRunStart, int iRunLength);
public static final native int ATSUSetSoftLineBreak(int iTextLayout, int iLineBreak);
public static final native int ATSUSetTabArray(int iTextLayout, int iTabs, int iTabCount);
public static final native int ATSUSetTextPointerLocation(int iTextLayout, int iText, int iTextOffset, int iTextLength, int iTextTotalLength);
public static final native int ATSUSetTransientFontMatching(int iTextLayout, boolean iTransientFontMatching);
public static final native int ATSUTextInserted(int iTextLayout, int iInsertionLocation, int iInsertionLength);
public static final native int ATSUTextDeleted(int iTextLayout, int iInsertionLocation, int iInsertionLength);
public static final native int AddDataBrowserItems(int cHandle, int containerID, int numItems, int[] itemIDs, int preSortProperty);
public static final native int AddDataBrowserListViewColumn(int browser, DataBrowserListViewColumnDesc columnDesc, int position);
public static final native int AddDragItemFlavor(int theDrag, int theItemRef, int theType, byte[] dataPtr, int dataSize, int theFlags);  
public static final native int AppendMenuItemTextWithCFString(int mHandle, int sHandle, int attributes, int commandID, short[] outItemIndex);
public static final native int AutoSizeDataBrowserListViewColumns(int cHandle);
public static final native void BeginUpdate(int wHandle);
public static final native void BringToFront(int wHandle);
public static final native void CFRelease(int sHandle);
public static final native void CFArrayAppendValue(int theArray, int value);
public static final native int CFArrayCreateMutable(int allocator, int capacity, int callBacks);
public static final native int CFArrayGetCount(int theArray); 
public static final native int CFArrayGetValueAtIndex(int theArray, int idx); 
public static final native int CFStringCreateWithBytes(int alloc, byte[] bytes, int numBytes, int encoding, boolean isExternalRepresentation);
public static final native int CFStringCreateWithCharacters(int alloc, char[] chars, int numChars);
public static final native int CFStringGetBytes(int theString, CFRange range, int encoding, byte lossByte, boolean isExternalRepresentation, byte[] buffer, int maxBufLen, int[] usedBufLen);
public static final native void CFStringGetCharacters(int theString, CFRange range, char[] buffer);
public static final native int CFStringGetLength(int theString);
public static final native int CFStringGetSystemEncoding();
public static final native int CFURLCopyFileSystemPath(int anURL, int pathStyle);
public static final native int CFURLCopyLastPathComponent(int url);
public static final native int CFURLCreateCopyAppendingPathComponent(int allocator, int url, int pathComponent, boolean isDirectory);
public static final native int CFURLCreateCopyDeletingLastPathComponent(int allocator, int url);
public static final native int CFURLCreateFromFSRef(int allocator, byte[] fsRef);
public static final native int CFURLCreateWithFileSystemPath (int allocator, int filePath, int pathStyle, boolean isDirectory); 
public static final native boolean CFURLGetFSRef(int url, byte[] fsRef);
public static final native void CGAffineTransformConcat (float[] t1, float[] t2, float[] result);
public static final native void CGAffineTransformMake (float a, float b, float c, float d, float tx, float ty, float[] result);
public static final native void CGAffineTransformTranslate (float[] t, float tx, float ty, float[] result);
public static final native void CGAffineTransformRotate (float[] t, float angle, float[] result);
public static final native void CGAffineTransformScale (float[] t, float sx, float sy, float[] result);
public static final native void CGAffineTransformInvert (float[] t, float[] result);
public static final native void CGContextScaleCTM(int inContext, float sx, float sy);
public static final native void CGContextTranslateCTM(int inContext, float tx, float ty);
public static final native int CGBitmapContextCreate(int data, int width, int height, int bitsPerComponent, int bytesPerRow, int colorspace, int alphaInfo);
public static final native int CGColorSpaceCreateDeviceRGB ();
public static final native void CGColorSpaceRelease (int cs);
public static final native void CGContextAddArc (int ctx, float x, float y, float radius, float startAngle, float endAngle, boolean clockwise);
public static final native void CGContextAddArcToPoint (int ctx, float x1, float y1, float x2, float y2, float radius);
public static final native void CGContextAddLineToPoint (int ctx, float x, float y);
public static final native void CGContextAddLines (int ctx, float[] points, int count);
public static final native void CGContextAddPath (int context, int path);
public static final native void CGContextBeginPath (int ctx);
public static final native void CGContextClip (int ctx);
public static final native void CGContextClearRect (int ctx, CGRect rect);
public static final native void CGContextClosePath (int ctx);
public static final native void CGContextConcatCTM (int context, float[] transform);
public static final native void CGContextDrawImage (int ctx, CGRect rect, int image);
public static final native void CGContextEOClip (int ctx);
public static final native void CGContextEOFillPath (int ctx);
public static final native void CGContextFillPath (int ctx);
public static final native void CGContextStrokeRect (int ctx, CGRect rect);
public static final native void CGContextFillRect (int ctx, CGRect rect);
public static final native void CGContextFlush (int ctx);
public static final native int CGContextGetInterpolationQuality (int context	);
public static final native void CGContextGetTextPosition (int ctx, CGPoint point);
public static final native void CGContextMoveToPoint (int ctx, float x, float y);
public static final native void CGContextRelease(int ctx);
public static final native void CGContextRestoreGState(int ctx);
public static final native void CGContextSaveGState(int ctx);
public static final native void CGContextSelectFont (int ctx, byte[] name, float size, int textEncoding);
public static final native void CGContextSetFillColorSpace (int ctx, int colorspace);
public static final native void CGContextSetAlpha (int context, float alpha);
public static final native void CGContextSetFillColor (int ctx, float[] value);
public static final native void CGContextSetFont (int ctx, int font);
public static final native void CGContextSetFontSize (int ctx, float size);
public static final native void CGContextSetInterpolationQuality (int context, int quality);
public static final native void CGContextSetLineCap (int context, int cap); 
public static final native void CGContextSetLineDash (int ctx, float phase, float[] lengths, int count);
public static final native void CGContextSetLineJoin (int context, int join); 
public static final native void CGContextSetLineWidth (int ctx, float width);
public static final native void CGContextSetShouldAntialias (int ctx, boolean shouldAntialias);
public static final native void CGContextSetShouldSmoothFonts (int ctx, boolean shouldSmooth);
public static final native void CGContextSetStrokeColorSpace (int ctx, int colorspace);
public static final native void CGContextSetStrokeColor (int ctx, float[] value);
public static final native void CGContextSetRenderingIntent (int context, int intent);
public static final native void CGContextSetRGBFillColor (int ctx, float r, float g, float b, float alpha);
public static final native void CGContextSetRGBStrokeColor (int ctx, float r, float g, float b, float alpha);
public static final native void CGContextSetTextDrawingMode (int ctx, int mode);
public static final native void CGContextSetTextPosition (int ctx, float x, float y);
public static final native void CGContextShowText (int ctx, byte[] cstring, int length);
public static final native void CGContextShowTextAtPoint (int ctx, float x, float y, byte[] cstring, int length);
public static final native void CGContextSetTextMatrix (int ctx, float[] transform);
public static final native void CGContextStrokePath (int ctx);
public static final native void CGContextSynchronize (int ctx);
public static final native int CGDataProviderCreateWithData (int info, int data, int size, int releaseData);
public static final native void CGDataProviderRelease (int provider);
public static final native int CGDisplayBaseAddress (int display);
public static final native int CGDisplayBitsPerPixel (int display);
public static final native int CGDisplayBitsPerSample (int display);
public static final native int CGDisplayBytesPerRow (int display);
public static final native int CGDisplayPixelsHigh (int display);
public static final native int CGDisplayPixelsWide (int display);
public static final native int CGFontCreateWithPlatformFont (int[] platformFontReference);
public static final native void CGFontRelease (int font);
public static final native int CGGetDisplaysWithRect (CGRect rect, int maxDisplays, int[] dspys, int[] dspyCnt);
public static final native int CGImageCreate (int width, int height, int bitsPerComponent, int bitsPerPixel, int bytesPerRow, int colorspace, int alphaInfo, int provider, float[] decode, boolean shouldInterpolate, int intent);
public static final native int CGImageGetAlphaInfo (int image);
public static final native int CGImageGetBitsPerComponent (int image);
public static final native int CGImageGetBitsPerPixel (int image);
public static final native int CGImageGetBytesPerRow (int image);
public static final native int CGImageGetColorSpace (int image);
public static final native int CGImageGetHeight (int image);
public static final native int CGImageGetWidth (int image);
public static final native void CGImageRelease (int image);
public static final native void CGPathAddArc (int path, float[] m, float x, float y, float r, float startAngle, float endAngle, boolean clockwise);
public static final native void CGPathAddCurveToPoint (int path, float[] m, float cx1, float cy1, float cx2, float cy2, float x, float y);
public static final native void CGPathAddLineToPoint (int path, float[] m, float x, float y);
public static final native void CGPathAddPath (int path1, float[] m, int path2);
public static final native void CGPathAddQuadCurveToPoint (int path, float[] m, float cx, float cy, float x, float y);
public static final native void CGPathAddRect (int path, float[] m, CGRect rect);
public static final native void CGPathCloseSubpath (int path);
public static final native int CGPathCreateMutable ();
public static final native void CGPathGetBoundingBox (int path, CGRect rect);
public static final native void CGPathGetCurrentPoint (int path, CGPoint point);
public static final native boolean CGPathIsEmpty (int path);
public static final native void CGPathMoveToPoint (int path, float[] m, float x, float y);
public static final native void CGPathRelease (int path);
public static final native void CGPointApplyAffineTransform (CGPoint point, float[] t, CGPoint result);
public static final native int CGPostMouseEvent(CGPoint mouseCursorPosition, boolean updateMouseCursorPosition, int buttonCount, boolean mouseButtonDown, boolean mouseButtonDown2, boolean mouseButtonDown3);
public static final native int CGPostKeyboardEvent(int keyChar, int virtualKey, boolean keyDown);
public static final native int CGWarpMouseCursorPosition (CGPoint newCursorPosition);
public static final native int CPSEnableForegroundOperation(int[] psn, int arg2, int arg3, int arg4, int arg5);
public static final native int CPSSetProcessName(int[] psn, byte[] name);
public static final native int CallNextEventHandler(int nextHandler, int eventRefHandle);
public static final native short CharWidth(short c);
public static final native int ClearCurrentScrap();
public static final native int ClearKeyboardFocus(int inWindow);
public static final native void ClearMenuBar();
public static final native int ClipCGContextToRegion(int inContext, Rect portRect, int rgnHandle);
public static final native int CloseDataBrowserContainer(int cHandle, int container);
public static final native void ClosePoly();
public static final native void CloseRgn(int dstRgn);
public static final native int CollapseWindow(int wHandle, boolean collapse);
public static final native boolean ConvertEventRefToEventRecord(int inEvent, EventRecord outEvent);
public static final native int ConvertFromPStringToUnicode(int iTextToUnicodeInfo, byte[] iPascalStr, int iOutputBufLen, int[] oUnicodeLen, char[] oUnicodeStr);
public static final native int ConvertFromUnicodeToPString (int iUnicodeToTextInfo, int iUnicodeLen, char[] iUnicodeStr, byte[] oPascalStr); 
public static final native void CopyBits(int srcPixMapHandle, int dstPixMapHandle, Rect srcRect, Rect dstRect, short mode, int maskRgn);
public static final native int CopyControlTitleAsCFString(int cHandle, int[] sHandle);
public static final native void CopyDeepMask(int srcPixMapHandle, int maskPixMapHandle, int dstPixMapHandle, Rect srcRect, Rect maskRect, Rect dstRect, short mode, int maskRgn);
public static final native int CopyMenuItemTextAsCFString(int mHandle, short index, int[] sHandle);
public static final native void CopyRgn(int srcRgnHandle, int dstRgnHandle);
public static final native int CountDragItems(int theDrag, short[] numItems);
public static final native int CountDragItemFlavors(int theDrag, int theItemRef, short[] numFlavors);
public static final native short CountMenuItems(int mHandle);
public static final native int CountSubControls(int cHandle, short[] count);
public static final native int CreateBevelButtonControl(int window, Rect boundsRect, int title, short thickness, short behavior, int info, short menuID, short menuBehavior, short menuPlacement, int[] outControl);
public static final native int CreateCheckBoxControl(int window, Rect boundsRect, int title, int initialValue, boolean autoToggle, int[] outControl);
public static final native int CreateCGContextForPort(int inPort, int[] outContext);
public static final native int CreateDataBrowserControl(int window, Rect boundsRect, int style,int[] outControl);
public static final native int CreateEvent(int allocator, int inClassID, int kind, double when, int flags, int[] outEventRef);
public static final native int CreateGroupBoxControl(int window, Rect boundsRect, int title, boolean primary, int[] outControl);
public static final native int CreateIconControl(int window, Rect boundsRect, ControlButtonContentInfo icon, boolean dontTrack, int[] outControl);
public static final native int CreateLittleArrowsControl(int window, Rect boundsRect, int value, int minimum, int maximum, int increment, int[] outControl);
public static final native int CreateNewMenu(short menuID, int menuAttributes, int[] outMenuRef);
public static final native int CreateNewWindow(int windowClass, int attributes, Rect bounds, int[] wHandle);
public static final native int CreatePopupArrowControl(int window, Rect boundsRect, short orientation, short size, int[] outControl);
public static final native int CreatePopupButtonControl(int window, Rect boundsRect, int title, short menuID, boolean variableWidth, short titleWidth, short titleJustification, int titleStyle, int[] outControl);
public static final native int CreateProgressBarControl(int window, Rect boundsRect, int value, int minimim, int maximum, boolean indeterminate, int [] outControl);
public static final native int CreatePushButtonControl(int window, Rect boundsRect, int title, int[] outControl);
public static final native int CreatePushButtonWithIconControl(int window, Rect boundsRect, int title, ControlButtonContentInfo icon, short iconAlignment, int[] outControl);
public static final native int CreateRadioButtonControl(int window, Rect boundsRect, int title, int initialValue, boolean autoToggle, int[] outControl);
public static final native int CreateRootControl(int windowHandle, int[] cHandle);
public static final native int CreateSliderControl(int window, Rect boundsRect, int value, int minimum, int maximum, int orientation, short numTickMarks, boolean liveTracking, int liveTrackingProc, int [] outControl);
public static final native int CreateScrollBarControl(int window, Rect boundsRect, int value, int minimum, int maximum, int viewSize, boolean liveTracking, int liveTrackingProc, int [] outControl);
public static final native int CreateSeparatorControl(int window, Rect boundsRect, int [] outControl);
public static final native int CreateStandardAlert(short alertType, int errorSHandle, int explanationSHandle, AlertStdCFStringAlertParamRec alertParamHandle, int[] dialogHandle);
public static final native int CreateStaticTextControl(int window, Rect boundsRect, int text, ControlFontStyleRec style, int [] outControl);    
public static final native int CreateTabsControl(int window, Rect boundsRect, short size, short direction, short numTabs, int tabArray, int[] outControl);
public static final native int CreateTextToUnicodeInfoByEncoding(int iEncoding, int[] oTextToUnicodeInfo);
public static final native int CreateUnicodeToTextInfoByEncoding (int iEncoding, int[] oUnicodeToTextInfo);
public static final native int CreateEditUnicodeTextControl(int window, Rect boundsRect, int text, boolean isPassword, ControlFontStyleRec style, int [] outControl);
public static final native int CreateUserPaneControl(int window, Rect boundsRect, int features, int [] outControl);
public static final native int CreateWindowGroup (int inAttributes, int [] outGroup);
public static final native void DeleteMenu(short menuID);
public static final native void DeleteMenuItem(int mHandle, short index);
public static final native int DeleteMenuItems(int mHandle, short firstItem, int numItems);
public static final native void DiffRgn(int srcRgnA, int srcRgnB, int dstRgn);
public static final native int DisableControl(int cHandle);
public static final native void DisableMenuCommand(int mHandle, int commandId);
public static final native void DisableMenuItem(int mHandle, short index);
public static final native void DisposeControl(int cHandle);
public static final native int DisposeDrag(int theDrag);
public static final native void DisposeGWorld(int offscreenGWorld);
public static final native void DisposeHandle(int handle);
public static final native void DisposeMenu(int mHandle);
public static final native void DisposePtr(int ptr);
public static final native void DisposeRgn(int rgnHandle);
public static final native int DisposeTextToUnicodeInfo(int[] ioTextToUnicodeInfo);
public static final native int DisposeUnicodeToTextInfo(int[] ioUnicodeToTextInfo);
public static final native void DisposeWindow(int wHandle);
public static final native int DMGetNextScreenDevice(int theDevice, boolean activeOnly);
public static final native int DMGetFirstScreenDevice(boolean activeOnly);
public static final native void DrawControlInCurrentPort(int inControl);
public static final native void DrawMenuBar();
public static final native void DrawText(byte[] textBuf, short firstByte, short byteCount);
public static final native int DrawThemeButton(Rect inBounds, short inKind, ThemeButtonDrawInfo inNewInfo, ThemeButtonDrawInfo inPrevInfo, int inEraseProc, int inLabelProc, int inUserData);
public static final native int DrawThemeEditTextFrame(Rect bounds, int state);
public static final native int DrawThemeFocusRect(Rect bounds, boolean hasFocus);
public static final native int DrawThemePopupArrow(Rect bounds,short orientation, short size, int state, int eraseProc, int eraseData); 
public static final native int DrawThemeSeparator(Rect bounds, int state);
public static final native int DrawThemeTextBox(int sHandle, short fontID, int state, boolean wrapToWidth, Rect bounds, short just, int context);
public static final native int EmbedControl(int inControl, int inContainer);
public static final native boolean EmptyRect(Rect r);
public static final native boolean EmptyRgn(int rgnHandle);
public static final native int EnableControl(int cHandle);
public static final native void EnableMenuCommand(int mHandle, int commandId);
public static final native void EnableMenuItem(int mHandle, short index);
public static final native void EndUpdate(int wHandle);
public static final native boolean EqualRect(Rect rect1, Rect rect2);
public static final native void EraseRect(Rect bounds);
public static final native void EraseRgn(int rgnHandle);
public static final native int FetchFontInfo(short fontID, short fontSize, short fontStyle, FontInfo info); 
public static final native int Fix2Long(int x);
public static final native double Fix2X(int x);
public static final native int FMCreateFontFamilyInstanceIterator(short iFontFamily, int ioIterator);
public static final native int FMCreateFontFamilyIterator(int iFilter, int iRefCon, int iOptions, int ioIterator);
public static final native int FMDisposeFontFamilyIterator(int ioIterator);
public static final native int FMDisposeFontFamilyInstanceIterator(int ioIterator);
public static final native int FMGetATSFontRefFromFont(int iFont);
public static final native int FMGetFontFamilyName(short id, byte[] name);
public static final native short FMGetFontFamilyFromName(byte[] name);
public static final native int FMGetFontFamilyInstanceFromFont(int iFont, short[] oFontFamily, short[] oStyle);
public static final native int FMGetFontFromFontFamilyInstance(short iFontFamily, short iStyle, int[] oFont, short[] oIntrinsicStyle);
public static final native int FMGetNextFontFamily(int ioIterator, short[] oFontFamily);
public static final native int FMGetNextFontFamilyInstance(int ioIterator, int[] oFont, short[] oStyle, short[] oSize);
public static final native boolean FPIsFontPanelVisible();
public static final native int FPShowHideFontPanel();
public static final native int FSpGetFInfo(byte[] spec, byte[] fndrInfo);
public static final native int FSpMakeFSRef(byte[] source, byte[] newRef);
public static final native int FSGetCatalogInfo(byte[] ref, int whichInfo, byte[] catalogInfo, byte[] outName, byte[] fsSpec, byte[] parentRef); 
public static final native short FindWindow(Point where, int[] wHandle);
public static final native void FrameOval(Rect bounds);
public static final native void FramePoly(int polyHandle);
public static final native void FrameRect(Rect bounds);
public static final native void FrameRoundRect(Rect bounds, short ovalWidth, short ovalHeight);
public static final native int FrontWindow();
public static final native int Gestalt(int selector, int[] response);
public static final native short GetAppFont();
public static final native int GetApplicationEventTarget();
public static final native int GetAvailableWindowAttributes(int windowClass);
public static final native int GetAvailableWindowPositioningBounds(int inDevice, Rect outAvailableRect);
public static final native int GetBestControlRect(int inControl, Rect outRect, short[] outBaseLineOffset);
public static final native int GetCaretTime();
public static final native void GetClip(int rgnHandle);
public static final native int GetControl32BitMaximum(int cHandle);
public static final native int GetControl32BitMinimum(int cHandle);
public static final native int GetControl32BitValue(int cHandle);
public static final native void GetControlBounds(int cHandle, Rect bounds);
public static final native int GetControlData(int inControl, short inPart, int inTagName, int inBufferSize, ControlFontStyleRec inBuffer, int[] outActualSize);
public static final native int GetControlData(int inControl, short inPart, int inTagName, int inBufferSize, Rect inBuffer, int[] outActualSize);
public static final native int GetControlData(int inControl, short inPart, int inTagName, int inBufferSize, int[] inBuffer, int[] outActualSize);
public static final native int GetControlData(int inControl, short inPart, int inTagName, int inBufferSize, short[] inBuffer, int[] outActualSize);
public static final native int GetControlData(int inControl, short inPart, int inTagName, int inBufferSize, byte[] inBuffer, int[] outActualSize);
public static final native int GetControlEventTarget(int cHandle);
public static final native int GetControlFeatures(int inControl, int[] outFeatures);
public static final native int GetControlOwner(int cHandle);
public static final native int GetControlProperty(int control, int  propertyCreator, int propertyTag, int bufferSize, int[] actualSize,  int[] propertyBuffer);
public static final native int GetControlReference(int cHandle);
public static final native int GetControlRegion(int cHandle, short inPart, int rgnHandle);
public static final native short GetControlValue(int cHandle);
public static final native int GetControlViewSize(int cHandle);
public static final native int GetCurrentEventButtonState();
public static final native int GetCurrentEventLoop();
public static final native int GetCurrentEventKeyModifiers();
public static final native int GetCurrentEventQueue();
public static final native int GetCurrentProcess(int[] psn);
public static final native int GetCurrentScrap(int[] scrap);
public static final native int GetDataBrowserCallbacks(int browser, DataBrowserCallbacks  callbacks);
public static final native int GetDataBrowserItemCount(int cHandle, int container, boolean recurse, int state, int[] numItems);
public static final native int GetDataBrowserItemDataButtonValue(int itemData, short [] theData);
public static final native int GetDataBrowserItemPartBounds(int cHandle, int item, int property, int part, Rect bounds);
public static final native int GetDataBrowserItems(int browser, int container, boolean recurse, int state, int items);
public static final native int GetDataBrowserItemState(int browser, int item, int [] state);
public static final native int GetDataBrowserListViewDisclosureColumn(int browser, int [] column, boolean [] expandableRows);
public static final native int GetDataBrowserListViewHeaderBtnHeight(int browser, short [] height);
public static final native int GetDataBrowserListViewHeaderDesc(int browser, int column, DataBrowserListViewHeaderDesc desc);
public static final native int GetDataBrowserPropertyFlags(int browser, int property, int [] flags);
public static final native int GetDataBrowserTableViewColumnPosition(int browser,int column,int[] position);
public static final native int GetDataBrowserTableViewItemID(int browser, int row, int [] item);
public static final native int GetDataBrowserTableViewItemRow(int browser, int item, int [] row);                         
public static final native int GetDataBrowserTableViewNamedColumnWidth(int browser, int column, short [] width);
public static final native int GetDataBrowserTableViewRowHeight(int browser, short [] height);
public static final native int GetDataBrowserScrollBarInset(int browser, Rect insetRect);
public static final native int GetDataBrowserScrollPosition(int cHandle, int[] top, int[] left);
public static final native int GetDataBrowserSelectionAnchor(int browser, int [] first, int [] last);
public static final native int GetDataBrowserSelectionFlags(int browser, int [] selectionFlags);
public static final native int GetDataBrowserSortProperty(int browser, int[] property);
public static final native int GetDblTime();
public static final native short GetDefFontSize();
public static final native int GetDeviceList();
public static final native int GetDragAllowableActions(int theDrag, int[] outActions); 
public static final native int GetDragDropAction(int theDrag, int[] outAction);
public static final native int GetDragItemReferenceNumber(int theDrag, short index, int[] theItemRef);
public static final native int GetDragModifiers(int theDrag, short[] modifiers, short[] mouseDownModifiers, short[] mouseUpModifiers);
public static final native int GetDragMouse(int theDrag, Point mouse, Point globalPinnedMouse); 
public static final native int GetEventClass(int eHandle);
public static final native int GetEventDispatcherTarget();
public static final native int GetEventKind(int eHandle);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, int[] outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, char[] outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, short[] outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, byte[] outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, HICommand outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, Point outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, CGPoint outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, RGBColor outData);
public static final native int GetEventParameter(int inEvent, int inName, int inDesiredType, int[] outActualType, int inBufferSize, int[] outActualSize, Rect outData);
public static final native double GetEventTime(int eHandle);
public static final native int GetFlavorData(int theDrag, int theItemRef, int theType, byte[] dataPtr, int[] dataSize, int dataOffset);
public static final native int GetFlavorDataSize(int theDrag, int theItemRef, int theType, int[] dataSize);
public static final native int GetFlavorType(int theDrag,int theItemRef, short index, int[] theType);
public static final native void GetFontInfo(FontInfo info);
public static final native int GetGDevice();
public static final native void GetGWorld(int[] portHandle, int[] gdHandle);
public static final native void GetGlobalMouse(Point where);
public static final native int GetHandleSize(int handle);
public static final native int GetIconFamilyData(int iconFamily, int iconType, int h);
public static final native int GetIconRef(short vRefNum, int creator, int iconType, int[] theIconRef);
public static final native int GetIndMenuItemWithCommandID(int mHandle, int commandId, int index, int[] outMenu, short[] outIndex);
public static final native int GetIndexedSubControl(int cHandle, short index, int[] outHandle);
public static final native void GetItemMark (int theMenu, short item, short[] markChar);
public static final native int GetKeyboardFocus(int wHandle, int[] cHandle);
public static final native double GetLastUserEventTime();
public static final native int GetMainDevice();
public static final native int GetMainEventQueue();
public static final native int GetMBarHeight();
public static final native int GetMenuCommandMark(int theMenu, int commandId, char[] outMark);
public static final native int GetMenuEventTarget(int cHandle);
public static final native int GetMenuFont(int inMenu, short[] outFontID, short[] outFontSize);
public static final native short GetMenuHeight(int inMenu);
public static final native short GetMenuID(int menu);
public static final native int GetMenuItemCommandID(int inMenu, short inItem, int[] outCommandID);
public static final native int GetMenuItemHierarchicalMenu(int inMenu, short inItem, int []outHierMenu);
public static final native int GetMenuItemRefCon(int inMenu, short intItem, int[] outRefCon);
public static final native int GetMenuTrackingData(int menu, MenuTrackingData outData);
public static final native short GetMenuWidth(int inMenu);
public static final native void GetMouse(Point where);
public static final native int GetNextDevice(int curDevice);
public static final native void GetPixBounds(int pHandle, Rect bounds);
public static final native short GetPixDepth(int pHandle);
public static final native void GetPort(int[] port);
public static final native int GetPortBitMapForCopyBits(int portHandle);
public static final native void GetPortBounds(int pHandle, Rect rect);
public static final native void GetPortClipRegion(int port, int clipRgn);
public static final native int GetPortVisibleRegion(int portHandle, int rgnHandle);
public static final native int GetPreviousWindow(int inWindow);
public static final native int GetPtrSize(int ptr);
public static final native void GetRegionBounds(int rgnHandle, Rect bounds);
public static final native int GetRootControl(int windowHandle, int[] cHandle);
public static final native int GetScrapFlavorCount(int scrap, int[] infoCount);
public static final native int GetScrapFlavorData(int scrap, int flavorType, int[] byteCount, byte[] destination);
public static final native int GetScrapFlavorData(int scrap, int flavorType, int[] byteCount, char[] destination);
public static final native int GetScrapFlavorInfoList(int scrap, int[] infoCount, int[] info);
public static final native int GetScrapFlavorSize(int scrap, int flavorType, int[] byteCount);
public static final native int GetScriptManagerVariable(short selector);
public static final native int GetSuperControl(int cHandle, int[] parentHandle);
public static final native int GetTabContentRect(int theControl, Rect rect);
public static final native int GetThemeBrushAsColor(short inBrush, short inDepth, boolean inColorDev, RGBColor outColor);
public static final native int GetThemeButtonContentBounds(Rect inBounds, int inKind, ThemeButtonDrawInfo inDrawInfo, Rect outBounds);
public static final native int GetThemeDrawingState(int[] state);
public static final native int GetThemeFont(short themeFontId, short scriptCode, byte[] fontName, short[] fontSize, byte[] style);
public static final native int GetThemeMenuItemExtra(short inItemType, short[] outHeight, short[] outWidth); 
public static final native int GetThemeMetric(int inMetric, int [] outMetric);
public static final native int GetThemeTextColor(short inColor, short inDepth, boolean inColorDev, RGBColor outColor);
public static final native int GetThemeTextDimensions(int sHandle, short fontID, int state, boolean wrapToWidth, Point ioBounds, short[] baseLine);
public static final native int GetUserFocusEventTarget();
public static final native int GetUserFocusWindow();
public static final native int GetWRefCon(int wHandle);
public static final native int GetWindowActivationScope(int inWindow, int[] outScope);
public static final native void GetWindowBounds(int wHandle, short windowRegion, Rect bounds);
public static final native int GetWindowDefaultButton(int wHandle, int[] cHandle);
public static final native int GetWindowEventTarget(int wHandle);
public static final native int GetWindowFromPort(int pHandle);
public static final native int GetWindowGroupOfClass (int windowClass);
public static final native int GetWindowModality(int inWindow, int[] outModalKind, int[] outUnavailableWindow);
public static final native int GetWindowPort(int wHandle);
public static final native int GetWindowRegion(int window, short inRegionCode, int ioWinRgn);
public static final native int GetWindowResizeLimits (int inWindow, CGPoint inMinLimits, CGPoint inMaxLimits);
public static final native void GetWindowStructureWidths(int intWindow, Rect outRect);
public static final native int HandleControlSetCursor(int control, Point localPoint, int modifiers, boolean[] cursorWasSet);  
public static final native int HIComboBoxAppendTextItem(int inComboBox, int inText, int[] outIndex);
public static final native int HIComboBoxCopyTextItemAtIndex(int inComboBox, int inIndex, int[] outString);
public static final native int HIComboBoxCreate(CGRect boundsRect, int text, ControlFontStyleRec style, int list, int inAttributes, int[] outComboBox);
public static final native int HIComboBoxGetItemCount(int inComboBox);
public static final native int HIComboBoxInsertTextItemAtIndex(int inComboBox, int inIndex, int inText);
public static final native int HIComboBoxRemoveItemAtIndex(int inComboBox, int inIndex);
public static final native int HIObjectCopyClassID(int inObject);
public static final native int HIObjectCreate(int inClassID, int inConstructData, int[] outObject);
public static final native int HIObjectRegisterSubclass(int inClassID, int inBaseClassID, int inOptions, int inConstructProc, int inNumEvents, int[] inEventList, int inConstructData, int[] outClassRef);
public static final native int HIViewAddSubview(int parent, int child);
public static final native int HIViewClick(int inView, int inEvent);
public static final native int HIViewConvertPoint(CGPoint ioPoint, int inSourceView, int inDestView);
public static final native int HIViewCreateOffscreenImage(int inView, int inOptions, CGRect outFrame, int[] outImage	);
public static final native int HIViewFindByID(int inStartView, int inID, int[] outControl);
public static final native int HIViewGetFirstSubview(int inView);
public static final native int HIViewGetLastSubview(int inView);
public static final native int HIViewGetNextView(int inView);
public static final native int HIViewGetFrame(int inView, CGRect outRect);
public static final native int HIViewGetRoot(int wHandle);
public static final native int HIViewGetSizeConstraints(int inView, CGRect outMinSize, CGRect outMaxSize);
public static final native int HIViewGetSubviewHit(int inView, CGPoint inPoint, boolean inDeep, int[] outView);
public static final native int HIViewGetViewForMouseEvent(int inView, int inEvent, int[] outView);
public static final native boolean HIViewIsVisible(int inView);
public static final native int HIViewRemoveFromSuperview(int inView);
public static final native int HIViewSetBoundsOrigin(int inView, float inX, float inY); 
public static final native int HIViewSetDrawingEnabled(int inView, boolean isEnabled);
public static final native int HIViewSetFrame(int inView, CGRect inRect);
public static final native int HIViewSetNeedsDisplay(int inView, boolean inNeedsDisplay);
public static final native int HIViewSetNeedsDisplayInRegion(int inView, int inRgn, boolean inNeedsDisplay);
public static final native int HIViewSetVisible(int inView, boolean inVisible);
public static final native int HIViewSetZOrder(int inView, int inOp, int inOther);
public static final native int HIViewSimulateClick(int inView, short inPartToClick, int modifiers, short[] outPartClicked);
public static final native short HandleControlClick(int cHandle, Point where, int modifiers, int actionUPP);
public static final native short HiWord(int doubleWord);
public static final native void HideWindow(int wHandle);
public static final native void HiliteMenu(short menuID);
public static final native void HLock(int h);
public static final native int HMGetTagDelay (int [] outDelay);
public static final native int HMHideTag ();
public static final native int HMSetTagDelay (int inDelay);
public static final native void HMInstallControlContentCallback(int inControl, int inContentUPP);  
public static final native void HUnlock(int h);
public static final native int IconRefToIconFamily(int theIconRef, int whichIcons, int[] iconFamily);
public static final native int InitContextualMenus();
public static final native void InitCursor();
public static final native int InitDataBrowserCallbacks(DataBrowserCallbacks callbacks);
public static final native int InitDataBrowserCustomCallbacks(DataBrowserCustomCallbacks callbacks); 
public static final native void InsertMenu(int mHandle, short beforeID);
public static final native int InsertMenuItemTextWithCFString(int mHandle, int sHandle, short index, int attributes, int commandID);
public static final native int InstallEventHandler(int inTarget, int inHandler, int inNumTypes, int[] inList, int inUserData, int[] outRef);
public static final native int InstallEventLoopIdleTimer(int inEventLoop, double inFireDelay,double inInterval, int inTimerProc, int inTimerData, int[] outTimer);
public static final native int InstallEventLoopTimer(int inEventLoop, double inFireDelay, double inInterval, int inTimerProc, int inTimerData, int[] outTimer);
public static final native int InstallReceiveHandler(int receiveHandler,int theWindow, int[] handlerRefCon);
public static final native int InstallTrackingHandler(int trackingHandler,int theWindow, int[] handlerRefCon);
public static final native void InvalWindowRect(int wHandle, Rect bounds);
public static final native void InvalWindowRgn(int wHandle, int rgnHandle);
public static final native void InvertRect(Rect r);
public static final native void InvertRgn(int rgnHandle);
public static final native boolean IsControlActive(int inControl);
public static final native boolean IsControlEnabled(int cHandle);
public static final native boolean IsControlVisible(int cHandle);
public static final native boolean IsDataBrowserItemSelected(int cHandle, int itemID);
public static final native boolean IsMenuCommandEnabled(int mHandle, int commandId);
public static final native boolean IsMenuItemEnabled(int mHandle, short index);
public static final native boolean IsValidControlHandle(int cHandle);
public static final native boolean IsValidMenu(int mHandle);
public static final native boolean IsValidWindowPtr(int grafPort);
public static final native boolean IsWindowActive(int window);
public static final native boolean IsWindowCollapsed(int window);
public static final native boolean IsWindowVisible(int window);
public static final native int KeyTranslate(int transData, short keycode, int[] state);
public static final native void KillPoly(int polyHandle);
public static final native void LineTo(short h, short v);
public static final native int Long2Fix(int x);
public static final native short LoWord(int doubleWord);
public static final native int LockPortBits(int portHandle);
public static final native int MenuSelect(Point mHandle);
public static final native void MoveControl(int theControl, short h, short v);
public static final native void MoveTo(short h, short v);
public static final native void MoveWindow(int wHandle, short h, short v, boolean toFront);
public static final native int NavCreateChooseFolderDialog(NavDialogCreationOptions inOptions, int inEventProc, int inFilterProc, int inClientData, int[] outDialog);
public static final native int NavCreateGetFileDialog(NavDialogCreationOptions inOptions, int inTypeList, int inEventProc, int inPreviewProc, int inFilterProc, int inClientData, int[] outDialog);
public static final native int NavCreatePutFileDialog(NavDialogCreationOptions inOptions, int inFileType, int inFileCreator, int inEventProc, int inClientData, int[] outDialog);
public static final native void NavDialogDispose(int dialogHandle);
public static final native int NavDialogGetSaveFileName(int dialogHandle);
public static final native int NavDialogGetUserAction(int dialogHandle);
public static final native int NavDialogRun(int dialogHandle);
public static final native int NavDialogSetSaveFileName(int dialogHandle, int fileNameHandle);
public static final native int NavGetDefaultDialogCreationOptions(NavDialogCreationOptions outOptions);
public static final native int NavDialogGetReply(int inDialog, NavReplyRecord outReply);
public static final native int NewControl(int owningWindow, Rect boundsRect, byte[] controlTitle, boolean initiallyVisible, short initialValue, short minimumValue, short maximumValue, short procID, int controlReference);
public static final native int NewDrag(int[] theDrag); 
public static final native int NewGWorldFromPtr(int[] offscreenGWorld, int PixelFormat, Rect boundsRect, int cTable, int aGDevice, int flags, int newBuffer, int rowBytes);
public static final native int NewHandle(int size);
public static final native int NewHandleClear(int size);
public static final native int NewPtr(int size);
public static final native int NewPtrClear(int size);
public static final native int NewRgn();
public static final native void OffsetRect(Rect rect, short dh, short dv);
public static final native void OffsetRgn(int rgnHandle, short dh, short dv);
public static final native int OpenDataBrowserContainer(int cHandle, int container);
public static final native int OpenPoly();
public static final native void OpenRgn();
public static final native void PaintOval(Rect bounds);
public static final native void PaintPoly(int polyHandle);
public static final native void PaintRect(Rect bounds);
public static final native void PaintRoundRect(Rect bounds, short ovalWidth, short ovalHeight);
public static final native void PenSize(short h, short v);
public static final native int PickColor(ColorPickerInfo theColorInfo);
public static final native int PopUpMenuSelect(int mHandle, short top, short left, short popUpItem);
public static final native int PostEvent(short eventNum, int eventMsg);
public static final native int PostEventToQueue(int inQueue, int inEvent, short inPriority);
public static final native int PMCreatePageFormat(int[] pageFormat);
public static final native int PMCreatePrintSettings(int[] printSettings);
public static final native int PMCreateSession(int[] printSession);
public static final native int PMFlattenPageFormat(int pageFormat, int[] flatFormat);
public static final native int PMFlattenPrintSettings(int printSettings, int[] flatSettings);
public static final native int PMGetAdjustedPageRect(int pageFormat, PMRect pageRect);
public static final native int PMGetAdjustedPaperRect(int pageFormat, PMRect paperRect);
public static final native int PMGetCollate(int printSettings, boolean[] collate);
public static final native int PMGetCopies(int printSettings, int[] copies);
public static final native int PMGetFirstPage(int printSettings, int[] first);
public static final native int PMGetJobNameCFString(int printSettings, int[] name);
public static final native int PMGetLastPage(int printSettings, int[] last);
public static final native int PMGetPageRange(int printSettings, int[] minPage, int[] maxPage);
public static final native int PMRelease(int printManagerObject);
public static final native int PMGetResolution(int pageFormat, PMResolution resolution);
public static final native int PMSessionBeginDocumentNoDialog(int printSession, int printSettings, int pageFormat);
public static final native int PMSessionBeginPageNoDialog(int printSession, int pageFormat, PMRect pageFrame);
public static final native int PMSessionCopyDestinationLocation(int printSession, int printSettings, int[] destLocationP);
public static final native int PMSessionCreatePrinterList(int printSession, int[] printerList, int[] currentIndex, int[] currentPrinter);
public static final native int PMSessionDefaultPageFormat(int printSession, int pageFormat);
public static final native int PMSessionDefaultPrintSettings(int printSession, int printSettings);
public static final native int PMSessionEndDocumentNoDialog(int printSession);
public static final native int PMSessionEndPageNoDialog(int printSession);
public static final native int PMSessionError(int printSession);
public static final native int PMSessionGetDestinationType(int printSession, int printSettings, short[] destTypeP); 
public static final native int PMSessionGetGraphicsContext(int printSession, int graphicsType, int[] graphicsContext);
public static final native int PMSessionPageSetupDialog(int printSession, int pageFormat, boolean[] result);	
public static final native int PMSessionPrintDialog(int printSession, int settings, int pageFormat, boolean[] accepted);
public static final native int PMSessionSetCurrentPrinter(int session, int printerName);
public static final native int PMSessionSetDestination(int printSession, int printSettings, short destType, int destFormat, int destLocation);
public static final native int PMSessionSetError(int printSession, int printError);
public static final native int PMSessionSetDocumentFormatGeneration(int printSession, int docFormat, int graphicsContexts, int options);
public static final native int PMSessionUseSheets(int printSession, int documentWindow, int sheetDoneProc); 
public static final native int PMSessionValidatePageFormat(int printSession, int pageFormat, boolean[] result);
public static final native int PMSessionValidatePrintSettings(int printSession, int printSettings, boolean[] result);
public static final native int PMSetCollate(int printSettings, boolean collate);
public static final native int PMSetFirstPage(int printSettings, int first, boolean lock);
public static final native int PMSetJobNameCFString(int printSettings, int name); 
public static final native int PMSetLastPage(int printSettings, int last, boolean lock);
public static final native int PMSetPageRange(int printSettings, int minPage, int maxPage);
public static final native int PMUnflattenPageFormat(int flatFormat, int[] pageFormat); 
public static final native int PMUnflattenPrintSettings(int flatSettings, int[] printSettings); 
public static final native boolean PtInRect(Point pt, Rect r);
public static final native boolean PtInRgn(Point pt, int rgnHandle);
public static final native int PutScrapFlavor(int scrap, int flavorType, int flavorFlags, int flavorSize, byte[] flavorData);
public static final native int PutScrapFlavor(int scrap, int flavorType, int flavorFlags, int flavorSize, char[] flavorData);
public static final native int QDBeginCGContext(int inPort, int[] outContext);
public static final native int QDEndCGContext(int inPort, int[] inoutContext);
public static final native void QDFlushPortBuffer(int port, int rgnHandle);
public static final native void QDGlobalToLocalPoint(int port, Point point);
public static final native void QDLocalToGlobalPoint(int port, Point point);
public static final native int QDRegionToRects(int rgn, int dir, int proc, int userData);
public static final native int QDSetDirtyRegion (int port, int rgn);
public static final native void QDSetPatternOrigin(Point point);
public static final native int QDSwapTextFlags(int flags);
public static final native void RGBBackColor(RGBColor color);
public static final native void RGBForeColor(RGBColor color);
public static final native int ReceiveNextEvent(int inNumTypes, int[] inList, double inTimeout, boolean inPullEvent, int[] outEvent);
public static final native boolean RectInRgn(Rect rect, int rgnHandle);
public static final native void RectRgn(int rgnHandle, Rect left);
public static final native int RegisterAppearanceClient();
public static final native void ReleaseEvent(int theEvent);
public static final native void ReleaseIconRef(int theIconRef);
public static final native int ReleaseMenu(int mHandle);
public static final native int ReleaseWindowGroup (int inGroup);
public static final native int ReleaseWindow(int inWindow); 
public static final native int RemoveControlProperty(int control, int propertyCreator, int propertyTag);
public static final native int RemoveDataBrowserItems(int cHandle, int containerID, int numItems, int[] itemIDs, int preSortProperty);
public static final native int RemoveDataBrowserTableViewColumn(int browser, int column);
public static final native int RemoveEventHandler(int inHandlerRef);
public static final native int RemoveEventLoopTimer(int inTimer);
public static final native int RemoveReceiveHandler(int receiveHandler,int theWindow);
public static final native int RemoveTrackingHandler(int trackingHandler,int theWindow);
public static final native int RepositionWindow(int window, int parentWindow, int method);
public static final native int ReshapeCustomWindow(int window);
public static final native int RestoreApplicationDockTileImage();
public static final native int RetainEvent(int inEvent);
public static final native int RetainMenu(int mHandle);
public static final native int RetainWindow(int inWindow); 
public static final native int RevealDataBrowserItem(int browser, int item, int property, byte options);
public static final native int RunStandardAlert(int dialogHandle, int modalFilterUPP, short[] itemHit);
public static final native void ScrollRect(Rect rect, short dh, short dv, int updateRgn);
public static final native boolean SectRect(Rect src1, Rect src2, Rect dstRect);
public static final native void SectRgn(int srcRgnA, int srcRgnB, int dstRgn);
public static final native void SelectWindow(int wHandle);
public static final native void SendBehind(int window, int behindWindow);
public static final native int SendEventToEventTarget(int theEvent, int theTarget);
public static final native int SetApplicationDockTileImage(int inImage);
public static final native int SetAutomaticControlDragTrackingEnabledForWindow (int inWindow, boolean inTracks);
public static final native int SetBevelButtonContentInfo(int inButton, ControlButtonContentInfo inContent);
public static final native void SetClip(int rgnHandle);
public static final native void SetControl32BitMaximum(int cHandle, int maximum);
public static final native void SetControl32BitMinimum(int cHandle, int minimum);
public static final native void SetControl32BitValue(int cHandle, int value);
public static final native void SetControlAction(int cHandle, int actionProc);
public static final native void SetControlBounds(int cHandle, Rect bounds);
public static final native int SetControlColorProc(int inControl, int inProc);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, ControlButtonContentInfo inData);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, ControlTabInfoRecV1 inData);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, Rect inData);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, short[] inData);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, int[] inData);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, int inData);
public static final native int SetControlData(int inControl, int inPart, int inTagName, int inSize, byte[] inData);
public static final native int SetControlFontStyle(int inControl, ControlFontStyleRec inStyle);
public static final native void SetControlPopupMenuHandle(int cHandle, int popupMenuHandle);
public static final native int SetControlProperty(int control, int propertyCreator, int propertyTag, int propertySize, int[] propertyData);
public static final native void SetControlReference(int cHandle, int data);
public static final native int SetControlTitleWithCFString(int cHandle, int sHandle);
public static final native void SetControlViewSize(int cHandle, int viewSize);
public static final native int SetControlVisibility(int inControl, boolean inIsVisible, boolean inDoDraw);
public static final native void SetCursor(int cursor);
public static final native int SetDataBrowserCallbacks(int browser, DataBrowserCallbacks  callbacks);
public static final native int SetDataBrowserCustomCallbacks(int browser, DataBrowserCustomCallbacks  callbacks);
public static final native int SetDataBrowserHasScrollBars(int cHandle, boolean hScroll, boolean vScroll);
public static final native int SetDataBrowserItemDataBooleanValue(int itemRef, boolean data);
public static final native int SetDataBrowserItemDataButtonValue(int itemRef, short themeButtonValue);
public static final native int SetDataBrowserItemDataIcon(int itemRef, int iconRef);
public static final native int SetDataBrowserItemDataItemID(int itemRef, int itemID);
public static final native int SetDataBrowserItemDataText(int itemRef, int sHandle);
public static final native int SetDataBrowserListViewDisclosureColumn(int cHandle, int colID, boolean b);
public static final native int SetDataBrowserListViewHeaderBtnHeight(int cHandle, short height);
public static final native int SetDataBrowserListViewHeaderDesc(int browser, int column, DataBrowserListViewHeaderDesc desc);
public static final native int SetDataBrowserPropertyFlags(int browser, int property, int flags);
public static final native int SetDataBrowserScrollPosition(int cHandle, int top, int left);
public static final native int SetDataBrowserSelectedItems(int cHandle, int numItems, int[] items, int operation);
public static final native int SetDataBrowserSelectionFlags(int cHandle, int selectionFlags);
public static final native int SetDataBrowserSortOrder(int browser, short order);
public static final native int SetDataBrowserTableViewColumnPosition(int browser, int column, int position);
public static final native int SetDataBrowserTableViewHiliteStyle(int browser, int hiliteStyle);  
public static final native int SetDataBrowserTableViewItemRow(int browser, int item, int row);
public static final native int SetDataBrowserTableViewNamedColumnWidth(int browser, int column, short width);
public static final native int SetDataBrowserTableViewRowHeight(int browser, short height	);
public static final native int SetDataBrowserTarget(int cHandle, int rootID);
public static final native int SetDragAllowableActions(int theDrag, int inActions, boolean isLocal);
public static final native int SetDragDropAction(int theDrag, int inAction);
public static final native int SetDragInputProc(int theDrag, int inputProc, int dragInputRefCon);
public static final native int SetEventLoopTimerNextFireTime(int inTimer, double inNextFire);
public static final native int SetEventParameter(int inEvent, int inName, int inType, int inSize, char[] inDataPtr);
public static final native int SetEventParameter(int inEvent, int inName, int inType, int inSize, short[] inDataPtr);
public static final native int SetEventParameter(int inEvent, int inName, int inType, int inSize, int[] inDataPtr);
public static final native int SetFontInfoForSelection(int iStyleType, int iNumStyles, int iStyles, int iFPEventTarget);
public static final native int SetFrontProcess(int[] psn);
public static final native int SetFrontProcessWithOptions(int[] psn, int inOptions);
public static final native void SetGWorld(int portHandle, int gdHandle);
public static final native void SetItemMark(int theMenu, short item, short markChar);
public static final native int SetKeyboardFocus(int wHandle, int cHandle, short inPart);
public static final native int SetMenuCommandMark(int mHandle, int commandId, char mark);
public static final native int SetMenuFont(int mHandle, short fontID, short size);
public static final native int SetMenuItemCommandKey(int mHandle, short index, boolean virtualKey, char key);
public static final native int SetMenuItemHierarchicalMenu(int mHandle, short index, int hierMenuHandle);
public static final native int SetMenuItemIconHandle(int mHandle, short item, byte iconType, int iconHandle);
public static final native int SetMenuItemKeyGlyph(int mHandle, short index, short glyph);
public static final native int SetMenuItemModifiers(int mHandle, short index, byte modifiers);
public static final native int SetMenuItemRefCon(int mHandle, short index, int refCon);
public static final native int SetMenuItemTextWithCFString(int mHandle, short index, int sHandle);
public static final native int SetMenuTitleWithCFString(int mHandle, int sHandle);
public static final native void SetOrigin(short h, short v);
public static final native void SetPort(int pHandle);
public static final native void SetPortBounds(int port, Rect rect);
public static final native void SetPortWindowPort(int wHandle);
public static final native void SetPt(Point p, short h, short v);
public static final native void SetRect(Rect r, short left, short top, short right, short bottom);
public static final native void SetRectRgn(int rgnHandle, short left, short top, short right, short bottom);
public static final native int SetRootMenu(int mHandle);
public static final native int SetThemeBackground(short inBrush, short depth, boolean isColorDevice);
public static final native int SetThemeCursor(int themeCursor);
public static final native int SetThemeDrawingState(int state, boolean disposeNow);
public static final native int SetThemeTextColor(short inBrush, short depth, boolean isColorDevice);
public static final native int SetThemeWindowBackground(int wHandle, short brush, boolean update);
public static final native int SetUpControlBackground(int cHandle, short depth, boolean isColorDevice);
public static final native void SetWRefCon(int wHandle, int data);
public static final native int SetWindowActivationScope(int wHandle, int scope);
public static final native void SetWindowBounds(int window, int regionCode, Rect globalBounds);
public static final native int SetWindowDefaultButton(int wHandle, int cHandle);
public static final native int SetWindowGroup(int inWindow, int inNewGroup);
public static final native int SetWindowGroupOwner(int inGroup, int inWindow);
public static final native int SetWindowGroupParent(int inGroup, int inNewGroup);
public static final native int SetWindowModality(int inWindow, int inModalKind, int inUnavailableWindow);
public static final native int SetWindowResizeLimits (int inWindow, CGPoint inMinLimits, CGPoint inMaxLimits);
public static final native int SetWindowTitleWithCFString(int wHandle, int sHandle);
public static final native void ShowWindow(int wHandle);
public static final native void SizeControl(int cHandle, short w, short h);
public static final native void SizeWindow(int wHandle, short w, short h, boolean update);
public static final native boolean StillDown();
public static final native int SyncCGContextOriginWithPort(int inContext, int port);
public static final native void SysBeep(short duration);
public static final native int TXNActivate(int txHandle, int frameID, boolean scrollBarState);
public static final native void TXNAdjustCursor (int iTXNObject, int ioCursorRgn);
public static final native void TXNClick(int iTXNObject, EventRecord iEvent);
public static final native int TXNCopy(int txHandle);
public static final native int TXNCut(int txHandle);
public static final native int TXNDataSize(int txHandle);
public static final native void TXNDeleteObject(int txHandle);
public static final native void TXNDraw(int txHandle, int gDevice);
public static final native int TXNEchoMode(int txHandle, char echoCharacter, int encoding, boolean on);
public static final native void TXNFocus(int txHandle, boolean becomingFocused);
public static final native int TXNGetData(int txHandle, int startOffset, int endOffset, int[] dataHandle);
public static final native int TXNGetLineCount(int txHandle, int[] lineTotal);
public static final native int TXNGetLineMetrics(int iTXNObject, int iLineNumber, int [] oLineWidth, int [] oLineHeight);
public static final native int TXNGetTXNObjectControls(int iTXNObject, int iControlCount, int [] iControlTags, int [] oControlData);
public static final native int TXNGetRectBounds(int iTXNObject, Rect oViewRect, TXNLongRect oDestinationRect, TXNLongRect oTextRect);
public static final native void TXNGetSelection(int txHandle, int[] startOffset, int[] endOffset);
public static final native void TXNGetViewRect (int iTXNObject, Rect oViewRect);
public static final native int TXNInitTextension(int iDefaultFonts, int iCountDefaultFonts, int iUsageFlags);
public static final native int TXNNewObject(int iFileSpec, int iWindw, Rect iFrame, int iFrameOptions, int iFrameType, int iFileType, int iPermanentEncoding, int [] oTXNObject, int[] oTXNFrameID, int iRefCpm);
public static final native int TXNOffsetToPoint(int txHandle, int offset, Point point);
public static final native int TXNPaste(int txHandle);
public static final native int TXNPointToOffset (int iTXNObject, Point iPoint, int [] oOffset);
public static final native void TXNSelectAll(int txHandle);
public static final native void TXNSetRectBounds(int iTXNObject, Rect iViewRect, TXNLongRect iDestinationRect, boolean iUpdate);
public static final native int TXNSetBackground(int iTXNObject, TXNBackground iBackgroundInfo);
public static final native int TXNSetData(int iTXNObject, int iDataType, char[] iDataPtr, int iDataSize, int iStartOffset, int iEndOffset);
public static final native void TXNSetFrameBounds(int txHandle, int top, int left, int bottom, int right, int frameID);
public static final native int TXNSetSelection(int txHandle, int startOffset, int endOffset);
public static final native int TXNSetTypeAttributes(int iTXNObject, int iAttrCount, int iAttributes, int iStartOffset, int iEndOffset);
public static final native int TXNSetTXNObjectControls(int iTXNObject, boolean iClearAll, int iControlCount, int[] iControlTags, int[] iControlData);
public static final native void TXNShowSelection(int txHandle, boolean showEnd);
public static final native short TestControl(int control, Point point);
public static final native void TextFace(short face);
public static final native void TextFont(short fontID);
public static final native void TextMode(short mode);
public static final native void TextSize(short size);
public static final native short TextWidth(byte[] textBuf, short firstByte, short byteCount);
public static final native int TrackDrag(int theDrag, EventRecord theEvent, int theRegion);
public static final native int TrackMouseLocationWithOptions(int inPort, int inOptions, double inTime, Point outPt, int [] outModifiers, short[] outResult);
public static final native void UnionRect(Rect srcA, Rect srcB, Rect dst);
public static final native void UnionRgn(int srcRgnA, int srcRgnB, int dstRgn);
public static final native int UnlockPortBits(int portHandle);
public static final native void UpdateControls(int wHandle, int rgnHandle);
public static final native int UpdateDataBrowserItems(int cHandle, int container, int numItems, int[] items, int preSortProperty, int propertyID);
public static final native int UpgradeScriptInfoToTextEncoding(short iTextScriptID, short iTextLanguageID, short iRegionID, byte[] iTextFontname, int[] oEncoding); 
public static final native boolean WaitMouseMoved(Point initialGlobalMouse);
public static final native int X2Fix(double x);
public static final native int ZoomWindowIdeal(int inWindow, short inPartCode, Point ioIdealSize);
public static final native void memcpy(ATSTrapezoid dest, int src, int n);
public static final native void memcpy(byte[] dest, int src, int n);
public static final native void memcpy(char[] dest, int src, int n);
public static final native void memcpy(int[] dest, int src, int n);
public static final native void memcpy(int dest, int[] src, int n);
public static final native void memcpy(int dest, PixMap src, int n);
public static final native void memcpy(int dest, Cursor src, int n);
public static final native void memcpy(GDevice dest, int src, int n);
public static final native void memcpy(PixMap dest, int src, int n);
public static final native void memcpy(FontSelectionQDStyle dest, int src, int n);
public static final native void memcpy(HMHelpContentRec dest, int src, int n);
public static final native void memcpy(ATSLayoutRecord dest, int src, int n);
public static final native void memcpy(int dest, HMHelpContentRec src, int n);
public static final native void memcpy(int dest, BitMap src, int n);
public static final native void memcpy(int dest, char[] src, int n);
public static final native void memcpy(int dest, int src, int n);
public static final native void memcpy(int dest, byte[] src, int n);
public static final native void memcpy(int dest, FontSelectionQDStyle src, int n);
public static final native void memcpy(int dest, RGBColor src, int n);
public static final native void memcpy(Rect dest, int src, int n);
public static final native void memcpy(int dest, Rect src, int n);
public static final native void memcpy(char[] dest, byte[] src, int size);
public static final native void memcpy(byte[] dest, char[] src, int size);
public static final native void memcpy(int dest, EventRecord src, int size);
public static final native void memcpy(int dest, ATSUTab src, int size);
public static final native void memcpy(float[] dest, int src, int size);
public static final native void memset(int dest, int value, int size);
}
