/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.RectF;

public class Path {
    public int handle;
    Device device;
    PointF currentPoint = new PointF();

    public Path(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        device.checkGDIP();
        this.handle = Gdip.GraphicsPath_new(0);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0.0f) {
            x += width;
            width = -width;
        }
        if (height < 0.0f) {
            y += height;
            height = -height;
        }
        if (width == 0.0f || height == 0.0f || arcAngle == 0.0f) {
            return;
        }
        Gdip.GraphicsPath_AddArc(this.handle, x, y, width, height, -startAngle, -arcAngle);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        Gdip.GraphicsPath_AddPath(this.handle, path.handle, false);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RectF rect = new RectF();
        rect.X = x;
        rect.Y = y;
        rect.Width = width;
        rect.Height = height;
        Gdip.GraphicsPath_AddRectangle(this.handle, rect);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public void addString(String string, float x, float y, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int length = string.length();
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        int hDC = this.device.internal_new_GC(null);
        int gdipFont = Gdip.Font_new(hDC, font.handle);
        PointF point = new PointF();
        point.X = x - Gdip.Font_GetSize(gdipFont) / 6.0f;
        point.Y = y;
        int family = Gdip.FontFamily_new();
        Gdip.Font_GetFamily(gdipFont, family);
        int style = Gdip.Font_GetStyle(gdipFont);
        float size = Gdip.Font_GetSize(gdipFont);
        Gdip.GraphicsPath_AddString(this.handle, buffer, length, family, style, size, point, 0);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
        Gdip.FontFamily_delete(family);
        Gdip.Font_delete(gdipFont);
        this.device.internal_dispose_GC(hDC, null);
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_CloseFigure(this.handle);
    }

    public void curveTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddBezier(this.handle, this.currentPoint.X, this.currentPoint.Y, cx1, cy1, cx2, cy2, x, y);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        Gdip.GraphicsPath_delete(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getCurrentPoint(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        point[0] = this.currentPoint.X;
        point[1] = this.currentPoint.Y;
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddLine(this.handle, this.currentPoint.X, this.currentPoint.Y, x, y);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.currentPoint.X = x;
        this.currentPoint.Y = y;
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddBezier(this.handle, this.currentPoint.X, this.currentPoint.Y, cx, cy, cx, cy, x, y);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

