/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.ControlButtonContentInfo;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    int handle;
    int iconHandle;
    int labelHandle;
    int cIcon;
    int labelCIcon;
    int visibleRgn;
    ToolBar parent;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    Control control;
    boolean tracking;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;
    static final int DEFAULT_SEPARATOR_WIDTH = 8;
    static final int ARROW_WIDTH = 9;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
        parent.relayout();
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
        parent.relayout();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    org.eclipse.swt.graphics.Point computeSize() {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 2) != 0) {
            if ((this.parent.style & 0x100) != 0) {
                width = this.getWidth();
                height = 22;
            } else {
                width = 24;
                height = this.getWidth();
            }
        } else {
            int space = 0;
            int stringWidth = 0;
            int stringHeight = 0;
            if (this.text.length() != 0) {
                GC gc = new GC(this.parent);
                int flags = 15;
                org.eclipse.swt.graphics.Point size = gc.textExtent(this.text, flags);
                stringWidth = size.x;
                stringHeight = size.y;
                gc.dispose();
            }
            int imageWidth = 0;
            int imageHeight = 0;
            if (this.image != null) {
                if (this.text.length() != 0) {
                    space = 2;
                }
                Rectangle rect = this.image.getBounds();
                imageWidth = rect.width;
                imageHeight = rect.height;
            }
            if ((this.parent.style & 0x20000) != 0) {
                width = stringWidth + imageWidth;
                height = Math.max(stringHeight, imageHeight);
            } else {
                width = Math.max(stringWidth, imageWidth);
                height = stringHeight + imageHeight;
            }
            if ((this.style & 4) != 0) {
                width += 9;
            }
            int inset = 3;
            width += space + inset * 2;
            height += space + inset * 2;
        }
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    void createHandle() {
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)this.parent.handle);
        int features = 18;
        OS.CreateUserPaneControl((int)window, null, (int)features, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        int width = 24;
        int height = 22;
        if ((this.style & 2) == 0) {
            ControlButtonContentInfo inContent = new ControlButtonContentInfo();
            OS.CreateIconControl((int)window, null, (ControlButtonContentInfo)inContent, (boolean)false, (int[])outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.iconHandle = outControl[0];
            OS.CreateIconControl((int)window, null, (ControlButtonContentInfo)inContent, (boolean)false, (int[])outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.labelHandle = outControl[0];
        } else if ((this.parent.style & 0x100) != 0) {
            width = 8;
        } else {
            height = 8;
        }
        this.setBounds(0, 0, width, height);
        this.parent.relayout();
    }

    void createWidget() {
        super.createWidget();
        this.setZOrder();
        this.toolTipText = "";
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.iconHandle != 0) {
            this.display.removeWidget(this.iconHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    void destroyWidget() {
        int theControl = this.handle;
        this.releaseHandle();
        if (theControl != 0) {
            OS.DisposeControl((int)theControl);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar parent = this.parent;
        super.dispose();
        parent.relayout();
    }

    void drawBackground(int control) {
        this.drawBackground(control, null);
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
        if (control == this.handle && (this.style & 6) != 0) {
            int state = OS.IsControlEnabled((int)control) && OS.IsControlActive((int)control) ? 1 : 0;
            Rect rect = new Rect();
            OS.GetControlBounds((int)this.handle, (Rect)rect);
            if ((this.style & 2) != 0) {
                rect.top = (short)(rect.top + 2);
                rect.bottom = (short)(rect.bottom - 2);
                OS.DrawThemeSeparator((Rect)rect, (int)state);
            }
            if ((this.style & 4) != 0) {
                int height = rect.bottom - rect.top;
                rect.top = (short)(rect.bottom - height / 2 - 1);
                rect.left = (short)(rect.right - 9);
                OS.DrawThemePopupArrow((Rect)rect, (short)1, (short)1, (int)state, (int)0, (int)0);
            }
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rect rect = this.getControlBounds(this.handle);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    int getDrawCount(int control) {
        return this.parent.getDrawCount(control);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        short[] transform = new short[1];
        OS.GetControlData((int)this.iconHandle, (short)0, (int)1953654381, (int)2, (short[])transform, null);
        return (transform[0] & 0x4000) != 0;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        return rect.right - rect.left;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(control, this.visibleRgn, false);
        }
        int result = OS.NewRgn();
        OS.CopyRgn((int)this.visibleRgn, (int)result);
        return result;
    }

    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        switch (inRequest) {
            case 0: {
                int[] contentProvided = new int[]{-1};
                if (this.toolTipText != null && this.toolTipText.length() != 0) {
                    char[] buffer = new char[this.toolTipText.length()];
                    this.toolTipText.getChars(0, buffer.length, buffer, 0);
                    int length = this.fixMnemonic(buffer);
                    if (this.display.helpString != 0) {
                        OS.CFRelease((int)this.display.helpString);
                    }
                    this.display.helpString = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)length);
                    HMHelpContentRec helpContent = new HMHelpContentRec();
                    OS.memcpy((HMHelpContentRec)helpContent, (int)ioHelpContent, (int)534);
                    helpContent.version = 3;
                    helpContent.tagSide = 0;
                    this.display.helpControl = null;
                    helpContent.absHotRect_left = 0;
                    helpContent.absHotRect_top = 0;
                    helpContent.absHotRect_right = 0;
                    helpContent.absHotRect_bottom = 0;
                    helpContent.content0_contentType = 1667658612;
                    helpContent.content0_tagCFString = this.display.helpString;
                    helpContent.content1_contentType = 1667658612;
                    helpContent.content1_tagCFString = this.display.helpString;
                    OS.memcpy((int)ioHelpContent, (HMHelpContentRec)helpContent, (int)534);
                    contentProvided[0] = 0;
                }
                OS.memcpy((int)outContentProvided, (int[])contentProvided, (int)4);
                break;
            }
            case 1: {
                if (this.display.helpString != 0) {
                    OS.CFRelease((int)this.display.helpString);
                }
                this.display.helpString = 0;
            }
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int controlProc = this.display.controlProc;
        int[] mask1 = new int[]{1668183148, 4, 1668183148, 1, 1668183148, 12, 1668183148, 51};
        int controlTarget = OS.GetControlEventTarget((int)this.handle);
        OS.InstallEventHandler((int)controlTarget, (int)controlProc, (int)(mask1.length / 2), (int[])mask1, (int)this.handle, null);
        int[] mask2 = new int[]{1668183148, 4, 1668183148, 12, 1668183148, 51};
        if (this.iconHandle != 0) {
            controlTarget = OS.GetControlEventTarget((int)this.iconHandle);
            OS.InstallEventHandler((int)controlTarget, (int)controlProc, (int)(mask2.length / 2), (int[])mask2, (int)this.iconHandle, null);
        }
        if (this.labelHandle != 0) {
            controlTarget = OS.GetControlEventTarget((int)this.labelHandle);
            OS.InstallEventHandler((int)controlTarget, (int)controlProc, (int)(mask2.length / 2), (int[])mask2, (int)this.labelHandle, null);
        }
        int helpProc = this.display.helpProc;
        OS.HMInstallControlContentCallback((int)this.handle, (int)helpProc);
    }

    void invalidateVisibleRegion(int control) {
        this.resetVisibleRegion(control);
        this.parent.resetVisibleRegion(control);
    }

    void invalWindowRgn(int window, int rgn) {
        this.parent.invalWindowRgn(window, rgn);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    int kEventControlContextualMenuClick(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventControlContextualMenuClick(nextHandler, theEvent, userData);
    }

    int kEventControlHit(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlHit(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        }
        this.postEvent(13);
        return -9874;
    }

    int kEventControlTrack(int nextHandler, int theEvent, int userData) {
        this.tracking = true;
        return -9874;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int result = this.parent.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.style & 4) != 0) {
            int sizeof = 4;
            Point pt = new Point();
            OS.GetEventParameter((int)theEvent, (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)pt);
            Rect rect = new Rect();
            int window = OS.GetControlOwner((int)this.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            int x = pt.h - rect.left;
            int y = pt.v - rect.top;
            OS.GetControlBounds((int)this.handle, (Rect)rect);
            y -= rect.top;
            int width = rect.right - rect.left;
            if (width - (x -= rect.left) < 12) {
                x = rect.left;
                y = rect.bottom;
                OS.GetControlBounds((int)this.parent.handle, (Rect)rect);
                Event event = new Event();
                event.detail = 4;
                event.x = x -= rect.left;
                event.y = y -= rect.top;
                this.postEvent(13, event);
            }
        }
        this.display.grabControl = null;
        this.display.runDeferredEvents();
        this.tracking = false;
        result = OS.CallNextEventHandler((int)nextHandler, (int)theEvent);
        if (this.tracking) {
            Point outPt = new Point();
            OS.GetGlobalMouse((Point)outPt);
            Rect rect = new Rect();
            int window = OS.GetControlOwner((int)this.handle);
            OS.GetWindowBounds((int)window, (short)33, (Rect)rect);
            int x = outPt.h - rect.left;
            int y = outPt.v - rect.top;
            OS.GetControlBounds((int)this.parent.handle, (Rect)rect);
            x -= rect.left;
            y -= rect.top;
            short[] button = new short[1];
            OS.GetEventParameter((int)theEvent, (int)1835168878, (int)1835168878, null, (int)2, null, (short[])button);
            int chord = OS.GetCurrentEventButtonState();
            int modifiers = OS.GetCurrentEventKeyModifiers();
            this.parent.sendMouseEvent(4, button[0], chord, (short)x, (short)y, modifiers, true);
        }
        this.tracking = false;
        return result;
    }

    int kEventMouseDragged(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventMouseDragged(nextHandler, theEvent, userData);
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventMouseMoved(nextHandler, theEvent, userData);
    }

    int kEventMouseUp(int nextHandler, int theEvent, int userData) {
        return this.parent.kEventMouseUp(nextHandler, theEvent, userData);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.iconHandle != 0) {
            this.display.addWidget(this.iconHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.setVisible(this.handle, false);
        this.parent.destroyItem(this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.labelHandle = 0;
        this.iconHandle = 0;
        this.handle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
        }
        if (this.labelCIcon != 0) {
            this.destroyCIcon(this.labelCIcon);
        }
        this.labelCIcon = 0;
        this.cIcon = 0;
        if (this.visibleRgn != 0) {
            OS.DisposeRgn((int)this.visibleRgn);
        }
        this.visibleRgn = 0;
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resetVisibleRegion(int control) {
        if (this.visibleRgn != 0) {
            OS.DisposeRgn((int)this.visibleRgn);
            this.visibleRgn = 0;
        }
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    void setBounds(int x, int y, int width, int height) {
        if (this.control != null) {
            this.control.setBounds(x, y, width, height);
        }
        this.setBounds(this.handle, x, y, width, height, true, true, false);
        if ((this.style & 2) != 0) {
            return;
        }
        int space = 0;
        int inset = 3;
        int stringWidth = 0;
        int stringHeight = 0;
        if (this.text.length() != 0) {
            GC gc = new GC(this.parent);
            int flags = 15;
            org.eclipse.swt.graphics.Point size = gc.textExtent(this.text, flags);
            stringWidth = size.x;
            stringHeight = size.y;
            gc.dispose();
        }
        int imageWidth = 0;
        int imageHeight = 0;
        if (this.image != null) {
            if (this.text.length() != 0) {
                space = 2;
            }
            Rectangle rect = this.image.getBounds();
            imageWidth = rect.width;
            imageHeight = rect.height;
        }
        int arrowWidth = 0;
        if ((this.style & 4) != 0) {
            arrowWidth = 9;
        }
        if ((this.parent.style & 0x20000) != 0) {
            int imageX = inset;
            int imageY = inset + (height - inset * 2 - imageHeight) / 2;
            this.setBounds(this.iconHandle, imageX, imageY, imageWidth, imageHeight, true, true, false);
            int labelX = imageX + imageWidth + space;
            int labelY = inset + (height - inset * 2 - stringHeight) / 2;
            this.setBounds(this.labelHandle, labelX, labelY, stringWidth, stringHeight, true, true, false);
        } else {
            int imageX = inset + (width - inset * 2 - arrowWidth - imageWidth) / 2;
            int imageY = inset;
            this.setBounds(this.iconHandle, imageX, imageY, imageWidth, imageHeight, true, true, false);
            int labelX = inset + (width - inset * 2 - arrowWidth - stringWidth) / 2;
            int labelY = imageY + imageHeight + space;
            this.setBounds(this.labelHandle, labelX, labelY, stringWidth, stringHeight, true, true, false);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        this.control = control;
        if (control != null && !control.isDisposed()) {
            control.setBounds(this.getBounds());
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            if ((this.state & 8) == 0) {
                return;
            }
            this.state &= 0xFFFFFFF7;
            OS.EnableControl((int)this.handle);
        } else {
            if ((this.state & 8) != 0) {
                return;
            }
            this.state |= 8;
            OS.DisableControl((int)this.handle);
        }
    }

    void setFontStyle(Font font) {
        this.updateText();
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        this.updateImage();
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        this.updateImage();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.updateImage();
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        int transform = selected ? 16384 : 0;
        OS.SetControlData((int)this.iconHandle, (int)0, (int)1953654381, (int)2, (short[])new short[]{(short)transform});
        if (this.image == null) {
            OS.SetControlData((int)this.labelHandle, (int)0, (int)1953654381, (int)2, (short[])new short[]{(short)transform});
        }
        this.redrawWidget(this.handle, true);
    }

    void setSize(int width, int height, boolean layout) {
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        if (rect.right - rect.left != width || rect.bottom - rect.top != height) {
            this.setBounds(this.handle, 0, 0, width, height, false, true, false);
            if (layout) {
                this.parent.relayout();
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        this.updateText();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < 0) {
            return;
        }
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        this.setSize(width, rect.bottom - rect.top, true);
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setBounds(this.getBounds());
        }
    }

    void setZOrder() {
        OS.HIViewAddSubview((int)this.parent.handle, (int)this.handle);
        if (this.iconHandle != 0) {
            OS.HIViewAddSubview((int)this.handle, (int)this.iconHandle);
        }
        if (this.labelHandle != 0) {
            OS.HIViewAddSubview((int)this.handle, (int)this.labelHandle);
        }
    }

    void updateImage() {
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.cIcon != 0) {
            this.destroyCIcon(this.cIcon);
        }
        this.cIcon = 0;
        Image image = null;
        image = this.hotImage != null ? this.hotImage : (this.image != null ? this.image : this.disabledImage);
        ControlButtonContentInfo inContent = new ControlButtonContentInfo();
        if (image != null) {
            this.cIcon = this.createCIcon(image);
            inContent.contentType = (short)130;
            inContent.iconRef = this.cIcon;
        }
        OS.SetBevelButtonContentInfo((int)this.iconHandle, (ControlButtonContentInfo)inContent);
        this.redrawWidget(this.iconHandle, false);
        org.eclipse.swt.graphics.Point size = this.computeSize();
        this.setSize(size.x, size.y, true);
    }

    void updateText() {
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.labelCIcon != 0) {
            this.destroyCIcon(this.labelCIcon);
        }
        this.labelCIcon = 0;
        ControlButtonContentInfo inContent = new ControlButtonContentInfo();
        if (this.text.length() > 0) {
            Font font = this.parent.getFont();
            GC gc = new GC(this.parent);
            int flags = 15;
            org.eclipse.swt.graphics.Point size = gc.textExtent(this.text, flags);
            gc.dispose();
            Image image = new Image((Device)this.display, size.x, size.y);
            gc = new GC(image);
            Color foreground = this.parent.getForeground();
            gc.setForeground(foreground);
            gc.setFont(font);
            gc.drawText(this.text, 0, 0, flags);
            gc.dispose();
            ImageData data = image.getImageData();
            data.transparentPixel = 0xFFFFFF;
            image.dispose();
            image = new Image((Device)this.display, data, data.getTransparencyMask());
            this.labelCIcon = this.createCIcon(image);
            image.dispose();
            inContent.contentType = (short)130;
            inContent.iconRef = this.labelCIcon;
        }
        OS.SetBevelButtonContentInfo((int)this.labelHandle, (ControlButtonContentInfo)inContent);
        this.redrawWidget(this.labelHandle, false);
        org.eclipse.swt.graphics.Point size = this.computeSize();
        this.setSize(size.x, size.y, true);
    }
}

