/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.EventRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.carbon.TXNBackground;
import org.eclipse.swt.internal.carbon.TXNLongRect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Text
extends Scrollable {
    int txnObject;
    int txnFrameID;
    int textLimit = LIMIT;
    char echoCharacter;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\r";
    static final char PASSWORD = '\u00a5';

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        int charCount;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, charCount = this.getCharCount(), charCount, null)) == null) {
            return;
        }
        this.setTXNText(Integer.MAX_VALUE, Integer.MAX_VALUE, string);
        OS.TXNSetSelection((int)this.txnObject, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
        OS.TXNShowSelection((int)this.txnObject, (boolean)false);
        if (string.length() != 0) {
            this.sendEvent(24);
        }
    }

    static int checkStyle(int style) {
        if ((style & 4) != 0 && (style & 2) != 0) {
            style &= 0xFFFFFFFD;
        }
        if (((style = Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection((int)this.txnObject, (int[])oStartOffset, (int[])oEndOffset);
        OS.TXNSetSelection((int)this.txnObject, (int)oStartOffset[0], (int)oStartOffset[0]);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        TXNLongRect oTextRect = new TXNLongRect();
        OS.TXNGetRectBounds((int)this.txnObject, null, null, (TXNLongRect)oTextRect);
        int width = oTextRect.right - oTextRect.left;
        int height = oTextRect.bottom - oTextRect.top;
        if (width <= 0) {
            width = 64;
        }
        if (height <= 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int ptr = OS.NewPtr((int)8);
        OS.TXNGetTXNObjectControls((int)this.txnObject, (int)1, (int[])new int[]{1835102823}, (int[])new int[]{ptr});
        Rect rect = new Rect();
        OS.memcpy((Rect)rect, (int)ptr, (int)8);
        OS.DisposePtr((int)ptr);
        width += rect.left + rect.right;
        height += rect.top + rect.bottom;
        int[] size = new int[1];
        OS.GetThemeMetric((int)0, (int[])size);
        if (this.horizontalBar != null) {
            height += size[0];
        }
        if (this.verticalBar != null) {
            width += size[0];
        }
        Rect inset = this.inset();
        return new Rectangle(x -= inset.left, y -= inset.top, width += inset.left + inset.right, height += inset.top + inset.bottom);
    }

    public void copy() {
        this.checkWidget();
        OS.TXNCopy((int)this.txnObject);
    }

    void createHandle() {
        int features = 262;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)this.parent.handle);
        OS.CreateUserPaneControl((int)window, null, (int)features, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        int[] theRoot = new int[1];
        OS.GetRootControl((int)window, (int[])theRoot);
        short[] oldCount = new short[1];
        OS.CountSubControls((int)theRoot[0], (short[])oldCount);
        int iFrameOptions = 135168;
        if ((this.style & 0x100) != 0) {
            iFrameOptions |= 4;
        }
        if ((this.style & 0x200) != 0) {
            iFrameOptions |= 8;
        }
        if ((this.style & 4) != 0) {
            iFrameOptions |= 0x4000;
        }
        if ((this.style & 0x40) != 0) {
            iFrameOptions |= 0x800;
        }
        int[] oTXNObject = new int[1];
        int[] oTXNFrameID = new int[1];
        OS.TXNNewObject((int)0, (int)window, null, (int)iFrameOptions, (int)1, (int)1970567284, (int)0, (int[])oTXNObject, (int[])oTXNFrameID, (int)0);
        if (oTXNObject[0] == 0) {
            this.error(2);
        }
        this.txnObject = oTXNObject[0];
        this.txnFrameID = oTXNFrameID[0];
        short[] newCount = new short[1];
        OS.CountSubControls((int)theRoot[0], (short[])newCount);
        int[] scrollBar = new int[1];
        int i = newCount[0];
        while (i > oldCount[0]) {
            OS.GetIndexedSubControl((int)theRoot[0], (short)((short)i), (int[])scrollBar);
            OS.HIViewRemoveFromSuperview((int)scrollBar[0]);
            OS.HIViewAddSubview((int)this.handle, (int)scrollBar[0]);
            --i;
        }
        int ptr = OS.NewPtr((int)8);
        Rect rect = new Rect();
        if (this.hasBorder()) {
            OS.SetRect((Rect)rect, (short)1, (short)1, (short)1, (short)1);
        }
        OS.memcpy((int)ptr, (Rect)rect, (int)8);
        int[] tags = new int[]{1685217639, 1768910966, 1835102823};
        int[] datas = new int[]{1, (this.style & 8) != 0 ? 1 : 0, ptr};
        OS.TXNSetTXNObjectControls((int)this.txnObject, (boolean)false, (int)tags.length, (int[])tags, (int[])datas);
        OS.TXNSetFrameBounds((int)this.txnObject, (int)0, (int)0, (int)0, (int)0, (int)this.txnFrameID);
        OS.DisposePtr((int)ptr);
        char[] buffer = new char[]{' '};
        OS.TXNSetData((int)this.txnObject, (int)1970567284, (char[])buffer, (int)2, (int)0, (int)Integer.MAX_VALUE);
        OS.TXNSetData((int)this.txnObject, (int)1970567284, (char[])buffer, (int)0, (int)0, (int)Integer.MAX_VALUE);
    }

    ScrollBar createScrollBar(int style) {
        return this.createStandardBar(style);
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x400000) != 0) {
            this.setEchoChar('\u00a5');
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean cut = true;
        org.eclipse.swt.graphics.Point oldSelection = this.getSelection();
        if ((this.hooks(25) || this.filters(25)) && oldSelection.x != oldSelection.y) {
            String newText = this.verifyText("", oldSelection.x, oldSelection.y, null);
            if (newText == null) {
                return;
            }
            if (newText.length() != 0) {
                this.setTXNText(-1, -1, newText);
                OS.TXNShowSelection((int)this.txnObject, (boolean)false);
                cut = false;
            }
        }
        if (cut) {
            OS.TXNCut((int)this.txnObject);
            if (OS.TXNDataSize((int)this.txnObject) / 2 == 0) {
                this.setFontStyle(this.font);
            }
        }
        org.eclipse.swt.graphics.Point newSelection = this.getSelection();
        if (!cut || !oldSelection.equals(newSelection)) {
            this.sendEvent(24);
        }
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    void drawBackground(int control) {
        this.drawFocus(control, this.hasFocus() && this.drawFocusRing(), this.hasBorder(), this.getParentBackground(), this.inset());
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
        OS.TXNDraw((int)this.txnObject, (int)0);
        super.drawWidget(control, damageRgn, visibleRgn, theEvent);
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return (this.getTopPixel() + this.getCaretLocation().y) / this.getLineHeight();
    }

    public org.eclipse.swt.graphics.Point getCaretLocation() {
        this.checkWidget();
        Point oPoint = new Point();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection((int)this.txnObject, (int[])oStartOffset, (int[])oEndOffset);
        OS.TXNOffsetToPoint((int)this.txnObject, (int)oStartOffset[0], (Point)oPoint);
        Rect oViewRect = new Rect();
        OS.TXNGetViewRect((int)this.txnObject, (Rect)oViewRect);
        return new org.eclipse.swt.graphics.Point(oPoint.h - oViewRect.left, oPoint.v - oViewRect.top);
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection((int)this.txnObject, (int[])oStartOffset, (int[])oEndOffset);
        return oStartOffset[0];
    }

    public int getCharCount() {
        this.checkWidget();
        return OS.TXNDataSize((int)this.txnObject) / 2;
    }

    String getClipboardText() {
        int[] scrap = new int[1];
        OS.GetCurrentScrap((int[])scrap);
        int[] size = new int[1];
        if (OS.GetScrapFlavorSize((int)scrap[0], (int)0x54455854, (int[])size) != 0 || size[0] == 0) {
            return "";
        }
        byte[] buffer = new byte[size[0]];
        if (OS.GetScrapFlavorData((int)scrap[0], (int)0x54455854, (int[])size, (byte[])buffer) != 0) {
            return "";
        }
        int encoding = OS.CFStringGetSystemEncoding();
        int cfstring = OS.CFStringCreateWithBytes((int)0, (byte[])buffer, (int)buffer.length, (int)encoding, (boolean)true);
        if (cfstring == 0) {
            return "";
        }
        String string = "";
        int length = OS.CFStringGetLength((int)cfstring);
        if (length != 0) {
            char[] chars = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters((int)cfstring, (CFRange)range, (char[])chars);
            string = new String(chars);
        }
        OS.CFRelease((int)cfstring);
        return string;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return true;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoCharacter;
    }

    public boolean getEditable() {
        this.checkWidget();
        return (this.style & 8) == 0;
    }

    public int getLineCount() {
        this.checkWidget();
        int[] oLineTotal = new int[1];
        OS.TXNGetLineCount((int)this.txnObject, (int[])oLineTotal);
        return oLineTotal[0];
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        int[] oLineWidth = new int[1];
        int[] oLineHeight = new int[1];
        OS.TXNGetLineMetrics((int)this.txnObject, (int)0, (int[])oLineWidth, (int[])oLineHeight);
        return OS.Fix2Long((int)oLineHeight[0]);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public org.eclipse.swt.graphics.Point getSelection() {
        this.checkWidget();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection((int)this.txnObject, (int[])oStartOffset, (int[])oEndOffset);
        return new org.eclipse.swt.graphics.Point(oStartOffset[0], oEndOffset[0]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] oStartOffset = new int[1];
        int[] oEndOffset = new int[1];
        OS.TXNGetSelection((int)this.txnObject, (int[])oStartOffset, (int[])oEndOffset);
        return oEndOffset[0] - oStartOffset[0];
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.getTXNText(-1, -1);
    }

    public int getTabs() {
        this.checkWidget();
        return 8;
    }

    public String getText() {
        this.checkWidget();
        return this.getTXNText(0, Integer.MAX_VALUE);
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        int length = OS.TXNDataSize((int)this.txnObject) / 2;
        start = Math.max(0, start);
        end = Math.min(end, length - 1);
        return this.getTXNText(start, end + 1);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return this.getTopPixel() / this.getLineHeight();
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        Rect oViewRect = new Rect();
        TXNLongRect oDestinationRect = new TXNLongRect();
        TXNLongRect oTextRect = new TXNLongRect();
        OS.TXNGetRectBounds((int)this.txnObject, (Rect)oViewRect, (TXNLongRect)oDestinationRect, (TXNLongRect)oTextRect);
        return oDestinationRect.top - oTextRect.top;
    }

    String getTXNText(int iStartOffset, int iEndOffset) {
        int[] oDataHandle = new int[1];
        OS.TXNGetData((int)this.txnObject, (int)iStartOffset, (int)iEndOffset, (int[])oDataHandle);
        if (oDataHandle[0] == 0) {
            return "";
        }
        int length = OS.GetHandleSize((int)oDataHandle[0]);
        if (length == 0) {
            return "";
        }
        int[] ptr = new int[1];
        OS.HLock((int)oDataHandle[0]);
        OS.memcpy((int[])ptr, (int)oDataHandle[0], (int)4);
        char[] buffer = new char[length / 2];
        OS.memcpy((char[])buffer, (int)ptr[0], (int)length);
        OS.HUnlock((int)oDataHandle[0]);
        OS.DisposeHandle((int)oDataHandle[0]);
        return new String(buffer);
    }

    Rect inset() {
        Rect rect = new Rect();
        int[] outMetric = new int[1];
        if (this.drawFocusRing()) {
            OS.GetThemeMetric((int)7, (int[])outMetric);
            rect.left = (short)(rect.left + outMetric[0]);
            rect.top = (short)(rect.top + outMetric[0]);
            rect.right = (short)(rect.right + outMetric[0]);
            rect.bottom = (short)(rect.bottom + outMetric[0]);
        }
        if (this.hasBorder()) {
            OS.GetThemeMetric((int)5, (int[])outMetric);
            rect.left = (short)(rect.left + outMetric[0]);
            rect.top = (short)(rect.top + outMetric[0]);
            rect.right = (short)(rect.right + outMetric[0]);
            rect.bottom = (short)(rect.bottom + outMetric[0]);
        }
        return rect;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            org.eclipse.swt.graphics.Point selection = this.getSelection();
            if ((string = this.verifyText(string, selection.x, selection.y, null)) == null) {
                return;
            }
        }
        this.setTXNText(-1, -1, string);
        OS.TXNShowSelection((int)this.txnObject, (boolean)false);
        if (string.length() != 0) {
            this.sendEvent(24);
        }
    }

    int kEventControlActivate(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlActivate(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        OS.TXNFocus((int)this.txnObject, (boolean)this.hasFocus());
        OS.TXNActivate((int)this.txnObject, (int)this.txnFrameID, (boolean)true);
        return result;
    }

    int kEventControlBoundsChanged(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlBoundsChanged(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] attributes = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1635021938, (int)1835100014, null, (int)(attributes.length * 4), null, (int[])attributes);
        if ((attributes[0] & 0xC) != 0) {
            this.setTXNBounds();
        }
        return result;
    }

    int kEventControlClick(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlClick(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (!this.isEnabled()) {
            return 0;
        }
        int window = OS.GetControlOwner((int)this.handle);
        OS.SetKeyboardFocus((int)window, (int)this.handle, (short)-1);
        EventRecord iEvent = new EventRecord();
        OS.ConvertEventRefToEventRecord((int)theEvent, (EventRecord)iEvent);
        OS.TXNClick((int)this.txnObject, (EventRecord)iEvent);
        return 0;
    }

    int kEventControlDeactivate(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlDeactivate(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        OS.TXNFocus((int)this.txnObject, (boolean)this.hasFocus());
        OS.TXNActivate((int)this.txnObject, (int)this.txnFrameID, (boolean)false);
        return result;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetCursor(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        OS.TXNAdjustCursor((int)this.txnObject, (int)0);
        return 0;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        short[] part = new short[1];
        OS.GetEventParameter((int)theEvent, (int)1668313716, (int)1668313716, null, (int)2, null, (short[])part);
        this.drawFocusClipped(this.handle, part[0] != 0 && this.drawFocusRing(), this.hasBorder(), this.getParentBackground(), this.inset());
        OS.TXNDraw((int)this.txnObject, (int)0);
        OS.TXNFocus((int)this.txnObject, (part[0] != 0 ? 1 : 0) != 0);
        return 0;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int[] keyCode;
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1953721189, (int)1702261350, null, (int)(keyboardEvent.length * 4), null, (int[])keyboardEvent);
        int[] modifiers = new int[1];
        OS.GetEventParameter((int)keyboardEvent[0], (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
        if (modifiers[0] == 256) {
            keyCode = new int[1];
            OS.GetEventParameter((int)keyboardEvent[0], (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
            switch (keyCode[0]) {
                case 7: {
                    this.cut();
                    return 0;
                }
                case 8: {
                    this.copy();
                    return 0;
                }
                case 9: {
                    this.paste();
                    return 0;
                }
            }
        }
        if ((this.style & 4) != 0) {
            keyCode = new int[1];
            OS.GetEventParameter((int)keyboardEvent[0], (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
            switch (keyCode[0]) {
                case 36: {
                    this.postEvent(14);
                    return 0;
                }
                case 48: {
                    return 0;
                }
            }
        }
        return result;
    }

    public void paste() {
        String oldText;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean paste = true;
        if ((this.hooks(25) || this.filters(25)) && (oldText = this.getClipboardText()) != null) {
            org.eclipse.swt.graphics.Point selection = this.getSelection();
            String newText = this.verifyText(oldText, selection.x, selection.y, null);
            if (newText == null) {
                return;
            }
            if (!newText.equals(oldText)) {
                this.setTXNText(-1, -1, newText);
                OS.TXNShowSelection((int)this.txnObject, (boolean)false);
                paste = false;
            }
        }
        if (paste) {
            OS.TXNPaste((int)this.txnObject);
        }
        this.sendEvent(24);
    }

    void releaseWidget() {
        super.releaseWidget();
        OS.TXNDeleteObject((int)this.txnObject);
        this.txnFrameID = 0;
        this.txnObject = 0;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    void resetVisibleRegion(int control) {
        super.resetVisibleRegion(control);
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        Rect inset = this.inset();
        rect.left = (short)(rect.left + inset.left);
        rect.top = (short)(rect.top + inset.top);
        rect.right = (short)(rect.right - inset.right);
        rect.bottom = OS.IsControlVisible((int)this.handle) ? (short)(rect.bottom - inset.bottom) : rect.top;
        OS.TXNSetFrameBounds((int)this.txnObject, (int)rect.top, (int)rect.left, (int)rect.bottom, (int)rect.right, (int)this.txnFrameID);
    }

    public void selectAll() {
        this.checkWidget();
        OS.TXNSelectAll((int)this.txnObject);
    }

    boolean sendKeyEvent(int type, Event event) {
        String newText;
        if (!super.sendKeyEvent(type, event)) {
            return false;
        }
        if (type != 1) {
            return true;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        String oldText = "";
        int charCount = this.getCharCount();
        org.eclipse.swt.graphics.Point selection = this.getSelection();
        int start = selection.x;
        int end = selection.y;
        switch (event.character) {
            case '\b': {
                if (start != end) break;
                if (start == 0) {
                    return true;
                }
                start = Math.max(0, start - 1);
                break;
            }
            case '\u007f': {
                if (start != end) break;
                if (start == charCount) {
                    return true;
                }
                end = Math.min(end + 1, charCount);
                break;
            }
            case '\r': {
                if ((this.style & 4) != 0) {
                    return true;
                }
                oldText = DELIMITER;
                break;
            }
            default: {
                if (event.character != '\t' && event.character < ' ') {
                    return true;
                }
                oldText = new String(new char[]{event.character});
            }
        }
        if ((newText = this.verifyText(oldText, start, end, event)) == null) {
            return false;
        }
        if (charCount - (end - start) + newText.length() > this.textLimit) {
            return false;
        }
        if (newText != oldText) {
            this.setTXNText(start, end, newText);
        }
        this.postEvent(24);
        return newText == oldText;
    }

    void setBackground(float[] color) {
        TXNBackground txnColor = new TXNBackground();
        txnColor.bgType = 1;
        short red = (short)(color == null ? 255.0f : color[0] * 255.0f);
        short green = (short)(color == null ? 255.0f : color[1] * 255.0f);
        short blue = (short)(color == null ? 255.0f : color[2] * 255.0f);
        txnColor.bg_red = (short)(red << 8 | red);
        txnColor.bg_green = (short)(green << 8 | green);
        txnColor.bg_blue = (short)(blue << 8 | blue);
        OS.TXNSetBackground((int)this.txnObject, (TXNBackground)txnColor);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if ((result & 0xC0) != 0) {
            this.setTXNBounds();
        }
        return result;
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.echoCharacter = echo;
        OS.TXNEchoMode((int)this.txnObject, (char)echo, (int)0, (echo != '\u0000' ? 1 : 0) != 0);
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style = editable ? (this.style &= 0xFFFFFFF7) : (this.style |= 8);
        OS.TXNSetTXNObjectControls((int)this.txnObject, (boolean)false, (int)1, (int[])new int[]{1768910966}, (int[])new int[]{(this.style & 8) != 0 ? 1 : 0});
    }

    void setForeground(float[] color) {
        int ptr2 = OS.NewPtr((int)6);
        RGBColor rgb = color == null ? new RGBColor() : this.toRGBColor(color);
        OS.memcpy((int)ptr2, (RGBColor)rgb, (int)6);
        int[] attribs = new int[]{1802268530, 6, ptr2};
        int ptr1 = OS.NewPtr((int)(attribs.length * 4));
        OS.memcpy((int)ptr1, (int[])attribs, (int)(attribs.length * 4));
        OS.TXNSetTypeAttributes((int)this.txnObject, (int)(attribs.length / 3), (int)ptr1, (int)0, (int)0);
        OS.DisposePtr((int)ptr1);
        OS.DisposePtr((int)ptr2);
    }

    void setFontStyle(Font font) {
        int[] attribs = new int[]{1936292453, 2, font == null ? 786432 : OS.X2Fix((double)font.size), 1717658469, 2, font == null ? (short)0 : font.style, 1718578804, 2, font == null ? (short)0 : font.id};
        int ptr = OS.NewPtr((int)(attribs.length * 4));
        OS.memcpy((int)ptr, (int[])attribs, (int)(attribs.length * 4));
        boolean readOnly = (this.style & 8) != 0;
        int[] tag = new int[]{1768910966};
        if (readOnly) {
            OS.TXNSetTXNObjectControls((int)this.txnObject, (boolean)false, (int)1, (int[])tag, (int[])new int[1]);
        }
        OS.TXNSetTypeAttributes((int)this.txnObject, (int)(attribs.length / 3), (int)ptr, (int)0, (int)0);
        if (readOnly) {
            OS.TXNSetTXNObjectControls((int)this.txnObject, (boolean)false, (int)1, (int[])tag, (int[])new int[]{1});
        }
        OS.DisposePtr((int)ptr);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(int start) {
        this.checkWidget();
        this.setSelection(start, start);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        int length = OS.TXNDataSize((int)this.txnObject) / 2;
        int nStart = Math.min(Math.max(Math.min(start, end), 0), length);
        int nEnd = Math.min(Math.max(Math.max(start, end), 0), length);
        OS.TXNSetSelection((int)this.txnObject, (int)nStart, (int)nEnd);
        OS.TXNShowSelection((int)this.txnObject, (boolean)false);
    }

    public void setSelection(org.eclipse.swt.graphics.Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        this.setTXNText(0, Integer.MAX_VALUE, string);
        OS.TXNSetSelection((int)this.txnObject, (int)0, (int)0);
        OS.TXNShowSelection((int)this.txnObject, (boolean)false);
        this.sendEvent(24);
    }

    void setTXNBounds() {
        Rect viewRect = new Rect();
        OS.TXNGetViewRect((int)this.txnObject, (Rect)viewRect);
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        Rect inset = this.inset();
        rect.left = (short)(rect.left + inset.left);
        rect.top = (short)(rect.top + inset.top);
        rect.right = (short)(rect.right - inset.right);
        rect.bottom = (short)(rect.bottom - inset.bottom);
        OS.TXNSetFrameBounds((int)this.txnObject, (int)rect.top, (int)rect.left, (int)rect.bottom, (int)rect.right, (int)this.txnFrameID);
        int width = viewRect.left - viewRect.right;
        int height = viewRect.bottom - viewRect.top;
        if (width <= inset.left + inset.right && height <= inset.top + inset.bottom) {
            int[] oStartOffset = new int[1];
            int[] oEndOffset = new int[1];
            OS.TXNGetSelection((int)this.txnObject, (int[])oStartOffset, (int[])oEndOffset);
            OS.TXNSetSelection((int)this.txnObject, (int)0, (int)0);
            OS.TXNShowSelection((int)this.txnObject, (boolean)false);
            OS.TXNSetSelection((int)this.txnObject, (int)oStartOffset[0], (int)oEndOffset[0]);
            OS.TXNShowSelection((int)this.txnObject, (boolean)false);
        }
    }

    void setTXNText(int iStartOffset, int iEndOffset, String string) {
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        boolean readOnly = (this.style & 8) != 0;
        int[] tag = new int[]{1768910966};
        if (readOnly) {
            OS.TXNSetTXNObjectControls((int)this.txnObject, (boolean)false, (int)1, (int[])tag, (int[])new int[1]);
        }
        OS.TXNSetData((int)this.txnObject, (int)1970567284, (char[])buffer, (int)(buffer.length * 2), (int)iStartOffset, (int)iEndOffset);
        if (readOnly) {
            OS.TXNSetTXNObjectControls((int)this.txnObject, (boolean)false, (int)1, (int[])tag, (int[])new int[]{1});
        }
        if (OS.TXNDataSize((int)this.txnObject) / 2 == 0) {
            this.setFontStyle(this.font);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        this.textLimit = limit;
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
    }

    public void showSelection() {
        this.checkWidget();
        OS.TXNShowSelection((int)this.txnObject, (boolean)false);
    }

    int traversalCode(int key, int theEvent) {
        int bits = super.traversalCode(key, theEvent);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 48 && theEvent != 0) {
                boolean next;
                int[] modifiers = new int[1];
                OS.GetEventParameter((int)theEvent, (int)1802334052, (int)1835100014, null, (int)4, null, (int[])modifiers);
                boolean bl = next = (modifiers[0] & 0x200) == 0;
                if (next && (modifiers[0] & 0x1000) == 0) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    String verifyText(String string, int start, int end, Event keyEvent) {
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        if (keyEvent != null) {
            event.character = keyEvent.character;
            event.keyCode = keyEvent.keyCode;
            event.stateMask = keyEvent.stateMask;
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

