/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    Color foreground;
    Color background;
    Color[] cellForeground;
    Color[] cellBackground;
    Font font;
    Font[] cellFont;
    int width = -1;

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount(), true);
    }

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, true);
    }

    TableItem(Table parent, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, index);
        }
    }

    static Table checkNull(Table control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    int calculateWidth(int index, GC gc) {
        if (index == 0 && this.width != -1) {
            return this.width;
        }
        int width = 0;
        Image image = this.getImage(index);
        String text = this.getText(index);
        if (image != null) {
            width += image.getBounds().width + 2;
        }
        if (text != null && text.length() > 0) {
            width += gc.stringExtent((String)text).x;
        }
        if (index == 0) {
            this.width = width;
        }
        return width;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.cached = false;
        this.grayed = false;
        this.checked = false;
        this.background = null;
        this.foreground = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.font = null;
        this.cellFont = null;
        this.width = -1;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[index] == null) {
            return this.getBackground();
        }
        return this.cellBackground[index];
    }

    public Rectangle getBounds(int index) {
        int columnId;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        this.parent.checkItems(true);
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int itemIndex = this.parent.indexOf(this);
        int id = itemIndex + 1;
        int n = columnId = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[index].id;
        if (OS.GetDataBrowserItemPartBounds((int)this.parent.handle, (int)id, (int)columnId, (int)0, (Rect)rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect2 = new Rect();
        if (OS.GetDataBrowserItemPartBounds((int)this.parent.handle, (int)id, (int)columnId, (int)0x2D2D2D2D, (Rect)rect2) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = rect2.left;
        int y = rect2.top;
        int width = rect.right - rect2.left;
        int height = rect2.bottom - rect2.top;
        OS.GetControlBounds((int)this.parent.handle, (Rect)rect);
        return new Rectangle(x -= rect.left, y -= rect.top, width + 1, height + 1);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[index] == null) {
            return this.getForeground();
        }
        return this.cellForeground[index];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getImage();
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        Rectangle bounds;
        int columnId;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        this.parent.checkItems(true);
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rect rect = new Rect();
        int itemIndex = this.parent.indexOf(this);
        int id = itemIndex + 1;
        int n = columnId = this.parent.columnCount == 0 ? this.parent.column_id : this.parent.columns[index].id;
        if (OS.GetDataBrowserItemPartBounds((int)this.parent.handle, (int)id, (int)columnId, (int)0x2D2D2D2D, (Rect)rect) != 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = rect.left;
        int y = rect.top;
        int width = 0;
        if (index == 0 && this.image != null) {
            bounds = this.image.getBounds();
            width += bounds.width;
        }
        if (index != 0 && this.images != null && this.images[index] != null) {
            bounds = this.images[index].getBounds();
            width += bounds.width;
        }
        int height = rect.bottom - rect.top + 1;
        OS.GetControlBounds((int)this.parent.handle, (Rect)rect);
        return new Rectangle(x -= rect.left, y -= rect.top, width, height);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return 0;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getText();
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            String string = this.strings[index];
            return string != null ? string : "";
        }
        return "";
    }

    void redraw(int propertyID) {
        this.cached = true;
        if (this.parent.currentItem == this) {
            return;
        }
        if (this.parent.drawCount != 0 && propertyID != 1024) {
            return;
        }
        int itemIndex = this.parent.indexOf(this);
        int[] id = new int[]{itemIndex + 1};
        OS.UpdateDataBrowserItems((int)this.parent.handle, (int)0, (int)id.length, (int[])id, (int)0, (int)propertyID);
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.strings = null;
        this.images = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.background == color) {
            return;
        }
        if (this.background != null && this.background.equals(color)) {
            return;
        }
        this.background = color;
        this.redraw(0);
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new Color[count];
        }
        if (this.cellBackground[index] == color) {
            return;
        }
        if (this.cellBackground[index] != null && this.cellBackground[index].equals(color)) {
            return;
        }
        this.cellBackground[index] = color;
        this.redraw(0);
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.checked = checked;
        this.redraw(1024);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (this.font != null && this.font.equals(font)) {
            return;
        }
        this.font = font;
        this.redraw(0);
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            this.cellFont = new Font[count];
        }
        if (this.cellFont[index] == font) {
            return;
        }
        if (this.cellFont[index] != null && this.cellFont[index].equals(font)) {
            return;
        }
        this.cellFont[index] = font;
        this.redraw(0);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (this.foreground == color) {
            return;
        }
        if (this.foreground != null && this.foreground.equals(color)) {
            return;
        }
        this.foreground = color;
        this.redraw(0);
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new Color[count];
        }
        if (this.cellForeground[index] == color) {
            return;
        }
        if (this.cellForeground[index] != null && this.cellForeground[index].equals(color)) {
            return;
        }
        this.cellForeground[index] = color;
        this.redraw(0);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        this.redraw(1024);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        int itemIndex;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((itemIndex = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.parent.imageBounds == null && image != null) {
            this.parent.setItemHeight(image);
        }
        if (index == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            this.width = -1;
            super.setImage(image);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index >= 0 && index < count) {
            if (this.images == null) {
                this.images = new Image[count];
            }
            if (image != null && image.type == 1 && image.equals(this.images[index])) {
                return;
            }
            this.images[index] = image;
        }
        if (index == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(0);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int indent) {
        this.checkWidget();
        if (indent < 0) {
            return;
        }
        this.redraw(0);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == 0) {
            if (string.equals(this.text)) {
                return;
            }
            this.width = -1;
            super.setText(string);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index >= 0 && index < count) {
            if (this.strings == null) {
                this.strings = new String[count];
            }
            if (string.equals(this.strings[index])) {
                return;
            }
            this.strings[index] = string;
        }
        if (index == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(0);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

