/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    int shellHandle;
    int windowGroup;
    boolean resized;
    boolean moved;
    boolean drawing;
    boolean reshape;
    boolean update;
    boolean activate;
    boolean disposed;
    boolean opened;
    int invalRgn;
    Control lastActive;
    Region region;
    Rect rgnRect;
    static int DEFAULT_CLIENT_WIDTH = -1;
    static int DEFAULT_CLIENT_HEIGHT = -1;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0);
    }

    Shell(Display display, Shell parent, int style, int handle) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Shell.checkStyle(style);
        this.parent = parent;
        this.display = display;
        this.handle = handle;
        this.createWidget();
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0);
    }

    static int checkStyle(int style) {
        style = Decorations.checkStyle(style);
        int mask = 229376;
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(26, typedListener);
        this.addListener(21, typedListener);
        this.addListener(27, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
    }

    void bringToTop(boolean force) {
        if (this.getMinimized()) {
            return;
        }
        if (force) {
            this.forceActive();
        } else {
            this.setActive();
        }
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        Rect rect = new Rect();
        OS.GetWindowStructureWidths((int)this.shellHandle, (Rect)rect);
        trim.x -= rect.left;
        trim.y -= rect.top;
        trim.width += rect.left + rect.right;
        trim.height += rect.top + rect.bottom;
        return trim;
    }

    void createHandle() {
        this.state |= 0x32;
        int attributes = 0x2000000;
        if ((this.style & 8) == 0) {
            if ((this.style & 0x40) != 0) {
                attributes |= 1;
            }
            if ((this.style & 0x80) != 0) {
                attributes |= 8;
            }
            if ((this.style & 0x400) != 0) {
                attributes |= 6;
            }
            if ((this.style & 0x10) != 0) {
                attributes |= 0x10;
                if ((this.style & 0x20) == 0) {
                    attributes |= 0x10000000;
                }
            }
        }
        int windowClass = 6;
        if ((this.style & 0x60) == 0) {
            windowClass = 11;
        }
        Monitor monitor = this.getMonitor();
        Rectangle rect = monitor.getClientArea();
        int width = rect.width * 5 / 8;
        int height = rect.height * 5 / 8;
        Rect bounds = new Rect();
        OS.SetRect((Rect)bounds, (short)0, (short)0, (short)((short)width), (short)((short)height));
        int[] outWindow = new int[1];
        OS.CreateNewWindow((int)windowClass, (int)(attributes &= OS.GetAvailableWindowAttributes((int)windowClass)), (Rect)bounds, (int[])outWindow);
        if (outWindow[0] == 0) {
            this.error(2);
        }
        this.shellHandle = outWindow[0];
        OS.RepositionWindow((int)this.shellHandle, (int)0, (int)4);
        int[] theRoot = new int[1];
        OS.CreateRootControl((int)this.shellHandle, (int[])theRoot);
        OS.GetRootControl((int)this.shellHandle, (int[])theRoot);
        if (theRoot[0] == 0) {
            this.error(2);
        }
        if ((this.style & 0x300) != 0) {
            this.createScrolledHandle(theRoot[0]);
        } else {
            this.createHandle(theRoot[0]);
        }
        OS.SetControlVisibility((int)this.topHandle(), (boolean)false, (boolean)false);
        int[] outGroup = new int[1];
        OS.CreateWindowGroup((int)16, (int[])outGroup);
        if (outGroup[0] == 0) {
            this.error(2);
        }
        this.windowGroup = outGroup[0];
        if (this.parent != null) {
            Shell shell = this.parent.getShell();
            int parentGroup = shell.windowGroup;
            OS.SetWindowGroup((int)this.shellHandle, (int)parentGroup);
            OS.SetWindowGroupParent((int)this.windowGroup, (int)parentGroup);
        } else {
            int parentGroup = OS.GetWindowGroupOfClass((int)windowClass);
            OS.SetWindowGroupParent((int)this.windowGroup, (int)parentGroup);
        }
        OS.SetWindowGroupOwner((int)this.windowGroup, (int)this.shellHandle);
        CGPoint inMinLimits = new CGPoint();
        CGPoint inMaxLimits = new CGPoint();
        OS.GetWindowResizeLimits((int)this.shellHandle, (CGPoint)inMinLimits, (CGPoint)inMaxLimits);
        if (DEFAULT_CLIENT_WIDTH == -1) {
            DEFAULT_CLIENT_WIDTH = (int)inMinLimits.x;
        }
        if (DEFAULT_CLIENT_HEIGHT == -1) {
            DEFAULT_CLIENT_HEIGHT = 0;
        }
        inMinLimits.y = 0.0f;
        int trim = 1248;
        if ((this.style & 8) != 0 || (this.style & trim) == 0) {
            inMinLimits.x = 0.0f;
        }
        OS.SetWindowResizeLimits((int)this.shellHandle, (CGPoint)inMinLimits, (CGPoint)inMaxLimits);
    }

    void createWidget() {
        super.createWidget();
        this.resizeBounds();
    }

    void deregister() {
        super.deregister();
        int[] theRoot = new int[1];
        OS.GetRootControl((int)this.shellHandle, (int[])theRoot);
        this.display.removeWidget(theRoot[0]);
    }

    void destroyWidget() {
        int theWindow = this.shellHandle;
        this.releaseHandle();
        if (theWindow != 0) {
            OS.DisposeWindow((int)theWindow);
        }
    }

    void drawWidget(int control, int damageRgn, int visibleRgn, int theEvent) {
        super.drawWidget(control, damageRgn, visibleRgn, theEvent);
        if (this.region == null || this.region.isDisposed()) {
            return;
        }
        boolean origin = this.region.contains(0, 0);
        boolean limit = this.region.contains(this.rgnRect.right - 1, this.rgnRect.bottom - 1);
        if (origin && limit) {
            return;
        }
        int[] context = new int[1];
        int port = OS.GetWindowPort((int)this.shellHandle);
        Rect portRect = new Rect();
        OS.GetPortBounds((int)port, (Rect)portRect);
        OS.QDBeginCGContext((int)port, (int[])context);
        OS.CGContextScaleCTM((int)context[0], (float)1.0f, (float)-1.0f);
        OS.CGContextTranslateCTM((int)context[0], (float)0.0f, (float)(portRect.top - portRect.bottom));
        CGRect cgRect = new CGRect();
        cgRect.width = 1.0f;
        cgRect.height = 1.0f;
        if (!origin) {
            OS.CGContextClearRect((int)context[0], (CGRect)cgRect);
        }
        if (!limit) {
            cgRect.x = this.rgnRect.right - 1;
            cgRect.y = this.rgnRect.bottom - 1;
            OS.CGContextClearRect((int)context[0], (CGRect)cgRect);
        }
        OS.CGContextSynchronize((int)context[0]);
        OS.QDEndCGContext((int)port, (int[])context);
    }

    Cursor findCursor() {
        return this.cursor;
    }

    public void forceActive() {
        this.checkWidget();
        if (this.activate) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        OS.SelectWindow((int)this.shellHandle);
        int[] nArray = new int[2];
        nArray[1] = 2;
        OS.SetFrontProcessWithOptions((int[])nArray, (int)1);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowBounds((int)this.shellHandle, (short)33, (Rect)rect);
        return new Rectangle(0, 0, rect.right - rect.left, rect.bottom - rect.top);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowBounds((int)this.shellHandle, (short)32, (Rect)rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    int getDrawCount(int control) {
        if (!this.isTrimHandle(control)) {
            return this.drawCount;
        }
        return 0;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public org.eclipse.swt.graphics.Point getLocation() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowBounds((int)this.shellHandle, (short)32, (Rect)rect);
        return new org.eclipse.swt.graphics.Point(rect.left, rect.top);
    }

    public boolean getMaximized() {
        this.checkWidget();
        return super.getMaximized();
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (!this.getVisible()) {
            return super.getMinimized();
        }
        return OS.IsWindowCollapsed((int)this.shellHandle);
    }

    public org.eclipse.swt.graphics.Point getMinimumSize() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowStructureWidths((int)this.shellHandle, (Rect)rect);
        CGPoint inMinLimits = new CGPoint();
        CGPoint inMaxLimits = new CGPoint();
        OS.GetWindowResizeLimits((int)this.shellHandle, (CGPoint)inMinLimits, (CGPoint)inMaxLimits);
        int width = Math.max(1, (int)inMinLimits.x + (rect.left + rect.right));
        int height = Math.max(1, (int)inMinLimits.y + (rect.top + rect.bottom));
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    float[] getParentBackground() {
        return null;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    public org.eclipse.swt.graphics.Point getSize() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowBounds((int)this.shellHandle, (short)32, (Rect)rect);
        return new org.eclipse.swt.graphics.Point(rect.right - rect.left, rect.bottom - rect.top);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.IsWindowVisible((int)this.shellHandle);
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        int mouseProc = this.display.mouseProc;
        int windowProc = this.display.windowProc;
        int[] mask1 = new int[]{2003398244, 5, 2003398244, 27, 2003398244, 72, 2003398244, 67, 2003398244, 6, 2003398244, 2, 2003398244, 70, 2003398244, 1002, 2003398244, 25, 2003398244, 1003, 2003398244, 24, 2003398244, 1};
        int windowTarget = OS.GetWindowEventTarget((int)this.shellHandle);
        OS.InstallEventHandler((int)windowTarget, (int)windowProc, (int)(mask1.length / 2), (int[])mask1, (int)this.shellHandle, null);
        int[] mask2 = new int[]{1836021107, 1, 1836021107, 6, 1836021107, 5, 1836021107, 2, 1836021107, 10};
        OS.InstallEventHandler((int)windowTarget, (int)mouseProc, (int)(mask2.length / 2), (int[])mask2, (int)this.shellHandle, null);
    }

    void invalidateVisibleRegion(int control) {
        this.resetVisibleRegion(control);
        this.invalidateChildrenVisibleRegion(control);
    }

    void invalWindowRgn(int window, int rgn) {
        if (this.update) {
            if (this.invalRgn == 0) {
                this.invalRgn = OS.NewRgn();
            }
            OS.UnionRgn((int)rgn, (int)this.invalRgn, (int)this.invalRgn);
        } else {
            OS.InvalWindowRgn((int)window, (int)rgn);
        }
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isEnabledCursor() {
        return true;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    int kEventWindowActivated(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowActivated(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] outScope = new int[1];
        OS.GetWindowActivationScope((int)this.shellHandle, (int[])outScope);
        if (outScope[0] == 0) {
            return result;
        }
        this.display.setMenuBar(this.menuBar);
        if (this.menuBar != null) {
            OS.DrawMenuBar();
        }
        this.activate = true;
        this.sendEvent(26);
        if (this.isDisposed()) {
            return result;
        }
        this.restoreFocus();
        this.activate = false;
        return result;
    }

    int kEventWindowBoundsChanged(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowBoundsChanged(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] attributes = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1635021938, (int)1835100014, null, (int)(attributes.length * 4), null, (int[])attributes);
        if ((attributes[0] & 8) != 0) {
            this.moved = true;
            this.sendEvent(10);
            if (this.isDisposed()) {
                return 0;
            }
        }
        if ((attributes[0] & 4) != 0) {
            this.resized = true;
            this.resizeBounds();
            this.sendEvent(11);
            if (this.isDisposed()) {
                return 0;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
            if (this.region != null && !this.region.isDisposed()) {
                OS.GetEventParameter((int)theEvent, (int)1668440948, (int)1902408308, null, (int)8, null, (Rect)this.rgnRect);
                OS.SetRect((Rect)this.rgnRect, (short)0, (short)0, (short)((short)(this.rgnRect.right - this.rgnRect.left)), (short)((short)(this.rgnRect.bottom - this.rgnRect.top)));
                OS.ReshapeCustomWindow((int)this.shellHandle);
            }
        }
        return result;
    }

    int kEventWindowClose(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowClose(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 0;
    }

    int kEventWindowCollapsed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowCollapsed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.minimized = true;
        this.sendEvent(19);
        return result;
    }

    int kEventWindowDeactivated(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowDeactivated(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.postEvent(27);
        if (this.isDisposed()) {
            return result;
        }
        this.saveFocus();
        if (this.savedFocus != null) {
            this.display.ignoreFocus = true;
            OS.ClearKeyboardFocus((int)this.shellHandle);
            this.display.ignoreFocus = false;
            if (!this.savedFocus.isDisposed()) {
                this.savedFocus.sendFocusEvent(16, true);
            }
        }
        this.display.setMenuBar(null);
        return result;
    }

    int kEventWindowDrawContent(int nextHandler, int theEvent, int userData) {
        this.drawing = true;
        int result = OS.CallNextEventHandler((int)nextHandler, (int)theEvent);
        this.drawing = false;
        if (this.reshape) {
            this.reshape = false;
            OS.ReshapeCustomWindow((int)this.shellHandle);
        }
        return result;
    }

    int kEventWindowExpanded(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowExpanded(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.minimized = false;
        this.sendEvent(20);
        return result;
    }

    int kEventWindowGetRegion(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowGetRegion(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (this.region == null || this.region.isDisposed()) {
            return -9874;
        }
        short[] regionCode = new short[1];
        OS.GetEventParameter((int)theEvent, (int)2004052080, (int)2004052080, null, (int)2, null, (short[])regionCode);
        int[] temp = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1919381096, (int)1919381096, null, (int)4, null, (int[])temp);
        int hRegion = temp[0];
        switch (regionCode[0]) {
            case 32: 
            case 33: {
                int rectRgn;
                Rect r;
                OS.RectRgn((int)hRegion, (Rect)this.rgnRect);
                OS.SectRgn((int)hRegion, (int)this.region.handle, (int)hRegion);
                if (!this.region.contains(0, 0)) {
                    r = new Rect();
                    OS.SetRect((Rect)r, (short)0, (short)0, (short)1, (short)1);
                    rectRgn = OS.NewRgn();
                    OS.RectRgn((int)rectRgn, (Rect)r);
                    OS.UnionRgn((int)rectRgn, (int)hRegion, (int)hRegion);
                    OS.DisposeRgn((int)rectRgn);
                }
                if (!this.region.contains(this.rgnRect.right - 1, this.rgnRect.bottom - 1)) {
                    r = new Rect();
                    OS.SetRect((Rect)r, (short)((short)(this.rgnRect.right - 1)), (short)((short)(this.rgnRect.bottom - 1)), (short)this.rgnRect.right, (short)this.rgnRect.bottom);
                    rectRgn = OS.NewRgn();
                    OS.RectRgn((int)rectRgn, (Rect)r);
                    OS.UnionRgn((int)rectRgn, (int)hRegion, (int)hRegion);
                    OS.DisposeRgn((int)rectRgn);
                }
                return 0;
            }
        }
        OS.DiffRgn((int)hRegion, (int)hRegion, (int)hRegion);
        return 0;
    }

    int kEventWindowHidden(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowHidden(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.setWindowVisible(false);
            }
            ++i;
        }
        return -9874;
    }

    int kEventWindowHitTest(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowHitTest(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (this.region == null || this.region.isDisposed()) {
            return -9874;
        }
        Point pt = new Point();
        int sizeof = 4;
        OS.GetEventParameter((int)theEvent, (int)1835822947, (int)1363439732, null, (int)sizeof, null, (Point)pt);
        Rect rect = new Rect();
        OS.GetWindowBounds((int)this.shellHandle, (short)33, (Rect)rect);
        OS.SetPt((Point)pt, (short)((short)(pt.h - rect.left)), (short)((short)(pt.v - rect.top)));
        int rgn = OS.NewRgn();
        OS.RectRgn((int)rgn, (Rect)this.rgnRect);
        OS.SectRgn((int)rgn, (int)this.region.handle, (int)rgn);
        short inData = OS.PtInRgn((Point)pt, (int)rgn) ? (short)1 : 0;
        OS.DisposeRgn((int)rgn);
        OS.SetEventParameter((int)theEvent, (int)2003071075, (int)2003071092, (int)2, (short[])new short[]{inData});
        return 0;
    }

    int kEventWindowShown(int nextHandler, int theEvent, int userData) {
        int result = super.kEventWindowShown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && shell.getVisible()) {
                shell.setWindowVisible(true);
            }
            ++i;
        }
        return -9874;
    }

    int kEventWindowUpdate(int nextHandler, int theEvent, int userData) {
        this.update = true;
        int result = OS.CallNextEventHandler((int)nextHandler, (int)theEvent);
        this.update = false;
        if (this.invalRgn != 0) {
            OS.InvalWindowRgn((int)this.shellHandle, (int)this.invalRgn);
            OS.DisposeRgn((int)this.invalRgn);
            this.invalRgn = 0;
        }
        return result;
    }

    void resizeBounds() {
        Rect rect = new Rect();
        OS.GetWindowBounds((int)this.shellHandle, (short)33, (Rect)rect);
        int control = this.scrolledHandle != 0 ? this.scrolledHandle : this.handle;
        this.setBounds(control, 0, 0, rect.right - rect.left, rect.bottom - rect.top, false, true, false);
        this.resizeClientArea();
    }

    public void open() {
        this.checkWidget();
        this.bringToTop(false);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    void register() {
        super.register();
        int[] theRoot = new int[1];
        OS.GetRootControl((int)this.shellHandle, (int[])theRoot);
        this.display.addWidget(theRoot[0], this);
    }

    void releaseChild() {
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0;
    }

    void releaseShells() {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
    }

    void releaseWidget() {
        this.disposed = true;
        this.releaseShells();
        super.releaseWidget();
        if (this.windowGroup != 0) {
            OS.ReleaseWindowGroup((int)this.windowGroup);
        }
        this.display.updateQuitMenu();
        if (this.invalRgn != 0) {
            OS.DisposeRgn((int)this.invalRgn);
        }
        this.windowGroup = 0;
        this.invalRgn = 0;
        this.lastActive = null;
        this.region = null;
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(27, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
    }

    public void setActive() {
        this.checkWidget();
        if (this.activate) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        OS.SelectWindow((int)this.shellHandle);
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                activate[i].sendEvent(26);
            }
            --i;
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        Rect rect = new Rect();
        if (!move) {
            OS.GetWindowBounds((int)this.shellHandle, (short)32, (Rect)rect);
            x = rect.left;
            y = rect.top;
        }
        if (!resize) {
            OS.GetWindowBounds((int)this.shellHandle, (short)32, (Rect)rect);
            width = rect.right - rect.left;
            height = rect.bottom - rect.top;
        } else {
            OS.GetWindowStructureWidths((int)this.shellHandle, (Rect)rect);
            CGPoint inMinLimits = new CGPoint();
            CGPoint inMaxLimits = new CGPoint();
            OS.GetWindowResizeLimits((int)this.shellHandle, (CGPoint)inMinLimits, (CGPoint)inMaxLimits);
            width = Math.max(1, Math.max(width, (int)inMinLimits.x + (rect.left + rect.right)));
            height = Math.max(1, Math.max(height, (int)inMinLimits.y + (rect.top + rect.bottom)));
        }
        OS.SetRect((Rect)rect, (short)((short)x), (short)((short)y), (short)((short)(x + width)), (short)((short)(y + height)));
        OS.SetWindowBounds((int)this.shellHandle, (int)32, (Rect)rect);
        return 0;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 == enabled) {
            return;
        }
        super.setEnabled(enabled);
        if (enabled && OS.IsWindowActive((int)this.shellHandle) && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        super.setMenuBar(menu);
        if (this.display.getActiveShell() == this) {
            this.display.setMenuBar(this.menuBar);
        }
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        Point pt = new Point();
        if (maximized) {
            Rect rect = new Rect();
            int gdevice = OS.GetMainDevice();
            OS.GetAvailableWindowPositioningBounds((int)gdevice, (Rect)rect);
            pt.h = (short)(rect.right - rect.left);
            pt.v = (short)(rect.bottom - rect.top);
        }
        short inPartCode = (short)(maximized ? 8 : 7);
        OS.ZoomWindowIdeal((int)this.shellHandle, (short)inPartCode, (Point)pt);
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (this.minimized == minimized) {
            return;
        }
        super.setMinimized(minimized);
        if (!minimized && OS.IsWindowCollapsed((int)this.shellHandle) && !this.activate) {
            OS.SelectWindow((int)this.shellHandle);
        }
        OS.CollapseWindow((int)this.shellHandle, (boolean)minimized);
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        int clientWidth = 0;
        int clientHeight = 0;
        int trim = 1248;
        if ((this.style & 8) == 0 && (this.style & trim) != 0) {
            clientWidth = DEFAULT_CLIENT_WIDTH;
            clientHeight = DEFAULT_CLIENT_HEIGHT;
        }
        Rect rect = new Rect();
        OS.GetWindowStructureWidths((int)this.shellHandle, (Rect)rect);
        CGPoint inMinLimits = new CGPoint();
        CGPoint inMaxLimits = new CGPoint();
        OS.GetWindowResizeLimits((int)this.shellHandle, (CGPoint)inMinLimits, (CGPoint)inMaxLimits);
        width = Math.max(width, clientWidth + rect.left + rect.right);
        height = Math.max(height, clientHeight + rect.top + rect.bottom);
        inMinLimits.x = width - (rect.left + rect.right);
        inMinLimits.y = height - (rect.top + rect.bottom);
        OS.SetWindowResizeLimits((int)this.shellHandle, (CGPoint)inMinLimits, (CGPoint)inMaxLimits);
        org.eclipse.swt.graphics.Point size = this.getSize();
        int newWidth = Math.max(size.x, width);
        int newHeight = Math.max(size.y, height);
        if (newWidth != size.x || newHeight != size.y) {
            this.setSize(newWidth, newHeight);
        }
    }

    public void setMinimumSize(org.eclipse.swt.graphics.Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        if (region == null) {
            this.rgnRect = null;
        } else if (this.rgnRect == null) {
            this.rgnRect = new Rect();
            OS.GetWindowBounds((int)this.shellHandle, (short)32, (Rect)this.rgnRect);
            OS.SetRect((Rect)this.rgnRect, (short)0, (short)0, (short)((short)(this.rgnRect.right - this.rgnRect.left)), (short)((short)(this.rgnRect.bottom - this.rgnRect.top)));
        }
        this.region = region;
        if (this.drawing) {
            this.reshape = true;
        } else {
            OS.ReshapeCustomWindow((int)this.shellHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        if (ptr == 0) {
            this.error(13);
        }
        OS.SetWindowTitleWithCFString((int)this.shellHandle, (int)ptr);
        OS.CFRelease((int)ptr);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        this.setWindowVisible(visible);
    }

    void setWindowVisible(boolean visible) {
        if (OS.IsWindowVisible((int)this.shellHandle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
            int inModalKind = 0;
            if ((this.style & 0x8000) != 0) {
                inModalKind = 3;
            }
            if ((this.style & 0x10000) != 0) {
                inModalKind = 2;
            }
            if ((this.style & 0x20000) != 0) {
                inModalKind = 1;
            }
            if (inModalKind != 0) {
                int inUnavailableWindow = 0;
                if (this.parent != null) {
                    inUnavailableWindow = OS.GetControlOwner((int)this.parent.handle);
                }
                OS.SetWindowModality((int)this.shellHandle, (int)inModalKind, (int)inUnavailableWindow);
            }
            int topHandle = this.topHandle();
            OS.SetControlVisibility((int)topHandle, (boolean)true, (boolean)false);
            this.invalidateVisibleRegion(topHandle);
            int[] scope = new int[1];
            if ((this.style & 0x4000) != 0) {
                OS.GetWindowActivationScope((int)this.shellHandle, (int[])scope);
                OS.SetWindowActivationScope((int)this.shellHandle, (int)0);
            }
            int shellHandle = this.shellHandle;
            OS.RetainWindow((int)shellHandle);
            OS.ShowWindow((int)shellHandle);
            OS.ReleaseWindow((int)shellHandle);
            if (!this.isDisposed()) {
                if (this.minimized != OS.IsWindowCollapsed((int)shellHandle)) {
                    OS.CollapseWindow((int)shellHandle, (boolean)this.minimized);
                }
                if ((this.style & 0x4000) != 0) {
                    OS.SetWindowActivationScope((int)shellHandle, (int)scope[0]);
                }
            }
        } else {
            if (!this.disposed) {
                OS.HideWindow((int)this.shellHandle);
            }
            int topHandle = this.topHandle();
            OS.SetControlVisibility((int)topHandle, (boolean)false, (boolean)false);
            this.invalidateVisibleRegion(topHandle);
            this.sendEvent(23);
        }
        this.display.updateQuitMenu();
    }

    void setZOrder() {
        if (this.scrolledHandle != 0) {
            OS.HIViewAddSubview((int)this.scrolledHandle, (int)this.handle);
        }
    }

    void setZOrder(Control control, boolean above) {
        if (above) {
            OS.BringToFront((int)this.shellHandle);
        } else {
            int window = control == null ? 0 : OS.GetControlOwner((int)control.handle);
            OS.SendBehind((int)this.shellHandle, (int)window);
        }
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }
}

