/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    int handle;
    int visibleRgn;
    Scrollable parent;
    boolean dragging;
    int increment = 1;
    int pageIncrement = 10;

    ScrollBar() {
    }

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    int actionProc(int theControl, int partCode) {
        Event event = new Event();
        int value = OS.GetControl32BitValue((int)this.handle);
        switch (partCode) {
            case 20: {
                value -= this.increment;
                event.detail = 0x1000001;
                break;
            }
            case 22: {
                value -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 23: {
                value += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 21: {
                value += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 129: {
                this.dragging = true;
                event.detail = 1;
                break;
            }
            default: {
                return 0;
            }
        }
        OS.SetControl32BitValue((int)this.handle, (int)value);
        this.sendEvent(13, event);
        this.parent.update(true);
        return 0;
    }

    void destroyWidget() {
        int theControl = this.handle;
        this.releaseHandle();
        if (theControl != 0) {
            OS.DisposeControl((int)theControl);
        }
    }

    void enableWidget(boolean enabled) {
        if (enabled) {
            OS.EnableControl((int)this.handle);
        } else {
            OS.DisableControl((int)this.handle);
        }
    }

    void createHandle() {
        int actionProc = this.display.actionProc;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)this.parent.scrolledHandle);
        OS.CreateScrollBarControl((int)window, null, (int)0, (int)0, (int)90, (int)10, (boolean)true, (int)actionProc, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void createWidget() {
        super.createWidget();
        this.setZOrder();
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
    }

    int getDrawCount(int control) {
        return this.parent.getDrawCount(control);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        int maximum = OS.GetControl32BitMaximum((int)this.handle) & Integer.MAX_VALUE;
        int viewSize = OS.GetControlViewSize((int)this.handle);
        return maximum + viewSize;
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.GetControl32BitMinimum((int)this.handle) & Integer.MAX_VALUE;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        return OS.GetControl32BitValue((int)this.handle) & Integer.MAX_VALUE;
    }

    public Point getSize() {
        this.checkWidget();
        Rect rect = this.getControlSize(this.handle);
        return new Point(rect.right - rect.left, rect.bottom - rect.top);
    }

    public int getThumb() {
        this.checkWidget();
        return OS.GetControlViewSize((int)this.handle);
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(control, this.visibleRgn, clipChildren);
        }
        int result = OS.NewRgn();
        OS.CopyRgn((int)this.visibleRgn, (int)result);
        return result;
    }

    void hookEvents() {
        super.hookEvents();
        int controlProc = this.display.controlProc;
        int[] mask = new int[]{1668183148, 4};
        int controlTarget = OS.GetControlEventTarget((int)this.handle);
        OS.InstallEventHandler((int)controlTarget, (int)controlProc, (int)(mask.length / 2), (int[])mask, (int)this.handle, null);
    }

    void invalidateVisibleRegion(int control) {
        this.resetVisibleRegion(control);
        this.parent.resetVisibleRegion(control);
    }

    void invalWindowRgn(int window, int rgn) {
        this.parent.invalWindowRgn(window, rgn);
    }

    boolean isDrawing(int control) {
        return this.isVisible() && this.getDrawCount(control) == 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isTrimHandle(int trimHandle) {
        return this.handle == trimHandle;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int status = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (status == 0) {
            return status;
        }
        this.dragging = false;
        status = OS.CallNextEventHandler((int)nextHandler, (int)theEvent);
        if (this.dragging) {
            Event event = new Event();
            this.sendEvent(13, event);
        }
        this.dragging = false;
        return status;
    }

    void redraw() {
        this.redrawWidget(this.handle, false);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
    }

    void releaseChild() {
        super.releaseChild();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
        this.parent.resizeClientArea();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.visibleRgn != 0) {
            OS.DisposeRgn((int)this.visibleRgn);
        }
        this.visibleRgn = 0;
        this.parent = null;
    }

    void resetVisibleRegion(int control) {
        if (this.visibleRgn != 0) {
            OS.DisposeRgn((int)this.visibleRgn);
            this.visibleRgn = 0;
        }
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            if ((this.state & 8) == 0) {
                return;
            }
            this.state &= 0xFFFFFFF7;
            OS.EnableControl((int)this.handle);
        } else {
            if ((this.state & 8) != 0) {
                return;
            }
            this.state |= 8;
            OS.DisableControl((int)this.handle);
        }
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int minimum = OS.GetControl32BitMinimum((int)this.handle);
        if (value <= minimum) {
            return;
        }
        int viewSize = OS.GetControlViewSize((int)this.handle);
        if (value - minimum < viewSize) {
            viewSize = value - minimum;
            OS.SetControlViewSize((int)this.handle, (int)viewSize);
        }
        OS.SetControl32BitMaximum((int)this.handle, (int)(value - viewSize));
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int viewSize = OS.GetControlViewSize((int)this.handle);
        int maximum = OS.GetControl32BitMaximum((int)this.handle) + viewSize;
        if (value >= maximum) {
            return;
        }
        if (maximum - value < viewSize) {
            viewSize = maximum - value;
            OS.SetControl32BitMaximum((int)this.handle, (int)(maximum - viewSize));
            OS.SetControlViewSize((int)this.handle, (int)viewSize);
        }
        OS.SetControl32BitMinimum((int)this.handle, (int)value);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.SetControl32BitValue((int)this.handle, (int)value);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int minimum = OS.GetControl32BitMinimum((int)this.handle);
        int viewSize = OS.GetControlViewSize((int)this.handle);
        int maximum = OS.GetControl32BitMaximum((int)this.handle) + viewSize;
        value = Math.min(value, maximum - minimum);
        OS.SetControl32BitMaximum((int)this.handle, (int)(maximum - value));
        OS.SetControlViewSize((int)this.handle, (int)value);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        OS.SetControl32BitMinimum((int)this.handle, (int)minimum);
        OS.SetControl32BitMaximum((int)this.handle, (int)(maximum - thumb));
        OS.SetControlViewSize((int)this.handle, (int)thumb);
        OS.SetControl32BitValue((int)this.handle, (int)selection);
        this.increment = increment;
        this.pageIncrement = pageIncrement;
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.parent.setScrollBarVisible(this, visible);
    }

    void setZOrder() {
        OS.HIViewAddSubview((int)this.parent.scrolledHandle, (int)this.handle);
    }
}

