/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Scale
extends Control {
    int increment = 1;
    int pageIncrement = 10;

    public Scale(Composite parent, int style) {
        super(parent, Scale.checkStyle(style));
    }

    int actionProc(int theControl, int partCode) {
        this.sendEvent(13);
        Shell shell = this.getShell();
        shell.update(true);
        return 0;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x100) != 0) {
            int[] outMetric = new int[1];
            OS.GetThemeMetric((int)41, (int[])outMetric);
            height = outMetric[0];
            width = height * 10;
        } else {
            int[] outMetric = new int[1];
            OS.GetThemeMetric((int)45, (int[])outMetric);
            width = outMetric[0];
            height = width * 10;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    void createHandle() {
        int actionProc = this.display.actionProc;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner((int)this.parent.handle);
        int value = (this.style & 0x200) != 0 ? 100 : 0;
        OS.CreateSliderControl((int)window, null, (int)value, (int)0, (int)100, (int)2, (short)0, (boolean)true, (int)actionProc, (int[])outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.GetControl32BitMaximum((int)this.handle);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.GetControl32BitMinimum((int)this.handle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        int value = OS.GetControl32BitValue((int)this.handle);
        if ((this.style & 0x200) != 0) {
            int minimum = OS.GetControl32BitMinimum((int)this.handle);
            int maximum = OS.GetControl32BitMaximum((int)this.handle);
            value = maximum - value + minimum;
        }
        return value;
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        int result = super.callPaintEventHandler(control, damageRgn, visibleRgn, theEvent, nextHandler);
        int topHandle = this.topHandle();
        int parentHandle = this.parent.handle;
        OS.HIViewRemoveFromSuperview((int)topHandle);
        OS.HIViewAddSubview((int)parentHandle, (int)topHandle);
        return result;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int minimum = OS.GetControl32BitMinimum((int)this.handle);
        if (value > minimum) {
            OS.SetControl32BitMaximum((int)this.handle, (int)value);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int maximum = OS.GetControl32BitMaximum((int)this.handle);
        if (value < maximum) {
            OS.SetControl32BitMinimum((int)this.handle, (int)value);
        }
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int value) {
        this.checkWidget();
        if ((this.style & 0x200) != 0) {
            int minimum = OS.GetControl32BitMinimum((int)this.handle);
            int maximum = OS.GetControl32BitMaximum((int)this.handle);
            value = Math.min(maximum, Math.max(minimum, maximum - value + minimum));
        }
        OS.SetControl32BitValue((int)this.handle, (int)value);
    }
}

