/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.FontSelectionQDStyle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;
    boolean open;

    public FontDialog(Shell parent) {
        this(parent, 65536);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    int fontProc(int nextHandler, int theEvent, int userData) {
        int kind = OS.GetEventKind((int)theEvent);
        switch (kind) {
            case 1: {
                this.open = false;
                break;
            }
            case 2: {
                RGBColor color;
                int[] actualSize;
                short[] fontSize;
                short[] fontStyle;
                int[] fontID;
                if (this.fontData == null) {
                    this.fontData = new FontData();
                }
                if (OS.GetEventParameter((int)theEvent, (int)1635084644, (int)1835100014, null, (int)4, null, (int[])(fontID = new int[1])) == 0) {
                    int[] actualLength = new int[1];
                    OS.ATSUFindFontName((int)fontID[0], (int)1, (int)-1, (int)-1, (int)-1, (int)0, null, (int[])actualLength, null);
                    byte[] buffer = new byte[actualLength[0]];
                    OS.ATSUFindFontName((int)fontID[0], (int)1, (int)-1, (int)-1, (int)-1, (int)buffer.length, (byte[])buffer, (int[])actualLength, null);
                    String name = new String(buffer);
                    this.fontData.setName(name);
                }
                if (OS.GetEventParameter((int)theEvent, (int)1718449012, (int)1936224114, null, (int)2, null, (short[])(fontStyle = new short[1])) == 0) {
                    int style = 0;
                    if ((fontStyle[0] & 1) != 0) {
                        style |= 1;
                    }
                    if ((fontStyle[0] & 2) != 0) {
                        style |= 2;
                    }
                    this.fontData.setStyle(style);
                }
                if (OS.GetEventParameter((int)theEvent, (int)1718449018, (int)1936224114, null, (int)2, null, (short[])(fontSize = new short[1])) == 0) {
                    this.fontData.setHeight(fontSize[0]);
                }
                if (OS.GetEventParameter((int)theEvent, (int)1717791858, (int)1666336578, null, (int)6, (int[])(actualSize = new int[1]), (RGBColor)(color = new RGBColor())) != 0) break;
                int red = color.red >> 8 & 0xFF;
                int green = color.green >> 8 & 0xFF;
                int blue = color.blue >> 8 & 0xFF;
                this.rgb = new RGB(red, green, blue);
            }
        }
        return 0;
    }

    public FontData open() {
        FontSelectionQDStyle qdStyle = new FontSelectionQDStyle();
        qdStyle.version = 0;
        if (this.rgb != null) {
            qdStyle.hasColor = true;
            qdStyle.color_red = (short)(this.rgb.red * 257);
            qdStyle.color_green = (short)(this.rgb.green * 257);
            qdStyle.color_blue = (short)(this.rgb.blue * 257);
        }
        if (this.fontData != null) {
            String familyName = this.fontData.name;
            int[] font = new int[1];
            byte[] buffer = familyName.getBytes();
            if (OS.ATSUFindFontFromName((byte[])buffer, (int)buffer.length, (int)1, (int)-1, (int)-1, (int)-1, (int[])font) == 0) {
                short[] family = new short[1];
                OS.FMGetFontFamilyInstanceFromFont((int)font[0], (short[])family, (short[])new short[1]);
                qdStyle.instance_fontFamily = family[0];
            }
            int style = this.fontData.style;
            int fontStyle = 0;
            if ((style & 1) != 0) {
                fontStyle |= 1;
            }
            if ((style & 2) != 0) {
                fontStyle |= 2;
            }
            qdStyle.instance_fontStyle = (short)fontStyle;
            qdStyle.size = (short)this.fontData.height;
        }
        int ptr = OS.NewPtr((int)18);
        OS.memcpy((int)ptr, (FontSelectionQDStyle)qdStyle, (int)18);
        OS.SetFontInfoForSelection((int)1903391852, (int)1, (int)ptr, (int)0);
        OS.DisposePtr((int)ptr);
        int[] mask = new int[]{1718578804, 2, 1718578804, 1};
        Callback fontPanelCallback = new Callback(this, "fontProc", 3);
        int appTarget = OS.GetApplicationEventTarget();
        int[] outRef = new int[1];
        OS.InstallEventHandler((int)appTarget, (int)fontPanelCallback.getAddress(), (int)(mask.length / 2), (int[])mask, (int)0, (int[])outRef);
        this.fontData = null;
        this.rgb = null;
        this.open = true;
        int count = 0;
        int window = OS.GetPreviousWindow((int)0);
        while (window != 0) {
            ++count;
            window = OS.GetPreviousWindow((int)window);
        }
        int[] windows = new int[count];
        boolean[] visible = new boolean[count];
        count = 0;
        window = OS.GetPreviousWindow((int)0);
        while (window != 0) {
            windows[count] = window;
            visible[count] = OS.IsWindowVisible((int)window);
            ++count;
            window = OS.GetPreviousWindow((int)window);
        }
        OS.FPShowHideFontPanel();
        int fontsWindow = 0;
        window = OS.GetPreviousWindow((int)0);
        while (window != 0 && fontsWindow == 0) {
            if (OS.IsWindowVisible((int)window)) {
                boolean found = false;
                int i = 0;
                while (i < windows.length) {
                    if (windows[i] == window) {
                        found = true;
                        if (!visible[i]) {
                            fontsWindow = window;
                            break;
                        }
                    }
                    ++i;
                }
                if (!found) {
                    fontsWindow = window;
                    break;
                }
            }
            window = OS.GetPreviousWindow((int)window);
        }
        if (fontsWindow != 0) {
            int inModalKind = 0;
            if ((this.style & 0x8000) != 0) {
                inModalKind = 3;
            }
            if ((this.style & 0x10000) != 0) {
                inModalKind = 2;
            }
            if ((this.style & 0x20000) != 0) {
                inModalKind = 1;
            }
            if (inModalKind != 0) {
                int inUnavailableWindow = 0;
                if (this.parent != null) {
                    inUnavailableWindow = OS.GetControlOwner((int)this.parent.handle);
                }
                OS.SetWindowModality((int)fontsWindow, (int)inModalKind, (int)inUnavailableWindow);
                OS.SelectWindow((int)fontsWindow);
            }
        }
        Display display = this.parent.display;
        while (!this.parent.isDisposed() && this.open) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        OS.RemoveEventHandler((int)outRef[0]);
        fontPanelCallback.dispose();
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

