/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.carbon.OS;

public final class Font {
    public int handle;
    public short id;
    public short style;
    public short size;
    Device device;
    int atsuiStyle;

    Font() {
    }

    public Font(Device device, FontData fd) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fd == null) {
            SWT.error(4);
        }
        this.init(device, fd.getName(), fd.getHeight(), fd.getStyle());
    }

    public Font(Device device, FontData[] fds) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        int i = 0;
        while (i < fds.length) {
            if (fds[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        FontData fd = fds[0];
        this.init(device, fd.getName(), fd.getHeight(), fd.getStyle());
    }

    public Font(Device device, String name, int height, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, name, height, style);
    }

    int createStyle() {
        int[] values;
        int[] sizes;
        int[] tags;
        int[] buffer = new int[1];
        OS.ATSUCreateStyle((int[])buffer);
        if (buffer[0] == 0) {
            SWT.error(2);
        }
        int atsuStyle = buffer[0];
        short[] realStyle = new short[1];
        OS.FMGetFontFromFontFamilyInstance((short)this.id, (short)this.style, (int[])buffer, (short[])realStyle);
        boolean synthesize = this.style != realStyle[0];
        int ptr = OS.NewPtr((int)(8 + (synthesize ? 8 : 0)));
        OS.memcpy((int)ptr, (int[])new int[]{this.handle}, (int)4);
        OS.memcpy((int)(ptr + 4), (int[])new int[]{OS.X2Fix((double)this.size)}, (int)4);
        if (synthesize) {
            OS.memcpy((int)(ptr + 8), (byte[])new byte[]{(this.style & 1) != 0 ? (byte)1 : 0}, (int)1);
            OS.memcpy((int)(ptr + 9), (byte[])new byte[]{(this.style & 2) != 0 ? (byte)1 : 0}, (int)1);
            tags = new int[]{261, 262, 256, 257};
            sizes = new int[]{4, 4, 1, 1};
            values = new int[]{ptr, ptr + 4, ptr + 8, ptr + 9};
        } else {
            tags = new int[]{261, 262};
            sizes = new int[]{4, 4};
            values = new int[]{ptr, ptr + 4};
        }
        OS.ATSUSetAttributes((int)atsuStyle, (int)tags.length, (int[])tags, (int[])sizes, (int[])values);
        OS.DisposePtr((int)ptr);
        short[] types = new short[]{1, 1, 1, 1, 1, 1, 1, 1};
        short[] selectors = new short[]{1, 3, 5, 7, 9, 11, 13, 15, 17};
        OS.ATSUSetFontFeatures((int)atsuStyle, (int)types.length, (short[])types, (short[])selectors);
        return atsuStyle;
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        this.handle = 0;
        this.id = (short)-1;
        if (this.atsuiStyle != 0) {
            OS.ATSUDisposeStyle((int)this.atsuiStyle);
        }
        this.atsuiStyle = 0;
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.handle == font.handle && this.size == font.size;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] actualLength = new int[1];
        OS.ATSUFindFontName((int)this.handle, (int)1, (int)-1, (int)-1, (int)-1, (int)0, null, (int[])actualLength, null);
        byte[] buffer = new byte[actualLength[0]];
        OS.ATSUFindFontName((int)this.handle, (int)1, (int)-1, (int)-1, (int)-1, (int)buffer.length, (byte[])buffer, (int[])actualLength, null);
        String name = new String(buffer);
        int style = 0;
        if ((this.style & 2) != 0) {
            style |= 2;
        }
        if ((this.style & 1) != 0) {
            style |= 1;
        }
        FontData data = new FontData(name, this.size, style);
        return new FontData[]{data};
    }

    public static Font carbon_new(Device device, int handle, short id, short style, short size) {
        if (device == null) {
            device = Device.getDevice();
        }
        Font font = new Font();
        font.handle = handle;
        font.id = id;
        font.style = style;
        font.size = size;
        font.device = device;
        return font;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, String name, int height, int style) {
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0) {
            SWT.error(5);
        }
        int[] font = new int[1];
        byte[] buffer = name.getBytes();
        this.id = (short)-1;
        if (OS.ATSUFindFontFromName((byte[])buffer, (int)buffer.length, (int)1, (int)-1, (int)-1, (int)-1, (int[])font) == 0) {
            short[] family = new short[1];
            OS.FMGetFontFamilyInstanceFromFont((int)font[0], (short[])family, (short[])new short[1]);
            this.id = family[0];
        }
        if (this.id == -1) {
            this.id = OS.GetAppFont();
        }
        if ((style & 2) != 0) {
            this.style = (short)(this.style | 2);
        }
        if ((style & 1) != 0) {
            this.style = (short)(this.style | 1);
        }
        this.size = (short)height;
        OS.FMGetFontFromFontFamilyInstance((short)this.id, (short)this.style, (int[])font, null);
        if (font[0] == 0) {
            Font systemFont = device.systemFont;
            this.handle = systemFont.handle;
        } else {
            this.handle = font[0];
        }
        this.atsuiStyle = this.createStyle();
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

