/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.EventRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private static final String DRAGSOURCEID = "DragSource";
    static /* synthetic */ Class class$0;

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (control.getData(DRAGSOURCEID) != null) {
            DND.error(2000);
        }
        control.setData(DRAGSOURCEID, this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DragSource.this.onDispose();
            }
        });
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        this.addListener(2008, typedListener);
        this.addListener(2001, typedListener);
        this.addListener(2000, typedListener);
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drag(Event dragEvent) {
        int[] theDrag;
        block13: {
            Object var12_15;
            DNDEvent event = new DNDEvent();
            event.widget = this;
            event.time = dragEvent.time;
            event.doit = true;
            this.notifyListeners(2008, event);
            if (!event.doit || this.transferAgents == null || this.transferAgents.length == 0) {
                return;
            }
            theDrag = new int[1];
            if (OS.NewDrag((int[])theDrag) != 0) {
                event = new DNDEvent();
                event.widget = this;
                event.time = (int)System.currentTimeMillis();
                event.doit = false;
                event.detail = 0;
                this.notifyListeners(2000, event);
                return;
            }
            Point pt = new Point();
            OS.GetGlobalMouse((Point)pt);
            EventRecord theEvent = new EventRecord();
            theEvent.message = 5;
            theEvent.modifiers = (short)OS.GetCurrentEventKeyModifiers();
            theEvent.what = (short)15;
            theEvent.where_h = pt.h;
            theEvent.where_v = pt.v;
            int index = 0;
            int i = 0;
            block3: while (true) {
                if (i >= this.transferAgents.length) {
                    if (index != 0) break;
                    OS.DisposeDrag((int)theDrag[0]);
                    event = new DNDEvent();
                    event.widget = this;
                    event.time = (int)System.currentTimeMillis();
                    event.doit = false;
                    event.detail = 0;
                    this.notifyListeners(2000, event);
                    return;
                }
                int[] types = this.transferAgents[i].getTypeIds();
                int j = 0;
                while (true) {
                    if (j >= types.length) {
                        ++i;
                        continue block3;
                    }
                    TransferData transferData = new TransferData();
                    transferData.type = types[j];
                    event = new DNDEvent();
                    event.widget = this;
                    event.time = (int)System.currentTimeMillis();
                    event.dataType = transferData;
                    this.notifyListeners(2001, event);
                    this.transferAgents[i].javaToNative(event.data, transferData);
                    if (transferData.result == 0 && transferData.data != null) {
                        int k = 0;
                        while (k < transferData.data.length) {
                            byte[] data = transferData.data[k];
                            OS.AddDragItemFlavor((int)theDrag[0], (int)index++, (int)types[j], (byte[])data, (int)data.length, (int)0);
                            ++k;
                        }
                    }
                    ++j;
                }
                break;
            }
            int theRegion = 0;
            try {
                theRegion = OS.NewRgn();
                OS.SetRectRgn((int)theRegion, (short)((short)(pt.h - 10)), (short)((short)(pt.v - 10)), (short)((short)(pt.h + 10)), (short)((short)(pt.v + 10)));
                int operations = this.opToOsOp(this.getStyle());
                OS.SetDragAllowableActions((int)theDrag[0], (int)operations, (boolean)true);
                OS.SetDragAllowableActions((int)theDrag[0], (int)operations, (boolean)false);
                int result = OS.TrackDrag((int)theDrag[0], (EventRecord)theEvent, (int)theRegion);
                int operation = 0;
                if (result == 0) {
                    int[] outAction = new int[1];
                    OS.GetDragDropAction((int)theDrag[0], (int[])outAction);
                    operation = this.osOpToOp(outAction[0]);
                }
                event = new DNDEvent();
                event.widget = this;
                event.time = (int)System.currentTimeMillis();
                event.doit = result == 0;
                event.detail = operation;
                this.notifyListeners(2000, event);
            }
            catch (Throwable throwable) {
                var12_15 = null;
                if (theRegion != 0) {
                    OS.DisposeRgn((int)theRegion);
                }
                throw throwable;
            }
            {
                var12_15 = null;
                if (theRegion == 0) break block13;
            }
            OS.DisposeRgn((int)theRegion);
        }
        OS.DisposeDrag((int)theDrag[0]);
    }

    public Control getControl() {
        return this.control;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DRAGSOURCEID, null);
        this.control = null;
        this.transferAgents = null;
    }

    private int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 2;
        }
        if ((operation & 2) != 0) {
            osOperation |= 0x10;
        }
        if ((operation & 8) != 0) {
            osOperation |= 0x20;
        }
        return osOperation;
    }

    private int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 1) != 0) {
            operation |= 1;
        }
        if ((osOperation & 2) != 0) {
            operation |= 4;
        }
        if ((osOperation & 0x20) != 0) {
            operation |= 8;
        }
        if ((osOperation & 0x10) != 0) {
            operation |= 2;
        }
        if (osOperation == -1) {
            operation = 7;
        }
        return operation;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2001, listener);
        this.removeListener(2000, listener);
    }

    public void setTransfer(Transfer[] transferAgents) {
        this.transferAgents = transferAgents;
    }
}

